var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ContextMenuView } from '../../../../core/enums/common-enums';
import { UIState } from '../../../../core/enums/session-enum';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { RoutePath } from '../../../../shared/constants';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseViewerComponent } from '../../../common/base-viewer.component';
let EmailViewerComponent = class EmailViewerComponent extends BaseViewerComponent {
    constructor(cacheManager, sessionManager, dialogManager, emailService, dialog, translateService, router, integrationSettingManager, phoneManager, changeDetectorRef) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.emailService = emailService;
        this.dialog = dialog;
        this.translateService = translateService;
        this.router = router;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.changeDetectorRef = changeDetectorRef;
        this.emailBody = '';
        this.tinymceOptions = {
            base_url: '/tinymce',
            menubar: false,
            statusbar: false,
            resize: 'both',
            contextmenu: false,
            browser_spellcheck: true,
            plugins: 'image table placeholder paste autolink',
            readonly: 1,
            height: '159',
            toolbar: 'preview'
        };
        this.editorId = 'tinymceEmail' + GlobalFunctions.getGuid();
        this.emailDetailFound = this.emailDetailFound.bind(this);
    }
    ngOnInit() {
        try {
            if (!GlobalFunctions.isEmpty(this.selectedViewerEntity.CreatedById) && GlobalFunctions.isEmpty(this.selectedViewerEntity.CreatedBy)) {
                let employee = this.cacheManager.getEmployeeById(this.selectedViewerEntity.CreatedById);
                if (employee != null)
                    this.selectedViewerEntity.CreatedBy = employee.StringRepresentation;
            }
            if (!GlobalFunctions.isEmpty(this.selectedViewerEntity)) {
                let emailPartialDto = new Object();
                emailPartialDto.Header = new Object();
                let emailSource = GlobalFunctions.fetchEmailSource(this.selectedViewerEntity.Id);
                if (!GlobalFunctions.isEmpty(emailSource))
                    emailPartialDto.Header.EmailSource = emailSource;
                else if (this.selectedViewerEntity.Header != null && this.selectedViewerEntity.Header.EmailSource != null)
                    emailPartialDto.Header.EmailSource = this.selectedViewerEntity.Header.EmailSource;
                emailPartialDto.Id = this.selectedViewerEntity.Id;
                if (!GlobalFunctions.isEmpty(this.selectedViewerEntity.Mailbox))
                    emailPartialDto.Mailbox = this.selectedViewerEntity.Mailbox;
                if (this.selectedViewerEntity.Partial == true)
                    this.emailService.connect().then(() => this.emailService.fetchDetail(emailPartialDto, this.emailDetailFound));
                else {
                    this.selectedViewerEntity.Header.ToAddresses = this.selectedViewerEntity.Header.To.join();
                    this.setEmailBody(this.selectedViewerEntity);
                    this.assignHandlerName(this.selectedViewerEntity);
                }
                // this.callForRelatedRequest(this.selectedViewerEntity);
            }
            this.resize();
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    assignHandlerName(emailDto) {
        let handlerId = emailDto.Header.HandlerId;
        if (!GlobalFunctions.isEmpty(handlerId)) {
            let handlerObject = this.cacheManager.getEmployeeById(handlerId);
            if (handlerObject != null)
                emailDto.Header.HandlerName = handlerObject.StringRepresentation;
        }
    }
    loadDetailUISession(item) {
        let sessionData = JSON.parse(item.SessionObject.SessionData);
        if (sessionData != null && sessionData.UIObject != null) {
            let uiObject = sessionData.UIObject.UIObject;
            let uiState = sessionData.UIObject.UIState;
            switch (uiState) {
                case UIState.ReplyEmail:
                case UIState.ForwardEmail:
                    this.dialogManager.openEmailBasket(this.sessionManager.headerViewContainerRef, uiObject, uiState);
                    break;
            }
        }
    }
    emailDetailFound(result) {
        if (result != null) {
            this.assignHandlerName(result);
            this.selectedViewerEntity = result;
            if (this.selectedViewerEntity.Header && this.selectedViewerEntity.Header.To)
                this.selectedViewerEntity.Header.ToAddresses = this.selectedViewerEntity.Header.To.join();
            if (this.selectedViewerEntity.Header && this.selectedViewerEntity.Header.Cc)
                this.selectedViewerEntity.Header.CcAddresses = this.selectedViewerEntity.Header.Cc.join();
            this.setEmailBody(result);
            let type = GlobalFunctions.getObjectTypeName(this.selectedViewerEntity.RelatedEntityFqdn);
            let oldContentType = GlobalFunctions.toContentType(type);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, type, this.translateService, this.selectedViewerEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
            if (this.sessionManager.currentSession != null && this.sessionManager.currentSession.LoadingDetail) {
                this.sessionManager.currentSession.LoadingDetail = false;
                this.loadDetailUISession(this.sessionManager.currentSession);
            }
        }
        else {
            let helpText = "";
            if (this.sessionManager.currentSession != null && this.sessionManager.currentSession.LoadingDetail) {
                this.sessionManager.currentSession.LoadingDetail = false;
                helpText = this.translateService.instant("LBL_EMAIL_NOT_FOUND_SESSION_MESSAGE");
            }
            else
                helpText = this.translateService.instant("LBL_EMAIL_NOT_FOUND_MESSAGE");
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_EMAIL_NOT_FOUND"), helpText, this.translateService.instant("LBL_EMAIL"));
            ExceptionHelper.showException(this.dialog, exception, true);
            this.router.navigate([RoutePath.DASHBOARD]);
        }
    }
    setEmailBody(result) {
        if (result != null && result.Body != null) {
            if (result.Body.Body != null) {
                if (result.Body.IsBodyHtml || result.Body.Body.indexOf("<") > -1) {
                    let parseHtml = result.Body.Body.replace(/<head[^>]*>[\s\S]*<\/head>/gi, "");
                    parseHtml = parseHtml.replace(/<!--[^>]*-->/gi, '');
                    parseHtml = parseHtml.replace(/<![^>]*>/gi, '');
                    result.Body.Body = parseHtml;
                }
                else
                    result.Body.Body = result.Body.Body.replace(/\r\n/g, '<br/>');
                this.emailBody = result.Body.Body;
            }
        }
    }
    resize() {
        let windowHeight = $(window).height();
        let iframeElements = $('[id*="ui-tinymce-"]');
        if (iframeElements != null && iframeElements.length > 0) {
            let containerHeight = windowHeight - 580;
            $(iframeElements[0]).height(containerHeight + "px");
            let emptyBar = $('[class*="mce-toolbar-grp"]');
            if (emptyBar != null && emptyBar.length > 0)
                emptyBar[0].parentNode.removeChild(emptyBar[0]);
        }
    }
    searchAssociated(item, itemType = 0) {
        this.data = { item, itemType };
        this.changeDetectorRef.detectChanges();
    }
};
EmailViewerComponent = __decorate([
    Component({
        selector: 'email-viewer',
        templateUrl: './email-viewer.component.html',
        styleUrls: ['./email-viewer.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], EmailViewerComponent);
export { EmailViewerComponent };
//# sourceMappingURL=email-viewer.component.js.map