var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { OperationType } from '../../../../core/enums/common-enums';
import { EmailSource } from '../../../../core/enums/global-enum';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
import { BroadCastEventKeys, EntityName } from '../../../../shared/constants';
let EmailSearchResultComponent = class EmailSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, translateService, sessionManager, applicationSettingManager, sortManager, cd, activatedRoute, eventProvider, employeeService, emailService, cacheManager, changeDetectorRef, formatManager, integrationSettingManager, datePipe, searchService, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.sortManager = sortManager;
        this.cd = cd;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.employeeService = employeeService;
        this.emailService = emailService;
        this.cacheManager = cacheManager;
        this.changeDetectorRef = changeDetectorRef;
        this.formatManager = formatManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.searchService = searchService;
        this.localSearchResultDataService = localSearchResultDataService;
        this.isSearchedOnPrivateField = false;
        this.isTagFeatureEnabled = this.applicationSettingManager.tagSetting.tagList.length > 0;
        this.searchSources = [];
        this.retrieveMyEmails = false;
        this.loggedInUserId = GlobalFunctions.getLoggedInUserId();
        this.subs.sink = activatedRoute.queryParams.subscribe(queryParams => {
            if (!GlobalFunctions.isEmpty(queryParams.mailbox)) {
                const mailbox = jlinq.from(this.sessionManager.pendingCount.EmailCount).equals("Id", queryParams.mailbox).first();
                this.selectedMailbox = mailbox.MailboxId;
            }
            this.selectedOption = this.selectedOption = !GlobalFunctions.isEmpty(queryParams.filter) ? queryParams.filter : 'inbox';
        });
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = EntityName.EMAIL;
        this.resultList = [];
        this.filteredSearchResult = [];
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase().includes("email")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.searchStatusMessage = '';
            this.retrieveMyEmails = false;
            this.searchEmail();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.searchService.searchQuery = "";
    }
    searchEmail() {
        if (!GlobalFunctions.isEmpty(this.selectedOption)) {
            this.emailService.lastSelectedEmailOption = this.selectedOption;
            this.emailService.lastSelectedMailbox = this.selectedMailbox;
            this.emailService.uniqueId = "";
            switch (this.selectedOption.toUpperCase()) {
                case "ALL":
                    {
                        this.searchStatusQuery = this.translateService.instant("LBL_ALL") + " " + this.translateService.instant("LBL_EMAILS");
                        this.fetchEmailsFromService('', EmailSource.Inbox, this.emailService.lastSelectedMailbox);
                        break;
                    }
                case "MY":
                    {
                        this.retrieveMyEmails = true;
                        this.searchStatusQuery = this.translateService.instant("LBL_MY") + " " + this.translateService.instant("LBL_EMAILS");
                        this.fetchEmailsFromService('', EmailSource.Inbox, this.emailService.lastSelectedMailbox);
                        break;
                    }
                case "INBOX":
                    {
                        this.searchStatusQuery = this.searchService.searchQuery;
                        this.fetchEmailsFromService(this.searchService.searchQuery, EmailSource.Inbox, null);
                    }
                    break;
                case "ARCHIVE":
                    {
                        this.searchStatusQuery = this.searchService.searchQuery;
                        let mailbox = !GlobalFunctions.isEmpty(this.selectedMailbox) ? this.selectedMailbox : null;
                        this.fetchEmailsFromService(this.searchService.searchQuery, EmailSource.Archive, mailbox);
                        break;
                    }
            }
        }
    }
    fetchEmailsFromService(searchQuery, option, mailboxName) {
        this.updateSearchStatus(this.activeHandlersObj);
        this.emailService.fetchEmails(searchQuery, option, this.retrieveMyEmails, mailboxName, this.searchResultFound, this.searchStartedStatus, this.searchCompletedStatus);
    }
    getFulltextSearchParameters(option) {
        let emailSource = EmailSource;
        switch (option.toUpperCase()) {
            case "EMAILS":
                {
                    let item1 = new Object();
                    item1.value = emailSource.Inbox;
                    item1.text = this.translateService.instant("LBL_INBOX");
                    this.searchSources.push(item1);
                    let item2 = new Object();
                    item2.value = emailSource.Archive;
                    item2.text = this.translateService.instant("LBL_ARCHIVE");
                    this.searchSources.push(item2);
                    break;
                }
            case "ARCHIVE":
                {
                    let item3 = new Object();
                    item3.value = emailSource.Archive;
                    item3.text = this.translateService.instant("LBL_ARCHIVE");
                    this.searchSources.push(item3);
                    break;
                }
        }
    }
    hasHandleAnyRights() {
        return GlobalFunctions.hasRight(ContentType.Email, OperationType.CanHandleAnyEmail);
    }
    onEmailClick($event, emailItem) {
        let element = ($event.target);
        if (!GlobalFunctions.isEmpty(emailItem.Header.HandlerId) && !emailItem.Header.HandlerBySelf && !GlobalFunctions.hasRight(ContentType.Email, OperationType.CanHandleAnyEmail))
            return;
        if (element != null && element.type != 'checkbox') {
            super.onItemClick(emailItem);
        }
    }
    lockUnlockEmail($event, item) {
        let checkbox = $event.target;
        if (checkbox.checked) {
            let handlerObject = this.cacheManager.getEmployeeById(GlobalFunctions.getLoggedInUserId());
            item.Header.HandlerName = handlerObject.StringRepresentation;
            item.Header.HandlerId = GlobalFunctions.getLoggedInUserId();
            item.Header.HandlerBySelf = true;
            this.emailService.lockEmail(item.Id);
        }
        else {
            item.Header.HandlerName = "";
            item.Header.HandlerId = "";
            item.Header.HandlerBySelf = false;
            this.emailService.unlockEmail(item.Id);
        }
        let loggedInUserId = GlobalFunctions.getLoggedInUserId();
        let filteredResultList = [];
        for (let i = 0; i < this.resultList.length; i++) {
            if (this.resultList[i].Header.HandlerId === loggedInUserId) {
                filteredResultList.push(this.resultList[i]);
            }
        }
        let myCount = filteredResultList.length;
        if (!GlobalFunctions.isEmpty(this.sessionManager.pendingCount.EmailCount)) {
            if (!GlobalFunctions.isEmpty(this.selectedMailbox)) {
                for (let i = 0; i < this.sessionManager.pendingCount.EmailCount.length; i++) {
                    if (this.sessionManager.pendingCount.EmailCount[i].MailboxId.toLowerCase() === this.selectedMailbox.toLowerCase()) {
                        this.sessionManager.pendingCount.EmailCount[i].MyCount = myCount;
                    }
                }
            }
            else {
                this.sessionManager.pendingCount.EmailCount[0].MyCount = myCount;
            }
        }
        ;
    }
};
EmailSearchResultComponent = __decorate([
    Component({
        selector: 'email-search-result',
        templateUrl: './email-search-result.component.html',
        styleUrls: ['./email-search-result.component.scss']
    })
], EmailSearchResultComponent);
export { EmailSearchResultComponent };
//# sourceMappingURL=email-search-result.component.js.map