var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { EmailSource } from '../../../../core/enums/global-enum';
import { SearchDto } from '../../../../core/models/common/searchDto';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
let EmailSearchCriteriaComponent = class EmailSearchCriteriaComponent {
    constructor(translateService, sessionManager, applicationSettingManager, searchService, activatedRoute, router) {
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.searchService = searchService;
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.contactType = 'Email';
        this.DateJS = new Date();
        this.searchText = '';
        this.advancedSearchMatrix = [];
        this.searchDto = new SearchDto;
        this.searchPlaceholder = this.applicationSettingManager.getSearchDescriptionText(ContentType.Email);
        this.showSearchSources = false;
        this.searchSources = [];
        this.subs = new SubSink();
        this.subs.sink = activatedRoute.queryParams.subscribe(queryParams => {
            this.selectedMailbox = !GlobalFunctions.isEmpty(queryParams.mailbox) ? queryParams.mailbox : '';
            this.selectedOption = !GlobalFunctions.isEmpty(queryParams.filter) ? queryParams.filter : 'emails';
            this.ngOnInit();
        });
    }
    ngOnInit() {
        try {
            this.searchSources = [];
            this.searchEmails();
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    searchEmails() {
        this.getFulltextSearchParameters(this.selectedOption);
        this.showSearchSources = (this.searchSources.length > 1) ? true : false;
        this.selectedSearchSource = this.searchSources[0].value;
        if (!GlobalFunctions.isEmpty(document.getElementById('searchTextBox')))
            document.getElementById('searchTextBox').focus();
    }
    getFulltextSearchParameters(option) {
        let emailSource = EmailSource;
        switch (option.toUpperCase()) {
            case "EMAILS":
                {
                    let item1 = new Object();
                    item1.value = emailSource.Inbox;
                    item1.text = this.translateService.instant("LBL_INBOX");
                    this.searchSources.push(item1);
                    let item2 = new Object();
                    item2.value = emailSource.Archive;
                    item2.text = this.translateService.instant("LBL_ARCHIVE");
                    this.searchSources.push(item2);
                    break;
                }
            case "ARCHIVE":
                {
                    let item3 = new Object();
                    item3.value = emailSource.Archive;
                    item3.text = this.translateService.instant("LBL_ARCHIVE");
                    this.searchSources.push(item3);
                    break;
                }
        }
    }
    search(searchText, option) {
        if (this.validateForm()) {
            this.searchService.searchQuery = searchText;
            let selectedSearchOption = {
                searchType: 'email',
                searchQuery: searchText,
                searchFrom: 'dashboard',
                filter: EmailSource[option].toString().toLowerCase(),
                mailboxId: this.selectedMailbox
            };
            this.searchService.searchOptionChanged(selectedSearchOption);
        }
    }
    validateForm() {
        return this.form.valid;
    }
};
__decorate([
    ViewChild('form')
], EmailSearchCriteriaComponent.prototype, "form", void 0);
EmailSearchCriteriaComponent = __decorate([
    Component({
        selector: 'email-search-criteria',
        templateUrl: './email-search-criteria.component.html',
        styleUrls: ['./email-search-criteria.component.scss']
    })
], EmailSearchCriteriaComponent);
export { EmailSearchCriteriaComponent };
//# sourceMappingURL=email-search-criteria.component.js.map