var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { RecordSelection } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { SubSink } from 'subsink';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { EmailSource } from '../../../../core/enums/global-enum';
import { CaseObjectDto } from '../../../../core/models/case/case-objectDto';
import { EntityName, RoutePath } from '../../../../shared/constants';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
let LinkEmailToCaseComponent = class LinkEmailToCaseComponent extends BaseDialogComponent {
    constructor(activatedRoute, translateService, sessionManager, eventProvider, applicationSettingManager, caseService, shortcutManager, integrationSettingManager, dialogManager, router, phoneManager, documentService, dialog, dialogRef) {
        super();
        this.activatedRoute = activatedRoute;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.caseService = caseService;
        this.shortcutManager = shortcutManager;
        this.integrationSettingManager = integrationSettingManager;
        this.dialogManager = dialogManager;
        this.router = router;
        this.phoneManager = phoneManager;
        this.documentService = documentService;
        this.dialog = dialog;
        this.dialogRef = dialogRef;
        this.relatedEmailTab = EmailSource.Inbox;
        this.linkType = 'CaseEntity';
        this.linkTypeError = '';
        this.fetchingDocumentType = false;
        this.docMethod = null;
        this.linkTypeTags = [];
        this.documentType = '';
        this.subs = new SubSink();
        this.linkToCaseResponseReceived = this.linkToCaseResponseReceived.bind(this);
        this.onDocumentTypesSuccessResponse = this.onDocumentTypesSuccessResponse.bind(this);
    }
    ngOnInit() {
        try {
            this.openSearchPopup(this.linkType);
            this.caseService.setLinkToCaseCallbacks(this.linkToCaseResponseReceived);
            this.shortcutManager.bind("LBL_SHORTCUT_SAVE_BUTTON", () => this.linkEmailToCase());
            let getDocumentMethodSettings = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Documents_Entities_Document, "DOCUMENTMETHOD");
            if (!GlobalFunctions.isEmpty(getDocumentMethodSettings)) {
                this.docMethod = getDocumentMethodSettings;
                this.assignSettingToUI(this.docMethod);
            }
            else
                console.log("Document integration setting is empty");
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    assignSettingToUI(docMethod) {
        switch (docMethod) {
            case "0":
                this.documentMethodSetting = 'Document';
                this.documentMethod = 'Document';
                break;
            case "1":
                this.documentMethodSetting = 'CaseBaseDocument';
                this.documentMethod = 'CaseBaseDocument';
                break;
            case "2":
                this.documentMethodSetting = 'Both';
                this.documentMethod = 'Document';
                break;
        }
    }
    searchLinkType() {
        this.openSearchPopup(this.linkType);
    }
    openSearchPopup(entity) {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: entity, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            if (!GlobalFunctions.isEmpty(searchEntity)) {
                GlobalFunctions.setPlaceholder("#linkTypeControl", "");
                this.linkTypeTags = [];
                searchEntity.StringRepresentation = searchEntity.Description;
                searchEntity.text = searchEntity.StringRepresentation;
                this.caseEntity = searchEntity;
                this.linkTypeTags.push(searchEntity);
                this.getDocumentTypes(searchEntity.CaseTypeId);
            }
        });
    }
    linkEmailToCase() {
        if (this.linkTypeTags.length > 0) {
            if (this.documentMethod == 'CaseBaseDocument') {
                let error = false;
                if (GlobalFunctions.isEmpty(this.documentType)) {
                    $('#selectDocumentType').addClass('error');
                    error = true;
                }
                else
                    $('#selectDocumentType').removeClass('error');
                if (error)
                    return;
            }
            this.startSpinner();
            this.linkTypeError = '';
            let caseObjectDto = new CaseObjectDto();
            caseObjectDto.ObjectId = this.sessionManager.selectedEntity.Id;
            caseObjectDto.ObjectType = this.sessionManager.selectedEntity.RelatedEntityFqdn;
            this.caseService.linkToCase(this.caseEntity, caseObjectDto, this.documentType);
        }
        else
            this.linkTypeError = "LBL_MSG_EMPTY_CASE";
    }
    onDocumentTypesSuccessResponse(getDocumentTypeList) {
        if (getDocumentTypeList.length > 0)
            this.documentTypeList = getDocumentTypeList;
        this.FetchingDocumentType = false;
    }
    getDocumentTypes(caseTypeId) {
        if (!GlobalFunctions.isEmpty(caseTypeId)) {
            this.FetchingDocumentType = true;
            this.documentService.getDocumentTypes(caseTypeId, this.onDocumentTypesSuccessResponse);
        }
    }
    linkToCaseResponseReceived(response) {
        this.stopSpinner();
        console.log('LinkEmailToCaseController->linkToCaseResponseReceived:', response);
        if (response.Result == 0) {
            this.loadLastSelectedSearchResult();
            this.processArchive(response);
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = this.caseEntity;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.CASEENTITY}`;
            this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, RoutePath.DETAIL_PATH);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
            this.close();
        }
        else
            this.linkTypeError = "LBL_MESSAGE_LINK_TO_ENTITY_FAILED";
    }
    loadLastSelectedSearchResult() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.BreadcrumbItems)) {
            for (let index = 0; index < this.sessionManager.BreadcrumbItems.length; index++) {
                if (!GlobalFunctions.isEmpty(this.sessionManager.BreadcrumbItems[index]) && this.sessionManager.BreadcrumbItems[index][0].itemData.ObjectSource.indexOf("Email") != -1 &&
                    this.sessionManager.BreadcrumbItems[index][0].itemData != null && this.sessionManager.BreadcrumbItems[index][0].itemData.StringRepresentation == this.sessionManager.selectedEntity.StringRepresentation) {
                    this.sessionManager.BreadcrumbItems[index][0].itemData.isDeleted = true;
                    this.sessionManager.BreadcrumbItems.splice(index, 1);
                    break;
                }
            }
        }
    }
    processArchive(response) {
        if (this.sessionManager.selectedEntity != null) {
            if (this.applicationSettingManager.isArchiveMailOptionRequired()) {
                if (GlobalFunctions.isEmpty(response.ArchivedEmailId))
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_FAILED_TO_ARCHIVE_EMAIL") });
                else {
                    this.sessionManager.selectedEntity.Id = response.ArchivedEmailId;
                    if (this.sessionManager.selectedEntity.Header != null) {
                        this.sessionManager.selectedEntity.Header.Id = response.ArchivedEmailId;
                        this.sessionManager.selectedEntity.Header.Uid = response.ArchivedEmailId;
                        this.sessionManager.selectedEntity.Header.EmailSource = EmailSource.Archive;
                    }
                }
            }
            else
                this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
        }
    }
    changeDocumentMethod(docMethod) {
        this.documentMethod = docMethod;
    }
    changeDocumentType(docType) {
        this.documentType = docType;
    }
    close() {
        this.dialogRef.close();
    }
};
LinkEmailToCaseComponent = __decorate([
    Component({
        selector: 'link-email-to-case',
        templateUrl: './link-email-to-case.component.html',
        styleUrls: ['./link-email-to-case.component.scss']
    })
], LinkEmailToCaseComponent);
export { LinkEmailToCaseComponent };
//# sourceMappingURL=link-email-to-case.component.js.map