var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDetailComponent } from 'src/app/components/common/base-detail.component';
import { ContextMenuView, ScreenMode } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu } from 'src/app/core/models/common/menu';
import { BroadCastEventKeys, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { EmailMemoComponent } from '../memo/email-memo.component';
import { UIState } from '../../../../core/enums/session-enum';
let EmailDetailComponent = class EmailDetailComponent extends BaseDetailComponent {
    constructor(router, sessionManager, changeDetectorRef, dialog, contextMenuService, emailService, systemComponentService, cacheManager, eventProvider, integrationSettingManager, phoneManager, dialogManager, translateService, viewContainerRef) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.sessionManager = sessionManager;
        this.changeDetectorRef = changeDetectorRef;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.emailService = emailService;
        this.systemComponentService = systemComponentService;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.viewContainerRef = viewContainerRef;
        this.emailBody = '';
        this.tinymceOptions = {
            base_url: '/tinymce',
            menubar: false,
            statusbar: false,
            resize: 'both',
            contextmenu: false,
            browser_spellcheck: true,
            plugins: 'link image table autolink',
            readonly: 1,
            height: "400",
            toolbar: 'preview',
            default_link_target: '_blank',
            setup: function (editor) {
                editor.on('init', function () {
                    editor.getBody().setAttribute('contenteditable', false);
                    // Inline CSS styles within the editor to remove extra white spaces
                    editor.dom.addStyle('.mce-content-body p { margin: 0; padding: 0; }');
                    editor.dom.addStyle('.mce-content-body br { line-height: 1; }');
                    editor.dom.addStyle('.mce-content-body a { pointer-events: auto !important; cursor: pointer;}');
                    // Allow normal link behavior
                    editor.getBody().addEventListener('click', e => {
                        const href = e?.target?.closest('a')?.href;
                        if (href)
                            window.open(href, this.default_link_target);
                    });
                });
            }
        };
        this.editorId = 'tinymceEmail' + GlobalFunctions.getGuid();
        this.emailDetailFound = this.emailDetailFound.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadEmailDetail();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    searchAssociated(item, itemType = 0) {
        this.data = { item, itemType };
        this.changeDetectorRef.detectChanges();
    }
    loadEmailDetail() {
        try {
            this.menu.addOrUpdateMenuItem(0, "EmailDetail", this.translateService.instant("LBL_EMAIL"), false, true, true);
            this.addMenuItem.emit(this.menu);
            this.sessionManager.startSessionIfPossible("EMAIL", ScreenMode.Detail);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
                let emailPartialDto = new Object();
                emailPartialDto.Header = new Object();
                let emailSource = GlobalFunctions.fetchEmailSource(this.sessionManager.selectedEntity.Id);
                if (!GlobalFunctions.isEmpty(emailSource))
                    emailPartialDto.Header.EmailSource = emailSource;
                else if (this.sessionManager.selectedEntity.Header != null && this.sessionManager.selectedEntity.Header.EmailSource != null)
                    emailPartialDto.Header.EmailSource = this.sessionManager.selectedEntity.Header.EmailSource;
                emailPartialDto.Id = this.sessionManager.selectedEntity.Id;
                if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Mailbox))
                    emailPartialDto.Mailbox = this.sessionManager.selectedEntity.Mailbox;
                if (this.sessionManager.selectedEntity.Partial == true)
                    this.emailService.fetchDetail(emailPartialDto, this.emailDetailFound);
                else {
                    this.sessionManager.selectedEntity.Header.ToAddresses = this.sessionManager.selectedEntity.Header.To.join();
                    this.setEmailBody(this.sessionManager.selectedEntity);
                    this.assignHandlerName(this.sessionManager.selectedEntity);
                    this.setLookingOn();
                }
                this.setLookingOn();
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    setLookingOn() {
        try {
            if (this.sessionManager.selectedEntity && this.sessionManager.selectedEntity.Header)
                this.sessionManager.selectedEntity.Header.LookingOn = GlobalFunctions.getLoggedInUserId();
            this.systemComponentService.lockEntity(this.sessionManager.selectedEntity.Id, this.sessionManager.selectedEntity.RelatedEntityFqdn, null);
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    assignHandlerName(emailDto) {
        let handlerId = emailDto.Header.HandlerId;
        if (!GlobalFunctions.isEmpty(handlerId)) {
            let handlerObject = this.cacheManager.getEmployeeById(handlerId);
            if (handlerObject != null)
                emailDto.Header.HandlerName = handlerObject.StringRepresentation;
        }
    }
    ;
    loadDetailUISession(item) {
        let sessionData = JSON.parse(item.SessionObject.SessionData);
        if (sessionData != null && sessionData.UIObject != null) {
            let uiObject = sessionData.UIObject.UIObject;
            let uiState = sessionData.UIObject.UIState;
            switch (uiState) {
                case UIState.ReplyEmail:
                case UIState.ForwardEmail:
                    this.dialogManager.openEmailBasket(this.viewContainerRef, uiObject, uiState);
                    break;
            }
        }
    }
    ;
    setEmailBody(result) {
        if (result != null && result.Body != null) {
            if (result.Body.Body != null) {
                if (result.Body.IsBodyHtml || result.Body.Body.indexOf("<") > -1) {
                    let parseHtml = result.Body.Body.replace(/<head[^>]*>[\s\S]*<\/head>/gi, "");
                    parseHtml = parseHtml.replace(/<!--[^>]*-->/gi, '');
                    parseHtml = parseHtml.replace(/<![^>]*>/gi, '');
                    result.Body.Body = parseHtml;
                }
                else
                    result.Body.Body = result.Body.Body.replace(/\r\n/g, '<br/>');
                this.emailBody = result.Body.Body;
            }
        }
    }
    openLinkView(type, clickedFrom) {
        this.dialogManager.openLinkContactInfo(type, clickedFrom);
    }
    emailDetailFound(result) {
        if (result != null) {
            this.assignHandlerName(result);
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = result;
            this.sessionManager.selectedEntity.Header.ToAddresses = this.sessionManager.selectedEntity.Header?.To?.join();
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header.Cc))
                this.sessionManager.selectedEntity.Header.CcAddresses = this.sessionManager.selectedEntity.Header?.Cc?.join();
            this.setEmailBody(result);
            if (this.sessionManager.currentSession != null && this.sessionManager.currentSession.LoadingDetail) {
                this.sessionManager.currentSession.LoadingDetail = false;
                this.loadDetailUISession(this.sessionManager.currentSession);
            }
            this.sendRelatedRequest.emit();
            this.setLookingOn();
        }
        else {
            let helpText = "";
            if (this.sessionManager.currentSession != null && this.sessionManager.currentSession.LoadingDetail) {
                this.sessionManager.currentSession.LoadingDetail = false;
                helpText = this.translateService.instant("LBL_EMAIL_NOT_FOUND_SESSION_MESSAGE");
            }
            else
                helpText = this.translateService.instant("LBL_EMAIL_NOT_FOUND_MESSAGE");
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_EMAIL_NOT_FOUND"), helpText, this.translateService.instant("LBL_EMAIL"));
            ExceptionHelper.showException(this.dialog, exception, true);
            if (this.sessionManager.selectedEntity != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Id)) {
                this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
                if (!GlobalFunctions.isEmpty(this.sessionManager.BreadcrumbItems)) {
                    for (let i = 0; i < this.sessionManager.BreadcrumbItems.length; i++) {
                        if (!GlobalFunctions.isEmpty(this.sessionManager.BreadcrumbItems[i]) && this.sessionManager.BreadcrumbItems[i][0] && this.sessionManager.BreadcrumbItems[i][0].itemData != null && this.sessionManager.BreadcrumbItems[i][0].itemData.Id == this.sessionManager.selectedEntity.Id)
                            this.sessionManager.BreadcrumbItems[i][0].isDeleted = true;
                    }
                }
            }
            this.router.navigate([RoutePath.DASHBOARD]);
        }
        ;
    }
    addMemo() {
        DialogHelper.openDialog(this.dialog, EmailMemoComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    ;
};
EmailDetailComponent = __decorate([
    Component({
        selector: 'email-detail',
        templateUrl: './email-detail.component.html',
        styleUrls: ['./email-detail.component.scss'],
    })
], EmailDetailComponent);
export { EmailDetailComponent };
//# sourceMappingURL=email-detail.component.js.map