var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener } from '@angular/core';
import { ContactTypeOption, DateCompareType, ScreenMode, StringCompareType } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { AdvancedSearchItem } from '../../../../core/models/common/advance-serach-item';
import { DateCriteriaDto } from '../../../../core/models/common/date-criteria';
import { EnumCriteriaDto } from '../../../../core/models/common/enum-criteria';
import { SearchDto } from '../../../../core/models/common/searchDto';
import { StringCriteriaDto } from '../../../../core/models/common/string-criteria';
import { ContactHistorySearchField, ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { CommonHelper } from '../../../../shared/helper/common-helper';
import { JkcDatePickerHelper } from '../../../../shared/helper/jkc-date-picker-helper';
let ContactHistorySearchCriteriaComponent = class ContactHistorySearchCriteriaComponent {
    constructor(translateService, sessionManager, cacheManager, applicationSettingManager, integrationSettingManager, searchService, router, datePipe, renderer, dateAdapter) {
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.cacheManager = cacheManager;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.searchService = searchService;
        this.router = router;
        this.datePipe = datePipe;
        this.renderer = renderer;
        this.dateAdapter = dateAdapter;
        this.datePickerClosed = true;
        this.contactType = 'ContactHistory';
        this.DateJS = new Date();
        this.searchText = '';
        this.advancedSearchMatrix = [];
        this.searchDto = new SearchDto;
        this.tags = [];
        this.handlerTags = [];
        this.availableTags = [];
        this.tagCompareType = '0';
        this.searchPlaceholder = this.applicationSettingManager.getSearchDescriptionText(ContentType.ContactMoment);
        this.validationMessage = '';
        this.searchSlowMessage = '';
        this.isViewerPinned = (this.sessionManager.jkcViewerPanel !== null && this.sessionManager.jkcViewerPanel.parameters.IsPanelPinned);
        this.dateSearch = { 'Option': "0", 'DateField': "Registration", 'FromDate': null, 'ToDate': null };
        this.timeoutIds = [];
        this.dateClass = (cellDate, view) => {
            const day = cellDate.getDate();
            this.timeoutIds.push(setTimeout(() => GlobalFunctions.formatDaysWithLeadingZeros()));
            // handle UI representation of day
            if (!GlobalFunctions.isEmpty(view) && view.toLowerCase() == 'month')
                return (day >= 1 && day <= 9) ? 'custom-cell' : '';
        };
    }
    ;
    ngOnInit() {
        try {
            this.initAdvanceSearchMatrix();
            this.initializeDateRangeOption();
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    changeVisibility(advancedSearchItem) {
        advancedSearchItem.IsToDateInputBoxEnabled = false;
        advancedSearchItem.SearchCriteria.TypeOfCompareType[advancedSearchItem.SearchCriteria.CompareType].criteriaChanged = true;
        if (advancedSearchItem.IsCalenderEnabled && advancedSearchItem.SearchCriteria.CompareType === 5)
            advancedSearchItem.IsToDateInputBoxEnabled = true;
    }
    ;
    loadTags(event) {
        this.availableTags = this.applicationSettingManager.tagSetting.searchTagByQuery(event.target.value, false);
    }
    ;
    initializeDateRangeOption() {
        this.dateSearch.Option = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_ContactHistory_Entities_ContactHistory, "DEFAULTSEARCHDATERANGE");
        this.changeDateOption();
    }
    initAdvanceSearchMatrix() {
        let contactHistoryAdvancedSearchItem = null;
        //Id
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_ID";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = "Id";
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Customer Name
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CUSTOMER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.ContactPerson;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Handler
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_HANDLER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.Handler;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Case Number 
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CASE_NUMBER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.CaseNumber;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Role
        if (this.applicationSettingManager.isCustomerOM()) {
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CUSTOMER_ROLE";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.CustomerRole;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        }
        //Channel
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new EnumCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CHANNEL";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
        contactHistoryAdvancedSearchItem.SearchCriteria.Value = -1;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.ContactType;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "NumericCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.IsComboBoxEnabled = true;
        contactHistoryAdvancedSearchItem.ComboBoxValues = [];
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": -1, "Text": "ALL" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 1, "Text": "PHONE" });
        if (GlobalFunctions.checkRights('Email'))
            contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 2, "Text": "EMAIL" });
        if (GlobalFunctions.checkRights('SocialMedia') && this.sessionManager.isSocialMediaFeatureEnabled) {
            contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 13, "Text": "FACEBOOK" });
            contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 14, "Text": "TWITTER" });
            contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 15, "Text": "WHATSAPP" });
        }
        if (GlobalFunctions.checkRights('Chat') && this.sessionManager.isChatFeatureEnabled)
            contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 12, "Text": "CHAT" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 8, "Text": "CALLBACKNOTE" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 7, "Text": "APPOINTMENT" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 16, "Text": "ASSIGNMENT" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 17, "Text": "REPORTIMPROVEMENT" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 10, "Text": "INFORMATIONREQUEST" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 6, "Text": "CALLBACKATTEMPT" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 4, "Text": "COUNTER" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 3, "Text": "LETTER" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 11, "Text": "VOICEMAIL" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 18, "Text": "VISIT" });
        contactHistoryAdvancedSearchItem.ComboBoxValues.push({ "Value": 0, "Text": "NONE" });
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Question
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_QUESTION";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.Question;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Answer
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_ANSWER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.Answer;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Assigned Mailbox
        if (this.cacheManager.getTaskMailboxList(false).length > 0) {
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_ASSIGNED_MAILBOX";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.AssignedMailbox;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
            contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        }
    }
    ;
    changeDateOption() {
        switch (this.dateSearch.Option) {
            case "0":
                {
                    this.dateSearch.FromDate = null;
                    this.dateSearch.ToDate = null;
                    break;
                }
            case "1":
                {
                    this.dateSearch.FromDate = new Date();
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "2":
                {
                    const fromDate = new Date();
                    fromDate.setDate(fromDate.getDate() - 1);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = fromDate;
                    break;
                }
            case "3":
                {
                    const fromDate = new Date();
                    fromDate.setDate(fromDate.getDate() - 1);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "4":
                {
                    const fromDate = new Date();
                    fromDate.setDate(fromDate.getDate() - 7);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "5":
                {
                    const fromDate = new Date();
                    fromDate.setDate(fromDate.getDate() - 30);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
        }
        this.clickedOut();
    }
    ;
    search(searchText, empName, empId, avoidSearchFilterOption = false) {
        this.searchService.advancedSearchQuery = '';
        {
            if (!GlobalFunctions.isEmpty(empName) || this.validate()) {
                this.sessionManager.startSessionIfPossible(this.contactType.toLowerCase(), ScreenMode.List);
                if (!GlobalFunctions.isEmpty(searchText)) {
                    this.prepareSearchDto(searchText);
                    this.searchSlowMessage = this.translateService.instant("LBL_SEARCH_WARNING_MESSAGE");
                }
                else
                    this.prepareSearchDto();
                this.searchService.advanceSearch({ searchDto: this.searchDto, searchFrom: 'dashboard', searchType: this.contactType.toLowerCase() });
            }
        }
    }
    ;
    prepareSearchDto(query = null) {
        this.searchDto.StringCriteriaList = [];
        this.searchDto.NumericCriteriaList = [];
        this.searchDto.DateCriteriaList = [];
        this.searchDto.EnumCriteriaList = [];
        this.searchService.advancedSearchQuery = '';
        let searchContentType = new Object();
        searchContentType._ContentType = this.contactType;
        searchContentType.SearchCriteriaField = [];
        for (let item in this.advancedSearchMatrix) {
            if (!GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].SearchCriteria.Value)) {
                if (this.advancedSearchMatrix[item].SearchCriteria.TypeOfCompareType[this.advancedSearchMatrix[item].SearchCriteria.CompareType].criteriaChanged) {
                    let searchField = new Object();
                    searchField._Name = this.advancedSearchMatrix[item].SearchCriteria.Name;
                    searchField._Value = this.advancedSearchMatrix[item].SearchCriteria.CompareType;
                    searchContentType.SearchCriteriaField.push(searchField);
                }
                if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                    this.searchService.advancedSearchQuery += ' , ';
                this.setAdvancedSearchQuery(this.advancedSearchMatrix[item].SearchCriteria, this.advancedSearchMatrix[item].TypeOfSearchCriteria);
                switch (this.advancedSearchMatrix[item].TypeOfSearchCriteria) {
                    case 'StringCriteria':
                        this.searchDto.StringCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'NumericCriteria':
                        this.searchDto.NumericCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'DateCriteria':
                        this.searchDto.DateCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'EnumCriteria':
                        this.searchDto.EnumCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                }
            }
        }
        //Handler
        if (this.handlerTags != undefined && this.handlerTags != null && this.handlerTags.length > 0) {
            let handlerSearchCriteria = new StringCriteriaDto();
            handlerSearchCriteria.IsInUse = true;
            handlerSearchCriteria.DisplayName = "LBL_HANDLER";
            handlerSearchCriteria.Name = ContactHistorySearchField.Handler;
            handlerSearchCriteria.CompareType = 1;
            handlerSearchCriteria.Value = "";
            let handlerList = "";
            for (let i = 0; i < this.handlerTags.length; i++) {
                handlerSearchCriteria.Value += "'" + this.handlerTags[i].Id + "',";
                handlerList += "'" + this.handlerTags[i].text + "',";
            }
            this.searchDto.StringCriteriaList.push(handlerSearchCriteria);
            if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                this.searchService.advancedSearchQuery += ' , ';
            this.searchService.advancedSearchQuery += "{" + this.translateService.instant("LBL_HANDLER") + "}: " + (handlerList.slice(0, -1));
        }
        //Tag
        if (this.tags != null && this.tags.length > 0) {
            let tagSearchCriteria = new StringCriteriaDto();
            tagSearchCriteria.Name = ContactHistorySearchField.Tags;
            tagSearchCriteria.CompareType = this.tagCompareType == "0" ? StringCompareType.Like : StringCompareType.EqualsTo;
            tagSearchCriteria.Value = "";
            for (let index = 0; index < this.tags.length; index++) {
                if (index == this.tags.length - 1)
                    tagSearchCriteria.Value += this.tags[index].Id;
                else
                    tagSearchCriteria.Value += this.tags[index].Id + ";";
            }
            this.searchDto.StringCriteriaList.push(tagSearchCriteria);
        }
        //Date
        if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate) && !GlobalFunctions.isEmpty(this.dateSearch.ToDate)) {
            let dateSearchCriteria = new DateCriteriaDto();
            dateSearchCriteria.CompareType = DateCompareType.Between;
            if (this.dateSearch.DateField === "Registration") {
                dateSearchCriteria.DisplayName = "LBL_REGISTRATION_DATE";
                dateSearchCriteria.Name = ContactHistorySearchField.StartDate;
            }
            else {
                dateSearchCriteria.Name = ContactHistorySearchField.EndDate;
                dateSearchCriteria.DisplayName = "LBL_HANDLED_DATE";
            }
            dateSearchCriteria.Value = this.dateSearch.FromDate.toString('M/d/yyyy HH:mm:ss');
            dateSearchCriteria.ToDate = this.dateSearch.ToDate.toString('M/d/yyyy HH:mm:ss');
            this.searchDto.DateCriteriaList.push(dateSearchCriteria);
            if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                this.searchService.advancedSearchQuery += ' , ';
            this.setAdvancedSearchQuery(dateSearchCriteria, "DateCriteria");
        }
        //Description
        if (!GlobalFunctions.isEmpty(query)) {
            let descriptionSearchCriteria = new StringCriteriaDto();
            descriptionSearchCriteria.Name = ContactHistorySearchField.Description;
            descriptionSearchCriteria.CompareType = StringCompareType.Like;
            descriptionSearchCriteria.Value = query;
            this.searchDto.StringCriteriaList.push(descriptionSearchCriteria);
        }
    }
    ;
    setAdvancedSearchQuery(searchDto, TypeOfSearchCriteria) {
        try {
            let criteria;
            searchDto.TypeOfCompareType.forEach((value, key) => {
                if (key != null && key == searchDto.CompareType)
                    criteria = value.Text;
            });
            let searchQuery;
            let searchDtoToDate;
            if (TypeOfSearchCriteria == "DateCriteria") {
                searchQuery = this.datePipe.transform(searchDto.Value, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                searchQuery = GlobalFunctions.removeDotAfterMonth(searchQuery);
                if (searchDto.CompareType == "5") {
                    searchDtoToDate = this.datePipe.transform(searchDto.ToDate, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                    searchDtoToDate = GlobalFunctions.removeDotAfterMonth(searchDtoToDate);
                    searchQuery += " - " + searchDtoToDate;
                }
            }
            if (searchDto.Name == ContactHistorySearchField.ContactType)
                searchQuery = searchQuery ? searchQuery : ContactTypeOption[searchDto.Value];
            else
                searchQuery = searchQuery ? searchQuery : searchDto.Value;
            this.searchService.advancedSearchQuery += '{' + this.translateService.instant(searchDto.DisplayName) + '} ' + this.translateService.instant("LBL_" + criteria.toUpperCase()) + " " + "'" + searchQuery + "'" + " ";
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    changeStartDate(inputId) {
        GlobalFunctions.setDateFormat(inputId, this.dateSearch.FromDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        if (this.dateSearch.Option === "0" && !GlobalFunctions.isEmpty(this.dateSearch.FromDate) && GlobalFunctions.isEmpty(this.dateSearch.ToDate))
            this.dateSearch.ToDate = this.dateSearch.FromDate;
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    clickedOut() {
        //date format will not change when click outside.
        this.timeoutIds.push(setTimeout(() => {
            if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate))
                GlobalFunctions.setDateFormat("selectStartDatePicker", this.dateSearch.FromDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            if (!GlobalFunctions.isEmpty(this.dateSearch.ToDate))
                GlobalFunctions.setDateFormat("selectEndDatePicker", this.dateSearch.ToDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        }, 10));
    }
    validate() {
        let count = 0;
        this.validationMessage = undefined;
        for (let item in this.advancedSearchMatrix) {
            if (this.advancedSearchMatrix[item].IsRequired)
                break;
            if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].SearchCriteria.Value) || this.advancedSearchMatrix[item].SearchCriteria.Value == -1) {
                this.advancedSearchMatrix[item].SearchCriteria.Value = null;
                count++;
            }
        }
        if (count >= this.advancedSearchMatrix.length) {
            if (this.tags.length === 0 && GlobalFunctions.isEmpty(this.dateSearch.FromDate) && GlobalFunctions.isEmpty(this.dateSearch.ToDate))
                this.validationMessage = this.translateService.instant("LBL_EMPTY_ADVANCED_SEARCH_ERROR");
        }
        else {
            for (let item in this.advancedSearchMatrix) {
                if (this.advancedSearchMatrix[item].SearchCriteria.Value != undefined && this.advancedSearchMatrix[item].SearchCriteria.Value != "") {
                    if (this.advancedSearchMatrix[item].TypeOfSearchCriteria != "DateCriteria") {
                        if (this.advancedSearchMatrix[item].SearchCriteria.CompareType != 0 && this.advancedSearchMatrix[item].SearchCriteria.Value.length < 3) {
                            this.validationMessage = this.translateService.instant("LBL_QUERY_LENGTH_ADVANCED_SEARCH_ERROR");
                            break;
                        }
                    }
                    if (this.advancedSearchMatrix[item].RegularExpressionValidator != null) {
                        if (!this.isValid(this.advancedSearchMatrix[item].SearchCriteria.Value, this.advancedSearchMatrix[item].RegularExpressionValidator)) {
                            this.validationMessage = this.advancedSearchMatrix[item].ValidationMessage;
                            break;
                        }
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate) || !GlobalFunctions.isEmpty(this.dateSearch.ToDate)) {
            if (GlobalFunctions.isEmpty(this.dateSearch.FromDate))
                this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
            else if (GlobalFunctions.isEmpty(this.dateSearch.ToDate))
                this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
            else if (this.dateSearch.ToDate < this.dateSearch.FromDate)
                this.validationMessage = this.translateService.instant("LBL_INVALID_DATE_BETWEEN_ERROR");
        }
        else
            this.validationMessage = this.translateService.instant("LBL_REPORT_HELP_TEXT4");
        return this.validationMessage == undefined ? true : false;
    }
    ;
    isValid(searchQuery, validFormat) {
        return searchQuery.match(validFormat) != null;
    }
    ;
    initDatePickerState(event, inputId) {
        this.clickedOut();
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
    }
    sortComboBoxValues() {
        this.advancedSearchMatrix.forEach(item => {
            if (item.ComboBoxValues) {
                item.ComboBoxValues.sort((a, b) => {
                    const aTranslatedText = this.translateService.instant('LBL_' + a.Text);
                    const bTranslatedText = this.translateService.instant('LBL_' + b.Text);
                    return aTranslatedText.localeCompare(bTranslatedText);
                });
            }
        });
    }
};
__decorate([
    HostListener("document:click")
], ContactHistorySearchCriteriaComponent.prototype, "clickedOut", null);
ContactHistorySearchCriteriaComponent = __decorate([
    Component({
        selector: 'contact-history-search-criteria',
        templateUrl: './contact-history-search-criteria.component.html',
        styleUrls: ['./contact-history-search-criteria.component.scss']
    })
], ContactHistorySearchCriteriaComponent);
export { ContactHistorySearchCriteriaComponent };
//# sourceMappingURL=contact-history-search-criteria.component.js.map