var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from '../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { ContactHistoryPopupComponent } from '../popup/contact-history-popup.component';
let ContactHistoryPrivacySearchResultComponent = class ContactHistoryPrivacySearchResultComponent extends BaseSearchResultComponent {
    constructor(dialog, activatedRoute, contactHistoryService, searchService, applicationSettingManager, changeDetectorRef, employeeService, eventProvider, router, noteService, sessionManager, sortManager, translateService, datePipe, cacheManager, formatManager, integrationSettingManager) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.dialog = dialog;
        this.activatedRoute = activatedRoute;
        this.contactHistoryService = contactHistoryService;
        this.searchService = searchService;
        this.applicationSettingManager = applicationSettingManager;
        this.changeDetectorRef = changeDetectorRef;
        this.employeeService = employeeService;
        this.eventProvider = eventProvider;
        this.router = router;
        this.noteService = noteService;
        this.sessionManager = sessionManager;
        this.sortManager = sortManager;
        this.translateService = translateService;
        this.datePipe = datePipe;
        this.cacheManager = cacheManager;
        this.formatManager = formatManager;
        this.integrationSettingManager = integrationSettingManager;
        this.bulkDeleteContactHistoryResponse = this.bulkDeleteContactHistoryResponse.bind(this);
        this.markNeverDeleteResponse = this.markNeverDeleteResponse.bind(this);
    }
    ngOnInit() {
        try {
            this.contactHistoryService.setRecentHistoryCallbacks(this.searchResultFound, this.updateSearchStatus);
            this.searchStatusQuery = this.searchService.advancedSearchQuery;
            this.advanceSearchContactHistory();
            this.sessionManager.contextMenu = new ContextMenu('', 'CONTACTHISTORY', this.translateService, null, GlobalFunctions.getLoggedInUserId(), ContextMenuView.SearchList, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    advanceSearchContactHistory() {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.updateSearchStatus(this.activeHandlersObj);
        this.contactHistoryService.advancedSearch(this.searchService.advancedSearchOption.searchDto, false, this.searchPrivateFieldValidationResponseFound);
    }
    selectAll(event) {
        this.resultList.forEach(value => value.IsMarked = event.target.checked);
    }
    ;
    show(selectedEntity) {
        DialogHelper.openDialog(this.dialog, ContactHistoryPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { selectedEntity });
    }
    ;
    executeMenuItem(key) {
        if (key == "DELETE")
            this.delete();
        else if (key == "NEVERDELETE")
            this.neverDelete();
    }
    ;
    delete() {
        let idList = this.getMarkedItemIdList();
        if (idList.length > 0) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: GlobalFunctions.formatStringValue(this.translateService.instant("LBL_MSG_DELETE_CONTACT_HISTORY"), [idList.length]), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (result)
                    this.contactHistoryService.bulkDeleteContactHistory(idList, this.bulkDeleteContactHistoryResponse);
            });
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: this.translateService.instant("LBL_MSG_DELETE_NO_CONTACT_HISTORY") });
    }
    ;
    bulkDeleteContactHistoryResponse(response) {
        switch (response.Result) {
            case 0:
                let notification = this.cacheManager.getNotificationForPrivacyContactHistory();
                if (notification != null)
                    this.noteService.deleteNote(notification.NoteEntity, () => this.router.navigate([RoutePath.DASHBOARD]));
                else
                    this.router.navigate([RoutePath.DASHBOARD]);
                break;
            case 1:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: this.translateService.instant("LBL_MSG_DELETE_FAIL_CONTACT_HISTORY") }).afterClosed().subscribe(() => this.advanceSearchContactHistory());
                break;
        }
    }
    ;
    neverDelete() {
        let idList = this.getMarkedItemIdList();
        if (idList.length > 0) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: GlobalFunctions.formatStringValue(this.translateService.instant("LBL_MSG_NEVER_DELETE_CONTACT_HISTORY"), [idList.length]), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (result)
                    this.contactHistoryService.markDeleteStateContactHistory(idList, true, this.markNeverDeleteResponse);
            });
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: this.translateService.instant("LBL_MSG_NEVER_DELETE_NO_CONTACT_HISTORY") });
    }
    ;
    markNeverDeleteResponse(response) {
        switch (response.Result) {
            case 0:
                this.advanceSearchContactHistory();
                break;
            case 1:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: this.translateService.instant("LBL_MSG_NEVER_DELETE_FAIL_CONTACT_HISTORY") }).afterClosed().subscribe(() => this.advanceSearchContactHistory());
                break;
        }
    }
    ;
    getMarkedItemIdList() {
        let idList = [];
        this.resultList.forEach(value => {
            if (value.IsMarked != null && value.IsMarked)
                idList.push(value.Id);
        });
        return idList;
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        let newHeight = windowHeight - 150 + "px";
        $("#dashBoardItemDivFlow").height(newHeight);
    }
};
ContactHistoryPrivacySearchResultComponent = __decorate([
    Component({
        selector: 'contact-history-privacy-search-result',
        templateUrl: './contact-history-privacy-search-result.component.html',
        styleUrls: ['./contact-history-privacy-search-result.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ContactHistoryPrivacySearchResultComponent);
export { ContactHistoryPrivacySearchResultComponent };
//# sourceMappingURL=contact-history-privacy-search-result.component.js.map