var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { OperationType } from '../../../../core/enums/common-enums';
import { ContactHistoryMomentDto } from '../../../../core/models/contact-history/contact-history-momentDto';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { EntityFqdn } from 'src/app/core/enums/core-enums';
let ContactHistoryEditComponent = class ContactHistoryEditComponent extends BaseDialogComponent {
    constructor(translateService, dialogManager, sessionManager, dialog, integrationSettingManager, contactHistoryService, applicationSettingManager, shortcutManager, eventProvider, router) {
        super();
        this.translateService = translateService;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.integrationSettingManager = integrationSettingManager;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.shortcutManager = shortcutManager;
        this.eventProvider = eventProvider;
        this.router = router;
        this.dateTimeFormatPicker = this.sessionManager.defaultOptions.defaultDateFormat;
        this.title = this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_CONTACT_HISTORY").toUpperCase();
        this.linkRelatedTitle = this.translateService.instant("LBL_CLICK_UNLINK_ITEM_FROM_CONTACT_HISTORY");
        this.questionList = [];
        this.customerRoles = [];
        this.answerList = [];
        this.questionIndex = 0;
        this.roleIndex = 0;
        this.answerIndex = 0;
        this.questionListOriginalLength = 0;
        this.answerListOriginalLength = 0;
        this.contactHistoryDto = new ContactHistoryMomentDto();
        this.contactHistoryDtoCache = new ContactHistoryMomentDto();
        this.enableQuestionValidation = false;
        this.enableAnswerValidation = false;
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.genders = [
            { genderValue: "Male", genderText: this.translateService.instant("LBL_MALE") },
            { genderValue: "Female", genderText: this.translateService.instant("LBL_FEMALE") },
            { genderValue: "Unknown", genderText: this.translateService.instant("LBL_UNKNOWN") }
        ];
        this.rights = {
            chat: false,
            email: false,
            socialMedia: false
        };
        this.filteredLinkedRelatedList = [];
        this.allowUnlinkingRelations = false;
        this.editContactHistoryRelatedErrorCallback = this.editContactHistoryRelatedErrorCallback.bind(this);
        this.contactQuestionAnswerReceived = this.contactQuestionAnswerReceived.bind(this);
    }
    ngOnInit() {
        this.setRights();
        if (GlobalFunctions.isEmpty(this.integrationSettingManager.contactQuestionAnswerList)) {
            this.startSpinner();
            this.contactHistoryService.fetchContactQuestionAnswerList(this.contactQuestionAnswerReceived);
        }
        else
            this.initialize();
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    setRights() {
        this.rights.chat = GlobalFunctions.checkRights('Chat');
        this.rights.email = GlobalFunctions.checkRights('Email');
        this.rights.socialMedia = GlobalFunctions.checkRights('SocialMedia');
    }
    contactQuestionAnswerReceived(response) {
        //stopSpinner();
        this.integrationSettingManager.contactQuestionAnswerReceived(response);
        this.initialize();
    }
    ;
    initialize() {
        this.resize();
        this.setDefaultQuestion();
        this.setDefaultAnswer();
        this.setDefaultRoles();
        this.setEditDto();
        this.registerDialogShortcutKey();
    }
    ;
    setDefaultQuestion() {
        this.questionList = this.integrationSettingManager.getQuestions();
        this.changeQuestionOption(false);
    }
    ;
    setDefaultAnswer() {
        this.answerList = this.integrationSettingManager.getAnswers(this.questionList[this.questionIndex]);
        this.changeAnswerOption(false);
    }
    ;
    setDefaultRoles() {
        let roleList = this.integrationSettingManager.roleSetting.roleList;
        if (roleList != null && roleList.length > 0) {
            for (let index = 0; index < roleList.length; index++)
                this.customerRoles.push(roleList[index].Name);
            if (GlobalFunctions.isEmpty(this.contactHistoryDto.CustomerRole))
                this.contactHistoryDto.CustomerRole = this.customerRoles[this.roleIndex];
            this.changeCustomerRoleOption();
        }
    }
    ;
    changeCustomerRoleOption() {
        this.contactHistoryDto.CustomerRole = this.customerRoles[this.roleIndex];
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind("LBL_SHORTCUT_SAVE_BUTTON", () => this.saveContactHistory());
    }
    changeQuestionOption(isFromSelection) {
        if (isFromSelection)
            this.contactHistoryDto.Subject = this.questionList[this.questionIndex];
        else {
            let index = this.questionList.indexOf(this.sessionManager.selectedEntity.Subject);
            this.questionIndex = index < 0 ? 0 : index;
        }
        this.enableQuestionValidation = (this.questionList.length == (this.questionIndex + 1));
        let answerList = this.integrationSettingManager.getAnswers(this.questionList[this.questionIndex]);
        if (!GlobalFunctions.isEmpty(answerList) && answerList.length > 0) {
            this.answerList = answerList;
            this.answerIndex = 0;
            this.changeAnswerIndex(this.answerIndex);
        }
    }
    ;
    changeQuestionIndex(Index) {
        this.contactHistoryDto.Subject = this.questionList[Index];
        this.questionIndex = Index;
        this.enableQuestionValidation = (this.questionList.length == (this.questionIndex + 1));
    }
    ;
    changeAnswerIndex(Index) {
        this.contactHistoryDto.Memo = this.answerList[Index];
        this.answerIndex = Index;
        this.enableAnswerValidation = (this.answerList.length == (this.answerIndex + 1));
    }
    ;
    changeAnswerOption(isFromSelection) {
        this.contactHistoryDto.Memo = this.answerList[this.answerIndex];
        this.enableAnswerValidation = (this.answerList.length == (this.answerIndex + 1));
    }
    ;
    resize() {
        const windowHeight = window.innerHeight;
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 5 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#editContactHistoryHeader").height() - $("#editContactHistoryFooter").height() + "px";
        $("#editContactHistoryContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        newHeight = windowHeight - $("#editContactHistoryHeader").height() - $("#editContactHistoryFooter").height() - 59 + "px";
        $("#editContactHistoryContainer").height(newHeight);
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close();
    }
    showMessageBox(header, message) {
        const messageInfo = DialogHelper.getMessage(header, message, true, null, null, null, null, this.translateService);
        return DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
    }
    checkPresence(arrayList, value) {
        let index = 0;
        if (arrayList != null && arrayList.length > 0 && value != undefined) {
            value = value.replace("\n", "");
            for (let i = 0; i < arrayList.length; i++) {
                arrayList[i] = arrayList[i].replace("\n", "");
                if (arrayList[i].toLowerCase() == value.toLowerCase()) {
                    index = i;
                    break;
                }
            }
        }
        return index;
    }
    answerOperation(arrayList, value) {
        let index = arrayList.length - 1;
        if (arrayList != null && arrayList.length > 0) {
            for (let i = 0; i < arrayList.length; i++) {
                if (arrayList[i].Answer.toLowerCase() == value.toLowerCase()) {
                    index = i;
                    break;
                }
            }
        }
        return index;
    }
    ;
    saveContactHistory() {
        if (this.validate()) {
            this.contactHistoryDto.Memo = !GlobalFunctions.isEmpty(this.contactHistoryDto.Memo.Answer) ? this.contactHistoryDto.Memo.Answer : this.contactHistoryDto.Memo;
            // To save only linked related list (Person & Organisation) 
            if (this.allowUnlinkingRelations && this.filteredLinkedRelatedList != null) {
                this.contactHistoryDto.ObjectDtos = this.contactHistoryDto.ObjectDtos.filter(item => !(item.ObjectType == 'Decos.Kcs.Persons.Entities.Person') && !(item.ObjectType == 'Decos.Kcs.Organizations.Entities.Organization'));
                this.contactHistoryDto.ObjectDtos.push(...this.filteredLinkedRelatedList);
            }
            this.contactHistoryService.createContactMoment(this.contactHistoryDto, this.editContactHistoryRelatedErrorCallback);
            this.sessionManager.selectedEntity = this.contactHistoryDto;
            if (this.router.url === this.sessionManager.selectedEntity.locationUrl)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
            this.close();
        }
    }
    ;
    validate() {
        let isValid = this.form.valid;
        if (!this.validateQuestionAnswer() || this.contactHistoryDto === undefined)
            isValid = false;
        return isValid;
    }
    editContactHistoryRelatedErrorCallback(status) {
        if (status == 1) {
            let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CONTACT_HISTORY"), [this.translateService.instant("LBL_CONTACT_HISTORY")]);
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_CONTACT_HISTORY"));
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    ;
    validateQuestionAnswer() {
        let questionRemarkNode = document.getElementById('contentQuestionFreeText');
        let answerRemarkNode = document.getElementById('contentAnswerFreeText');
        let isValid = true;
        if (questionRemarkNode && answerRemarkNode) {
            this.contactHistoryDto.SubjectFreeText = questionRemarkNode.innerHTML.toString();
            this.contactHistoryDto.MemoFreeText = answerRemarkNode.innerHTML.toString();
            if (GlobalFunctions.isEmpty(this.contactHistoryDto.SubjectFreeText) && this.enableQuestionValidation) {
                $('#contentQuestionFreeText').addClass('error');
                isValid = false;
            }
            else
                $('#contentQuestionFreeText').removeClass('error');
            if (GlobalFunctions.isEmpty(this.contactHistoryDto.MemoFreeText) && this.enableAnswerValidation) {
                $('#contentAnswerFreeText').addClass('error');
                isValid = false;
            }
            else
                $('#contentAnswerFreeText').removeClass('error');
        }
        return isValid;
    }
    setEditDto() {
        if (GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Subject)) {
            this.questionIndex = this.questionList.length - 1;
            this.sessionManager.selectedEntity.Subject = this.questionList[this.questionList.length - 1];
        }
        else
            this.questionIndex = this.checkPresence(this.questionList, this.sessionManager.selectedEntity.Subject);
        this.questionListOriginalLength = this.questionList.length - 1;
        this.answerIndex = this.answerOperation(this.answerList, this.sessionManager.selectedEntity.Memo);
        if (this.answerIndex == (this.answerList.length - 1) && this.answerList[this.answerList.length - 1].Answer.toLowerCase() != this.sessionManager.selectedEntity.Memo.toLowerCase()) {
            this.sessionManager.selectedEntity.MemoFreeText = this.sessionManager.selectedEntity.Memo;
            this.sessionManager.selectedEntity.Memo = this.answerList[this.answerList.length - 1].Answer;
        }
        this.answerListOriginalLength = this.answerList.length - 1;
        this.roleIndex = this.checkPresence(this.customerRoles, this.sessionManager.selectedEntity.CustomerRole);
        this.contactHistoryDto = Object.assign({}, this.sessionManager.selectedEntity);
        this.contactHistoryDtoCache = Object.assign({}, this.contactHistoryDto);
        this.enableQuestionValidation = this.questionIndex == this.questionListOriginalLength ? true : false;
        this.enableAnswerValidation = this.answerIndex == this.answerListOriginalLength ? true : false;
        // To list down related list (Person & Organisation) 
        let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_ContactHistory_Entities_ContactHistory, "ISALLOWTOREMOVECONTACTRELATIONS");
        if (!GlobalFunctions.isEmpty(result))
            this.allowUnlinkingRelations = result.toUpperCase() === "TRUE";
        if (this.allowUnlinkingRelations && this.sessionManager.selectedEntity.ObjectDtos?.length > 0) {
            this.sessionManager.selectedEntity.ObjectDtos.forEach(item => {
                if (item.ObjectType == ContentType.Person || item.ObjectType == ContentType.Organization) {
                    item.StringRepresentation = item.ObjectTitle;
                    this.filteredLinkedRelatedList.push(item);
                }
            });
        }
    }
    remove(content) {
        if (!GlobalFunctions.isEmpty(content?.Id)) {
            const index = this.filteredLinkedRelatedList.indexOf(content);
            if (index !== -1)
                this.filteredLinkedRelatedList.splice(index, 1);
        }
    }
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], ContactHistoryEditComponent.prototype, "form", void 0);
ContactHistoryEditComponent = __decorate([
    Component({
        selector: 'contact-history-edit',
        templateUrl: './contact-history-edit.component.html',
        styleUrls: ['./contact-history-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ContactHistoryEditComponent);
export { ContactHistoryEditComponent };
//# sourceMappingURL=contact-history-edit.component.js.map