var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { interval } from 'rxjs';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { ChatMessageType, ChatReplyBy, ChatState, OperationType, ScreenMode } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { SubSink } from 'subsink';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { AudioManager } from '../../../../core/manager/audio-manager';
import { ChatHistoryDto } from '../../../../core/models/chat/chat-historyDto';
import { ChatDto } from '../../../../core/models/chat/chatDto';
import { TaskDtoSource } from '../../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let ChatMessengerComponent = class ChatMessengerComponent extends BaseDialogComponent {
    constructor(viewContainerRef, eventProvider, translateService, employeeService, personService, organizationService, sessionManager, sessionService, applicationFeatureManager, chatService, integrationSettingManager, applicationSettingManager, dialogManager, dialog, zone, router) {
        super();
        this.viewContainerRef = viewContainerRef;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.employeeService = employeeService;
        this.personService = personService;
        this.organizationService = organizationService;
        this.sessionManager = sessionManager;
        this.sessionService = sessionService;
        this.applicationFeatureManager = applicationFeatureManager;
        this.chatService = chatService;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.dialogManager = dialogManager;
        this.dialog = dialog;
        this.zone = zone;
        this.router = router;
        this.chatMessageToSend = new ChatHistoryDto();
        this.chatDto = new ChatDto();
        this.chatHistoryList = [];
        this.chatResizeTitle = this.translateService.instant("LBL_MINIMIZE");
        this.isChatWindowMinimized = false;
        this.showCustomerResolveMessage = false;
        this.showCustomerLink = false;
        this.resolvedCustomerType = "";
        this.maxTimeRinging = 5;
        this.ringingTime = 0;
        this.timer = 0;
        this.timerPromise = null;
        this.idleTimer = 60;
        this.audio = new AudioManager(false);
        this.dialogBox = null;
        this.subs = new SubSink();
        this.checkLiveState = 1;
        this.checkLiveStateTimeout = null;
        this.checkLiveStateInternal = 5000;
        this.timeoutIds = [];
        this.checkLiveStateResponse = this.checkLiveStateResponse.bind(this);
        this.searchCustomerResponse = this.searchCustomerResponse.bind(this);
        this.sendMessageResponseReceived = this.sendMessageResponseReceived.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.CLEAR_SESSION).subscribe(() => {
            this.chatService.resetChat();
            this.stopTimer();
            this.stopCheckLiveState();
        });
    }
    ngOnInit() {
        try {
            this.chatDto = this.chatService.chatMessage;
            this.chatDto.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Chat_Entities_Chat;
            this.sessionManager.addItemsToDetailViewCacheList(jQuery.extend(true, {}, this.chatDto), GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Chat_Entities_Chat]), true);
            this.chatService.chatMessageCallbacks(this.sendMessageResponseReceived);
            this.sessionManager.startSessionIfPossible("CHAT", ScreenMode.Add);
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = this.chatService.chatMessage.UserName;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.chatService.chatMessage.UserMobileNumber;
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail = this.chatService.chatMessage.UserEmailAddress;
            if (this.chatDto.ResolvedCustomer != null && this.chatDto.ResolvedCustomer != undefined)
                this.resolveCustomer(this.chatDto.ResolvedCustomer);
            else
                this.showCustomerLink = !GlobalFunctions.isEmpty(this.chatDto.UserEmailAddress);
            this.chatMessageToSend.Message = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "CHATWELCOMEMESSAGE");
            this.sendMessage(ChatMessageType.Welcome);
            this.setActionMenu();
            this.setIdleTimer();
            this.startCheckLiveState();
            this.resize();
            this.timeoutIds.push(setTimeout(() => {
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Chat";
            }, 100));
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    ngOnDestroy() {
        this.stopTimer();
        this.stopCheckLiveState();
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    ;
    sendMessage(messageType) {
        if (!GlobalFunctions.isEmpty(this.chatDto) && !GlobalFunctions.isEmpty(this.chatMessageToSend.Message)) {
            this.chatMessageToSend.UserName = !GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee) ? this.employeeService.loggedInEmployee.FirstName : "";
            this.chatMessageToSend.ChatId = this.chatDto.Id;
            this.chatMessageToSend.MessageDateTime = new Date();
            this.chatMessageToSend.ReplyBy = ChatReplyBy.Handler;
            this.chatMessageToSend.MessageType = GlobalFunctions.isEmpty(messageType) ? ChatMessageType.Normal : messageType;
            this.chatMessageToSend.Message = GlobalFunctions.encodeHtml(this.chatMessageToSend.Message);
            let chatDtoToSend = jQuery.extend(true, {}, this.chatDto);
            chatDtoToSend.ChatHistoryList = new Array();
            chatDtoToSend.ChatHistoryList.push(this.chatMessageToSend);
            this.chatService.sendMessage(chatDtoToSend);
            this.chatMessageToSend.MessageDateTime = new Date();
            this.chatHistoryList.push(this.chatMessageToSend);
            this.chatMessageToSend = new ChatHistoryDto();
            this.timeoutIds.push(setTimeout(() => this.scrollToBottomOfChatAndFocus()));
        }
    }
    ;
    sendMessageResponseReceived(response) {
        if (!GlobalFunctions.isEmpty(response) && !GlobalFunctions.isEmpty(response.ChatDto) && !GlobalFunctions.isEmpty(response.ChatDto.ChatHistoryList)) {
            this.chatHistoryList.push(response.ChatDto.ChatHistoryList[0]);
            this.populateTags(response.ChatDto);
            this.parseContactDetail(response.ChatDto);
        }
        this.timeoutIds.push(setTimeout(() => this.scrollToBottomOfChatAndFocus()));
    }
    ;
    endChat() {
        if (this.dialogBox === null) {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_CHAT"), this.translateService.instant("LBL_STOP_HANDLING_CONFIRMATION"), true, null, null, null, null, this.translateService);
            this.dialogBox = DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
            this.dialogBox.afterClosed().subscribe(result => {
                if (result) {
                    this.chatDto.State = ChatState.Ended;
                    this.chatMessageToSend.Message = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "CHATENDMESSAGE");
                    this.sendMessage(ChatMessageType.End);
                    this.sessionManager.contactSessionNotesState.isContactSessionNotesHighlighted = true;
                    this.chatService.resetChat();
                    this.stopTimer();
                    this.stopCheckLiveState();
                }
                this.dialogBox = null;
            });
        }
    }
    ;
    resetChatPosition() {
        this.isChatWindowMinimized = !this.isChatWindowMinimized;
        let chatPanelElement = $("#chatPanel");
        if (chatPanelElement != null) {
            if (this.isChatWindowMinimized) {
                chatPanelElement.css({ 'height': '35px', 'top': ($(window).height() - 36) + 'px', 'left': '0' });
                this.chatResizeTitle = this.translateService.instant("LBL_MAXIMIZE");
                this.startTimer();
            }
            else {
                chatPanelElement.css({ 'top': ($(window).height() - $("#chatForm").height() - $("#chatHeader").height() - 10) + 'px' });
                let newHeight = $("#chatForm").height() + $("#chatHeader").height();
                chatPanelElement.css({ 'height': newHeight + 'px' });
                this.chatResizeTitle = this.translateService.instant("LBL_MINIMIZE");
                this.stopTimer();
            }
        }
        this.timeoutIds.push(setTimeout(() => this.isChatWindowMinimized));
    }
    ;
    linkCustomer(phoneNumber, emailAddress) {
        if (this.dialogBox == null) {
            this.dialogBox = this.dialogManager.updateContactDetail(phoneNumber, emailAddress);
            this.dialogBox.afterClosed().subscribe(result => this.dialogBox = null);
        }
    }
    ;
    startTimer() {
        this.stopTimer();
        this.timerPromise = interval(1000).subscribe(x => {
            this.timer += 1;
            if (this.timer > this.idleTimer) {
                if (this.ringingTime <= this.maxTimeRinging && !this.sessionManager.isWindowActive) {
                    this.ringingTime += 1;
                    this.audio.play();
                }
                else
                    this.audio.stop();
                if (this.timer % 2 === 0)
                    $("#chatHeader").css("background-color", "darkgray");
                else
                    $("#chatHeader").css("background-color", this.checkLiveState == 0 ? "rgb(198, 0, 0)" : "rgb(0, 123, 97)");
            }
        });
    }
    ;
    stopTimer() {
        if (this.timerPromise != null)
            this.timerPromise.unsubscribe();
        this.timer = 0;
        this.ringingTime = 0;
        this.audio.stop();
        $("#chatHeader").css("background-color", this.checkLiveState == 0 ? "rgb(198, 0, 0)" : "rgb(0, 123, 97)");
        this.timerPromise = null;
    }
    ;
    openDialog(screenName) {
        if (screenName === "LBL_CALLBACK_NOTE")
            this.dialogManager.openJsPanelOrDialog("ADD_CALLBACKNOTE", null, null, null, this.viewContainerRef);
        else if (screenName === "LBL_INFORMATIONREQUEST")
            this.dialogManager.openJsPanelOrDialog("ADD_INFORMATIONREQUEST", null, null, null, this.viewContainerRef);
    }
    ;
    scrollToBottomOfChatAndFocus() {
        this.timeoutIds.push(setTimeout(() => {
            let chatBodyElement = $('#chatBody');
            if (chatBodyElement && chatBodyElement[0])
                chatBodyElement.scrollTop(chatBodyElement[0].scrollHeight);
            $("#chatMessageTextId").focus();
        }));
    }
    ;
    populateTags(chatDto) {
        chatDto.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Chat_Entities_Chat;
        let newTags = [];
        this.sessionManager.contactSessionNotesState.Tags = this.applicationSettingManager.tagSetting.getPossibleTags(this.sessionManager.contactSessionNotesState.Tags, chatDto, newTags);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.TAGS_SELECTED, newTags);
    }
    ;
    parseContactDetail(chatDto) {
        let chatHistory = chatDto.ChatHistoryList[0];
        if (chatHistory != null && !GlobalFunctions.isEmpty(chatHistory.Message)) {
            if (chatHistory.MessageType == ChatMessageType.CustomerFound)
                chatHistory.ResolvedCustomer = chatDto.ResolvedCustomer;
            else {
                let emailsArray = chatHistory.Message.match(/\S+[a-z0-9]@[a-z0-9\.]+/img);
                if (emailsArray != null && emailsArray.length > 0) {
                    chatHistory.MessageType = ChatMessageType.ContactDetail;
                    chatHistory.EmailAddress = emailsArray[0];
                }
                let phoneArray = chatHistory.Message.match(/\d+/);
                let countryCode = this.applicationSettingManager.getApplicationSettingValueByKey("PHONECOUNTRYCODE");
                if (phoneArray != null && phoneArray.length > 0 && GlobalFunctions.isValidPhonenumber(phoneArray[0], countryCode)) {
                    chatHistory.MessageType = ChatMessageType.ContactDetail;
                    chatHistory.PhoneNumber = phoneArray[0];
                }
            }
        }
    }
    ;
    setActionMenu() {
        this.actionMenus = new Array();
        if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Task"), OperationType.Add, TaskDtoSource.CallbackNotes))
            this.actionMenus.push("LBL_CALLBACK_NOTE");
        if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Task"), OperationType.Add, TaskDtoSource.InformationRequest))
            this.actionMenus.push("LBL_INFORMATIONREQUEST");
    }
    ;
    setIdleTimer() {
        this.idleTimer = parseInt(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "IDLETIMER"));
        if (!GlobalFunctions.isEmpty(this.idleTimer))
            this.idleTimer = (+this.idleTimer);
        else
            this.idleTimer = 60;
    }
    ;
    resize() {
        this.timeoutIds.push(setTimeout(() => {
            let chatPanelElement = $("#chatPanel");
            if (chatPanelElement != null) {
                chatPanelElement.css({ 'top': ($(window).height() - $("#chatForm").height() - $("#chatHeader").height() - 20) + 'px', 'position': 'fixed' });
                let newHeight = $("#chatForm").height() + $("#chatHeader").height();
                chatPanelElement.css({ 'height': newHeight + 'px' });
            }
        }, 500));
    }
    ;
    searchCustomerResponse(customer) {
        this.showCustomerResolveMessage = false;
        if (customer != null) {
            customer.locationUrl = `${RoutePath.DETAIL_PATH}/${this.resolvedCustomerType}`;
            this.sessionManager.selectedEntity = customer;
            this.sessionManager.addBreadcrumbItems([customer], customer, this.router.url);
            this.zone.run(() => this.router.navigate([customer.locationUrl]));
        }
    }
    ;
    resolveCustomer(resolvedCustomer) {
        if (resolvedCustomer != null && resolvedCustomer != undefined) {
            let partialDto = new Object();
            partialDto.Id = resolvedCustomer.Id;
            ;
            partialDto.ObjectSource = resolvedCustomer.Source;
            if (resolvedCustomer.Type === 9) {
                this.resolvedCustomerType = "person";
                this.personService.fetchDetail(partialDto, this.searchCustomerResponse);
            }
            else {
                this.resolvedCustomerType = "organization";
                this.organizationService.fetchDetail(partialDto, this.searchCustomerResponse);
            }
            this.showCustomerResolveMessage = true;
        }
    }
    ;
    startCheckLiveState() {
        this.checkLiveStateInternal = this.getCheckLiveStateInterval();
        this.checkLiveStateTimeout = setInterval(() => {
            this.checkLiveState = this.checkLiveState == 1 ? -1 : 0;
            this.chatService.checkLiveState(this.chatDto.UserConnectionId, this.checkLiveStateResponse);
        }, this.checkLiveStateInternal);
    }
    ;
    checkLiveStateResponse() {
        this.checkLiveState = 1;
    }
    ;
    stopCheckLiveState() {
        if (this.checkLiveStateTimeout != null)
            clearInterval(this.checkLiveStateTimeout);
    }
    ;
    getCheckLiveStateInterval() {
        let checkLiveStateTime = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "CHECKLIVESTATEINTERVAL");
        if (GlobalFunctions.isEmpty(checkLiveStateTime))
            checkLiveStateTime = 10000;
        else
            checkLiveStateTime = checkLiveStateTime * 1000;
        return checkLiveStateTime;
    }
    ;
};
ChatMessengerComponent = __decorate([
    Component({
        selector: 'chat-messenger',
        templateUrl: './chat-messenger.component.html',
        styleUrls: ['./chat-messenger.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ChatMessengerComponent);
export { ChatMessengerComponent };
//# sourceMappingURL=chat-messenger.component.js.map