var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { ChatState } from 'src/app/core/enums/common-enums';
import { PhoneStatus } from 'src/app/core/enums/phone-enum';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { AudioManager } from '../../../../core/manager/audio-manager';
import { interval } from 'rxjs';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { RoutePath } from '../../../../shared/constants';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
let ChatIncomingComponent = class ChatIncomingComponent extends BaseDialogComponent {
    constructor(translateService, phoneManager, sessionManager, chatManager, sessionService, applicationFeatureManager, chatService, integrationSettingManager, dialog, router) {
        super();
        this.translateService = translateService;
        this.phoneManager = phoneManager;
        this.sessionManager = sessionManager;
        this.chatManager = chatManager;
        this.sessionService = sessionService;
        this.applicationFeatureManager = applicationFeatureManager;
        this.chatService = chatService;
        this.integrationSettingManager = integrationSettingManager;
        this.dialog = dialog;
        this.router = router;
        this.audioPlayer = new AudioManager(false);
        this.isPhoneStateChanged = false;
        this.timerPromise = null;
        this.timer = 0;
        this.transferChatTimer = 0;
        this.userName = "";
        this.timeoutIds = [];
        this.stopTimerForIncomingPopup = () => {
            if (this.timerPromise != null) {
                this.timerPromise.unsubscribe(this.timerPromise);
                this.timer = 0;
                this.timerPromise = null;
            }
        };
        this.setPhoneStatus = () => {
            if (this.phoneManager.phoneState.PhoneAvailableStatus != PhoneStatus.NotAvailable) {
                this.phoneManager.updatePhoneAvailabilityStatus(PhoneStatus.NotAvailable);
                this.isPhoneStateChanged = true;
            }
        };
        this.replyIncomingChatResponse = this.replyIncomingChatResponse.bind(this);
    }
    ngOnInit() {
        this.init();
        this.timeoutIds.push(setTimeout(() => {
            if (!this.sessionManager.isSessionStart) {
                $("#acceptButton").focus();
            }
            else {
                $("#keepSessionButton").focus();
            }
        }, 1));
    }
    ngOnDestroy() {
        if (this.timerPromise != null)
            this.timerPromise.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    ;
    closeActiveModal() {
        DialogHelper.closeDialog();
    }
    ;
    keepSession() {
        this.sessionService.keepSession(this.sessionManager, this.applicationFeatureManager, this.translateService, null, this.createSessionErrorCallback);
        this.acceptChat();
    }
    ;
    ignoreSession() {
        this.closeActiveModal();
        if (!this.sessionManager.isActive(`/${RoutePath.DASHBOARD}`))
            this.router.navigate([RoutePath.DASHBOARD]);
        this.acceptChat();
    }
    ;
    acceptChat() {
        this.replyIncomingChat(ChatState.Accepted);
    }
    ;
    ignoreChat() {
        this.replyIncomingChat(ChatState.Ignored);
    }
    ;
    replyIncomingChat(state) {
        this.audioPlayer.stop();
        this.stopTimerForIncomingPopup();
        this.chatService.chatMessage.State = state;
        this.chatService.replyIncomingChat(this.chatService.chatMessage, this.replyIncomingChatResponse);
        if (this.windowBlinkTimeoutIdFunction) {
            this.windowBlinkTimeoutIdFunction();
        }
    }
    ;
    createSessionErrorCallback(status) {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ERROR_MSG"), [this.translateService.instant("LBL_SESSION")]);
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, this.translateService.instant("LBL_SESSION"));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    ;
    replyIncomingChatResponse(response) {
        this.chatManager.closeIncomingChat();
        if (response.ChatDto == null) {
            this.chatService.chatMessage = null;
            if (this.isPhoneStateChanged)
                this.phoneManager.updatePhoneAvailabilityStatus(PhoneStatus.Available);
        }
        else {
            this.sessionManager.endSession();
            this.router.navigate([RoutePath.DASHBOARD]);
            this.chatService.chatMessage = response.ChatDto;
            this.chatManager.showChat();
        }
    }
    ;
    initializeTimerForIncomingPopup() {
        this.transferChatTimer = parseInt(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "TRANSFERCHATTIMER"));
        if (!GlobalFunctions.isEmpty(this.transferChatTimer))
            this.transferChatTimer = (+this.transferChatTimer);
        else
            this.transferChatTimer = 30;
        this.startTimerForIncomingPopup();
    }
    ;
    startTimerForIncomingPopup() {
        this.timerPromise = interval(1000).subscribe(x => {
            this.timer += 1;
            if (this.timer > this.transferChatTimer)
                this.ignoreChat();
        });
    }
    ;
    init() {
        try {
            this.setPhoneStatus();
            this.userName = this.chatService.chatMessage.UserName;
            this.audioPlayer.play();
            if (this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Chat_Entities_Chat, "ENABLEINCOMINGCHATNOTIFICATION").toUpperCase() == "TRUE") {
                this.windowBlinkTimeoutIdFunction = GlobalFunctions.highlightTab(this.translateService.instant("LBL_NEW_MESSAGE"), "assets/images/svgs/chat_incoming_green.svg", this.translateService.instant("LBL_APPLICATION_TITLE"), this.sessionManager, null, this.chatService);
            }
            this.initializeTimerForIncomingPopup();
        }
        catch (e) {
            console.error(e);
        }
    }
    handleKeyEvent(event) {
        if (event.key === 'Enter') {
            this.keepSession(); // when sessionManager.isSessionStart=true
        }
    }
};
ChatIncomingComponent = __decorate([
    Component({
        selector: 'chat-incoming',
        templateUrl: './chat-incoming.component.html',
        styleUrls: ['./chat-incoming.component.scss']
    })
], ChatIncomingComponent);
export { ChatIncomingComponent };
//# sourceMappingURL=chat-incoming.component.js.map