var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { OperationType, RecordSelection, ScreenMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { EmailSource } from '../../../../core/enums/global-enum';
import { AddCaseAsEmailRequest } from '../../../../core/models/case/add-case-as-email-request';
import { CaseEntityDto } from '../../../../core/models/case/case-entityDto';
import { CaseObjectDto } from '../../../../core/models/case/case-objectDto';
import { CreateCaseRequest } from '../../../../core/models/case/create-case-request';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { JkcPanel } from '../../../../shared/helper/jkc-panel-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
import { OrganizationAddEditComponent } from '../../organization/add-edit/organization-add-edit.component';
import { RepresentativeAddComponent } from '../../organization/add-representative/organization-add-representative.component';
import { PersonAddEditComponent } from '../../person/add-edit/person-add-edit.component';
let CaseAddEditComponent = class CaseAddEditComponent extends BaseDialogComponent {
    constructor(router, dialog, caseService, cacheManager, dialogManager, eventProvider, personService, sessionManager, documentService, shortcutManager, viewContainerRef, translateService, organizationService, applicationSettingManager, integrationSettingManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.caseService = caseService;
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.personService = personService;
        this.sessionManager = sessionManager;
        this.documentService = documentService;
        this.shortcutManager = shortcutManager;
        this.viewContainerRef = viewContainerRef;
        this.translateService = translateService;
        this.organizationService = organizationService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.title = this.translateService.instant('LBL_ADD_CASE').toUpperCase();
        this.isEmailSelected = false;
        this.relationType = 'Person';
        this.linkType = 'CaseType';
        this.isOpenInSourceEnabled = true;
        this.caseDto = new CaseEntityDto();
        this.relationTypeItems = [];
        this.representatives = [];
        this.enabledEditContact = false;
        this.userId = GlobalFunctions.getLoggedInUserId();
        this.uniqueId = GlobalFunctions.createGuid();
        this.isHandlerHide = 'false';
        this.isSubjectHide = 'false';
        this.isPersonBookShow = 'false';
        this.isCaseBasedEnabled = 'false';
        this.personBookList = [];
        this.showPersonBook = false;
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.fetchingDocumentType = false;
        this.docMethod = null;
        this.documentType = "";
        this.selectedEmail = null;
        this.selectedFindFrom = null;
        this.selectedPersonBook = null;
        this.selectedRepresentative = null;
        this.selectedRelationTypeItem = null;
        this.roles = [];
        this.linkTypeTags = [];
        this.documentTypeList = [];
        this.documentMethod = null;
        this.documentMethodSetting = null;
        this.subs = new SubSink();
        this.rights = {
            organization: false,
            person: false
        };
        this.timeoutIds = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.addPersonResponse = this.addPersonResponse.bind(this);
        this.createCaseResponse = this.createCaseResponse.bind(this);
        this.addCaseErrorCallback = this.addCaseErrorCallback.bind(this);
        this.handlerRolesCallback = this.handlerRolesCallback.bind(this);
        this.addOrganizationResponse = this.addOrganizationResponse.bind(this);
        this.relatedRepresentatives = this.relatedRepresentatives.bind(this);
        this.onDocumentTypesSuccessResponse = this.onDocumentTypesSuccessResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.setRights();
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        this.sessionManager.startSessionIfPossible("CASEENTITY", ScreenMode.Add);
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email])
            this.selectedEmail = this.sessionManager.selectedEntity;
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        if (this.selectedEmail != null) {
            this.isEmailSelected = true;
            this.caseDto.Description = this.selectedEmail.Header.Subject;
            if (this.selectedEmail.Body != null)
                this.caseDto.AdditionalInfo = this.selectedEmail.Body.IsBodyHtml ? String(this.selectedEmail.Body.Body).replace(/<[^>]+>/gm, '') : this.selectedEmail.Body.Body;
        }
        this.selectDefaultRelationTypeOption();
        this.registerDialogShortcutKey();
        this.fetchCaseRelatedSettings();
        if (this.isSubjectHide == 'true')
            document.getElementById("caseSubjectTextField").focus();
        else
            document.getElementById("caseDescriptionTextField").focus();
        let getDocumentMethodSettings = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Documents_Entities_Document, "DOCUMENTMETHOD");
        if (!GlobalFunctions.isEmpty(getDocumentMethodSettings)) {
            this.docMethod = getDocumentMethodSettings;
            this.assignSettingToUI(this.docMethod);
        }
        this.handlerTagItems = this.cacheManager.getEmployeeList(true);
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    setRights() {
        this.rights.organization = GlobalFunctions.checkRights('Organization', 3);
        this.rights.person = GlobalFunctions.checkRights('Person', 3);
    }
    changeRelationType() {
        this.selectedRepresentative = null;
        this.selectedFindFrom = 'Anonymous';
        this.changeFindFrom();
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createCase());
    }
    changeFindFrom() {
        this.enabledEditContact = false;
        this.relationTypeItems = [];
        this.representatives = [];
        $("#selectedPersonOrOrganization").removeAttr("disabled");
        switch (this.selectedFindFrom) {
            case "Anonymous":
                {
                    $("#selectedPersonOrOrganization").attr("disabled", "disabled");
                    $("#selectedRepresentative").attr("disabled", "true");
                    break;
                }
            case "Related":
                {
                    this.fillRelatedEntities();
                    break;
                }
            case "Search":
                {
                    this.openSearchPopup(this.relationType, "RelationType");
                    this.selectedFindFrom = "SelectAny";
                    break;
                }
            case "RegisterNew":
                {
                    if (this.relationType == "Organization") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addOrganizationResponse;
                            this.dialogManager.openJkcChildPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                        $("#selectedRepresentative").attr("disabled", "true");
                    }
                    else if (this.relationType == "Person") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addPersonResponse;
                            this.dialogManager.openJkcChildPanelDialogue(PersonAddEditComponent, 'addPersonContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                        $("#selectedRepresentative").attr("disabled", "true");
                    }
                    else {
                        $("#selectedPersonOrOrganization").attr("disabled", "true");
                        $("#selectedRepresentative").attr("disabled", "true");
                    }
                    break;
                }
        }
    }
    addPersonResponse(selectedEmail) {
        this.setMainEntity(selectedEmail, "Person");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById('findFromSelectOption').focus();
    }
    addOrganizationResponse(selectedEmail) {
        this.setMainEntity(selectedEmail, "Organization");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById('findFromSelectOption').focus();
    }
    relatedRepresentatives(result) {
        if (result?.length > 0) {
            const getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                for (let i = 0; i < result.length; i++) {
                    GlobalFunctions.setStringPresentation(result[i], getGrammerValue);
                    this.representatives.push(result[i]);
                }
                this.selectedRepresentative = this.representatives[this.representatives.length - 1];
            }
        }
    }
    ;
    fetchCaseRelatedSettings() {
        let hideHandlerField = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity, "HIDEHANDLERFIELDFORADDCASE");
        let hideSubjectField = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity, "HIDESUBJECTFIELDFORADDCASE");
        let showPersonBookField = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity, "SHOWPERSONBOOKFIELDTOLINKCASE");
        let useCaseBased = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity, "USECASEBASEDMETHOD");
        this.isHandlerHide = hideHandlerField.toLowerCase();
        this.isSubjectHide = hideSubjectField.toLowerCase();
        this.isPersonBookShow = showPersonBookField.toLowerCase();
        this.isCaseBasedEnabled = useCaseBased.toLowerCase();
        this.personBookList = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Persons_Entities_Person, "PERSONCOLLECTIONIDENTIFIERS")?.split(";");
        this.showPersonBookList();
    }
    handlerRolesCallback(response) {
        this.stopSpinner();
        if (!GlobalFunctions.isEmpty(response) && !GlobalFunctions.isEmpty(response.HandlerRoles) && response.HandlerRoles.length > 0) {
            if (response.HandlerRoles.length == 1 && response.HandlerRoles[0].toLowerCase().indexOf("default") >= 0) {
                this.roles = [this.translateService.instant("LBL_CASE_DEFAULT_HANDLER_ROLE")];
                this.caseDto.HandlerRole = this.translateService.instant("LBL_CASE_DEFAULT_HANDLER_ROLE");
                $("#selectedHandlerRole").attr('disabled', 'true');
            }
            else {
                this.roles = response.HandlerRoles;
                this.caseDto.HandlerRole = response.HandlerRoles[0];
                $("#selectedHandlerRole").removeAttr('disabled');
            }
        }
    }
    setHandlerRoles(caseTypeId) {
        if (this.isCaseBasedEnabled === "true") {
            this.caseDto.HandlerRole = '';
            this.roles = [];
            this.startSpinner();
            this.caseService.getHandlerRoles(this.handlerRolesCallback, caseTypeId);
        }
    }
    addDefaultRepresentative() {
        this.representatives.push({ StringRepresentation: this.translateService.instant("LBL_NEW"), value: "new" });
    }
    ;
    showPersonDeceasedWarning(personEntity) {
        if (personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
            return;
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (!result)
                this.relationTypeItems = [];
        });
    }
    setMainEntity(searchEntity, relationType) {
        if (searchEntity) {
            this.relationTypeItems = [];
            if (relationType == 'Person') {
                if (GlobalFunctions.isPersonDeceased(searchEntity.Details.DateOfExpiration))
                    this.showPersonDeceasedWarning(searchEntity);
                GlobalFunctions.setStringPresentation(searchEntity, this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote"));
                this.showPersonBookList();
            }
            else {
                $("#selectedRepresentative").removeAttr("disabled");
                if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Person"), OperationType.Add))
                    this.addDefaultRepresentative();
                searchEntity.StringRepresentation = searchEntity.Name;
                this.personService.clearCallbacks();
                this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, searchEntity);
            }
            this.relationTypeItems.push(searchEntity);
            this.selectedRelationTypeItem = searchEntity;
        }
    }
    showPersonBookList() {
        if (this.relationType == 'Person' && this.selectedRelationTypeItem)
            this.showPersonBook = (this.selectedRelationTypeItem.ObjectSource.indexOf("StUF0204") != -1 && this.isPersonBookShow == 'true' && this.personBookList?.length > 0);
    }
    linkTypeRemoved() {
        this.caseDto.HandlerRole = '';
        this.roles = [];
    }
    searchLinkType() {
        if (event.target["className"].indexOf("remove") > -1)
            event.stopPropagation();
        else
            this.openSearchPopup(this.linkType, "LinkType");
    }
    changeRepresentative() {
        if (this.selectedRepresentative?.value?.toUpperCase() == 'NEW') {
            if (this.relationType == "Organization") {
                DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.selectedRelationTypeItem?.Id || '', editMode: false }).afterClosed().subscribe(representative => {
                    if (representative) {
                        this.relatedRepresentatives([representative]);
                        this.selectedRepresentative = representative;
                        this.registerDialogShortcutKey();
                    }
                });
            }
        }
    }
    openSearchPopup(entity, type) {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: entity, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            if (type == "RelationType") {
                if (searchEntity != null)
                    this.setMainEntity(searchEntity, entity);
                $("#findFromSelectOption").focus();
            }
            else if (type == "LinkType") {
                if (searchEntity != null) {
                    GlobalFunctions.setPlaceholder("#linkTypeControl", "");
                    this.linkTypeTags = [];
                    if (entity == "CaseType") {
                        searchEntity.StringRepresentation = searchEntity.Name;
                        searchEntity.text = searchEntity.StringRepresentation;
                        this.linkTypeTags.push(searchEntity);
                        this.setHandlerRoles(searchEntity.Id);
                        this.getDocumentTypes(searchEntity.Id);
                    }
                }
                $("#searchButton").focus();
            }
            this.timeoutIds.push(setTimeout(() => $("#selectedPersonOrOrganization").focus(), 100));
        });
    }
    addCaseErrorCallback() {
        let exception = new Object();
        exception.message = this.translateService.instant("LBL_ERROR_MSG");
        let message = this.translateService.instant("LBL_CREATE_ERROR_MSG");
        message = GlobalFunctions.formatStringValue(message, [this.translateService.instant("LBL_CASE")]);
        message = this.translateService.instant(message);
        exception.HelpText = message;
        this.stopSpinner();
    }
    createCase() {
        if ((this.isHandlerHide === 'false' && this.handlerTags.length === 0) || this.linkTypeTags.length === 0 || this.form.invalid)
            return;
        if (this.isEmailSelected && this.documentMethod == 'CaseBaseDocument') {
            let error = false;
            if (GlobalFunctions.isEmpty(this.documentType)) {
                $('#selectDocumentType').addClass('error');
                error = true;
            }
            else
                $('#selectDocumentType').removeClass('error');
            if (error)
                return;
        }
        this.caseDto.Objects = [];
        if (this.isHandlerHide == 'false' && this.handlerTags != null && this.handlerTags.length > 0)
            this.caseDto.HandlerName = this.handlerTags[0].StringRepresentation;
        if (this.relationType == 'Person' && this.selectedRelationTypeItem != null)
            this.caseDto.PrimarySubjectName = this.selectedRelationTypeItem.StringRepresentation;
        this.addItemToCaseObjects(this.linkTypeTags[0], false);
        this.caseDto.CaseTypeId = this.linkTypeTags[0].Id;
        this.caseDto.CaseTypeName = this.linkTypeTags[0].Name;
        let relationTypeItem = this.selectedRelationTypeItem;
        if (relationTypeItem != null)
            this.addItemToCaseObjects(relationTypeItem, true);
        if (this.sessionManager.detailViewCachedEntityList != null && this.sessionManager.detailViewCachedEntityList.length > 0) {
            this.sessionManager.detailViewCachedEntityList.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked)
                    this.addItemToCaseObjects(value.key, false);
            });
        }
        this.startSpinner();
        if (this.selectedEmail == null) {
            let createCaseRequest = new CreateCaseRequest();
            createCaseRequest.CaseDto = this.caseDto;
            this.caseService.createCaseEntity(createCaseRequest, this.createCaseResponse, this.addCaseErrorCallback);
        }
        else {
            let addCaseAsEmailRequest = new AddCaseAsEmailRequest();
            addCaseAsEmailRequest.CaseDto = this.caseDto;
            addCaseAsEmailRequest.DocumentType = this.documentType;
            this.caseService.createCaseAsEmailEntity(addCaseAsEmailRequest, this.createCaseResponse, this.addCaseErrorCallback);
        }
    }
    createCaseResponse(response) {
        this.stopSpinner();
        if (response?.Result == 0 && response.CaseDto) {
            this.processArchive(response);
            this.close();
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = response.CaseDto;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/caseentity`;
            this.sessionManager.addBreadcrumbItems([response.CaseDto], null, RoutePath.DETAIL_PATH);
            this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
            if (this.isOpenInSourceEnabled && response.CaseDto.SourceApplicationDeeplink)
                window.open(response.CaseDto.SourceApplicationDeeplink, "_blank");
            let selectedObject = this.selectedRelationTypeItem;
            let objectType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", selectedObject);
            let objectTypeName = GlobalFunctions.getObjectTypeName(objectType);
            selectedObject = GlobalFunctions.setEntityType(selectedObject, GlobalFunctions.toJsonFqdnType(objectTypeName));
            if (!GlobalFunctions.isEmpty(this.caseDto.PhoneNumber) || !GlobalFunctions.isEmpty(this.caseDto.EmailAddress)) {
                if (this.selectedRelationTypeItem.RelatedEntityFqdn === "Decos_Kcs_Persons_Entities_Person")
                    this.personService.saveExternalData(selectedObject, this.caseDto.PhoneNumber, this.caseDto.EmailAddress);
                if (this.selectedRelationTypeItem.RelatedEntityFqdn === "Decos_Kcs_Organizations_Entities_Organization")
                    this.organizationService.saveExternalData(selectedObject, this.caseDto.PhoneNumber, this.caseDto.EmailAddress);
            }
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CASE'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_CASE") });
    }
    ;
    processArchive(response) {
        if (this.selectedEmail != null) {
            if (this.applicationSettingManager.isArchiveMailOptionRequired()) {
                if (GlobalFunctions.isEmpty(response.ArchivedEmailId))
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_MSG_FAILED_TO_ARCHIVE_EMAIL") });
                else {
                    this.sessionManager.selectedEntity.Id = response.ArchivedEmailId;
                    if (this.sessionManager.selectedEntity.Header != null) {
                        this.sessionManager.selectedEntity.Header.Id = response.ArchivedEmailId;
                        this.sessionManager.selectedEntity.Header.Uid = response.ArchivedEmailId;
                        this.sessionManager.selectedEntity.Header.EmailSource = EmailSource.Archive;
                    }
                }
            }
            else
                this.sessionManager.removeFromDetailViewCachedEntityList(this.selectedEmail.Id);
        }
    }
    addItemToCaseObjects(item, addFqdn) {
        if (this.caseDto.Objects != null && this.caseDto.Objects.length > 0) {
            for (let index = 0; index < this.caseDto.Objects.length; index++) {
                if (this.caseDto.Objects[index].ObjectId == item.Id)
                    return;
            }
        }
        let caseObjectDto = this.getCaseObjectDto(item, addFqdn);
        this.caseDto.Objects.push(caseObjectDto);
    }
    getCaseObjectDto(item, addFqdn) {
        let caseObjectDto = new CaseObjectDto();
        let objectType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", item);
        let objectTypeName = GlobalFunctions.getObjectTypeName(objectType);
        caseObjectDto.ObjectId = item.Id;
        caseObjectDto.ObjectType = objectType;
        if (objectTypeName.toUpperCase() == "PERSON" && item.ObjectSource.indexOf("StUF0204") != -1 && this.showPersonBook && !GlobalFunctions.isEmpty(this.selectedPersonBook))
            caseObjectDto.ObjectInfo = this.selectedPersonBook;
        addFqdn = (addFqdn && (objectTypeName.toUpperCase() == "PERSON" || objectTypeName.toUpperCase() == "ORGANIZATION"));
        if (addFqdn)
            caseObjectDto.IsMarked = true;
        if (objectTypeName.toUpperCase() == "EMAIL" || addFqdn) {
            item.IsArchivable = this.applicationSettingManager.isArchiveMailOptionRequired();
        }
        caseObjectDto.ObjectSource = item.ObjectSource;
        return caseObjectDto;
    }
    fillRelatedEntities() {
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            cachedEntities.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined) {
                    if (value.value.indexOf(this.relationType) != -1) {
                        this.relationTypeItems.push(value.key);
                        this.selectedRelationTypeItem = value.key;
                    }
                }
            });
        }
    }
    selectDefaultRelationTypeOption() {
        let relationType = '';
        if (this.sessionManager.detailViewCachedEntityList?.length > 0) {
            this.sessionManager.detailViewCachedEntityList.forEach(entity => {
                if (entity?.key) {
                    if (entity.value.includes('Person')) {
                        relationType = 'Person';
                        return;
                    }
                    else if (entity.value.includes('Organization'))
                        relationType = 'Organization';
                }
            });
        }
        if (relationType) {
            this.relationType = relationType;
            this.selectedFindFrom = 'Related';
        }
        else
            this.selectedFindFrom = 'Anonymous';
        this.changeFindFrom();
        if (relationType == 'Organization')
            this.setMainEntity(GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList), 'Organization');
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close();
    }
    ;
    searchEmployee() {
        this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
    }
    assignSettingToUI(docMethod) {
        switch (docMethod) {
            case "0":
                this.documentMethodSetting = 'Document';
                this.documentMethod = 'Document';
                break;
            case "1":
                this.documentMethodSetting = 'CaseBaseDocument';
                this.documentMethod = 'CaseBaseDocument';
                break;
            case "2":
                this.documentMethodSetting = 'Both';
                this.documentMethod = 'Document';
                break;
        }
    }
    onDocumentTypesSuccessResponse(getDocumentTypeList) {
        if (getDocumentTypeList.length > 0)
            this.documentTypeList = getDocumentTypeList;
        this.fetchingDocumentType = false;
    }
    ;
    getDocumentTypes(caseTypeId) {
        if (!GlobalFunctions.isEmpty(caseTypeId)) {
            this.fetchingDocumentType = true;
            this.documentService.getDocumentTypes(caseTypeId, this.onDocumentTypesSuccessResponse);
        }
    }
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addCaseHeader").height() - $("#addCaseFooter").height() + "px";
        $("#addCaseContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    changeDocumentType(docType) {
        this.documentType = docType;
    }
};
__decorate([
    ViewChild('form')
], CaseAddEditComponent.prototype, "form", void 0);
CaseAddEditComponent = __decorate([
    Component({
        selector: 'case-add-edit',
        templateUrl: './case-add-edit.component.html',
        styleUrls: ['./case-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], CaseAddEditComponent);
export { CaseAddEditComponent };
//# sourceMappingURL=case-add-edit.component.js.map