var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AlternateSearchType } from '../../../../core/enums/common-enums';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
let CaseTypeSearchResultComponent = class CaseTypeSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, changeDetectorRef, sortManager, searchService, sessionManager, eventProvider, caseService, translateService, activatedRoute, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.changeDetectorRef = changeDetectorRef;
        this.sortManager = sortManager;
        this.searchService = searchService;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.caseService = caseService;
        this.translateService = translateService;
        this.activatedRoute = activatedRoute;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = 'casetype';
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.resultList = [];
            this.filteredSearchResult = [];
            this.searchStatusMessage = '';
            this.searchCaseType();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchCaseType() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.caseService.searchCaseType(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, "", this.searchResultFound, this.updateSearchStatus);
    }
    alternateSearch(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        this.caseService.searchCaseType(this.searchStatusQuery, false, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus);
    }
};
CaseTypeSearchResultComponent = __decorate([
    Component({
        selector: 'case-type-search-result',
        templateUrl: './case-type-search-result.component.html',
        styleUrls: ['./case-type-search-result.component.scss']
    })
], CaseTypeSearchResultComponent);
export { CaseTypeSearchResultComponent };
//# sourceMappingURL=case-type-search-result.component.js.map