var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { RecordOperationMode } from '../../../core/enums/common-enums';
import { EntityFqdn } from '../../../core/enums/core-enums';
import { CreateOrganizationRequest } from '../../../core/models/organization/create-organization-request';
import { CreateOrUpdatePersonRequest } from '../../../core/models/person/create-update-person-request';
import { GlobalFunctions } from '../../../shared/global-functions';
import { DialogHelper } from '../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../base-dialog.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
let UpdateContactInfoComponent = class UpdateContactInfoComponent extends BaseDialogComponent {
    constructor(dialog, personService, data, sessionManager, translateService, organizationService, dialogRef) {
        super();
        this.dialog = dialog;
        this.personService = personService;
        this.data = data;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.organizationService = organizationService;
        this.dialogRef = dialogRef;
        this.customer = null;
        this.customerDetail = {};
        this.customerName = '';
        this.customerFound = false;
    }
    ngOnInit() {
        this.initialize();
    }
    initialize() {
        this.customerFound = GlobalFunctions.isSessionContainsPersonOrganizationRecord(this.sessionManager.detailViewCachedEntityList);
        this.customerDetail = {
            PhoneNumber: this.data.phoneNumber,
            EmailAddress: this.data.emailAddress,
            IsPhoneNumberChecked: !GlobalFunctions.isEmpty(this.data.phoneNumber),
            IsEmailAddressChecked: !GlobalFunctions.isEmpty(this.data.emailAddress)
        };
        if (this.customerFound) {
            this.customer = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            if (!this.customer)
                this.customer = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
            this.customerName = this.customer.StringRepresentation;
        }
    }
    updateCustomer() {
        if (this.customer != null && (this.customerDetail.IsEmailAddressChecked || this.customerDetail.IsPhoneNumberChecked)) {
            if (this.customerDetail.IsEmailAddressChecked)
                this.customer.EmailAddress = this.customerDetail.EmailAddress;
            if (this.customerDetail.IsPhoneNumberChecked) {
                if (GlobalFunctions.isMobileNumber(this.customerDetail.PhoneNumber))
                    this.customer.MobileNumber = this.customerDetail.PhoneNumber;
                else
                    this.customer.PhoneNumber = this.customerDetail.PhoneNumber;
            }
            if (this.customer.RelatedEntityFqdn === EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]) {
                let req = new CreateOrUpdatePersonRequest();
                req.Mode = RecordOperationMode.Edit;
                req.PersonDto = this.customer;
                this.personService.createPersonEntity(req, null, null);
            }
            else {
                let req = new CreateOrganizationRequest();
                req.Mode = RecordOperationMode.Edit;
                req.OrganizationDto = this.customer;
                this.organizationService.createOrganizationEntity(req, null, null);
            }
            this.close(true);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CHAT"), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_CUSTOMER_DETAILS") });
    }
    ;
    close(result) {
        this.dialogRef.close(result);
    }
};
UpdateContactInfoComponent = __decorate([
    Component({
        selector: 'update-contact-info',
        templateUrl: './update-contact-info.component.html',
        styleUrls: ['./update-contact-info.component.scss']
    }),
    __param(2, Inject(MAT_DIALOG_DATA))
], UpdateContactInfoComponent);
export { UpdateContactInfoComponent };
//# sourceMappingURL=update-contact-info.component.js.map