var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, HostListener, Input, Output, ViewChild } from '@angular/core';
import { GlobalFunctions } from '../../../shared/global-functions';
let TagsInputComponent = class TagsInputComponent {
    constructor(filterPipe, excludePipe) {
        this.filterPipe = filterPipe;
        this.excludePipe = excludePipe;
        this.id = '';
        this.tags = [];
        this.items = [];
        this.class = [];
        this.minTags = 0;
        this.minLength = 3;
        this.maxTags = null;
        this.error = false;
        this.alone = false;
        this.hidden = false;
        this.disabled = false;
        this.readonly = false;
        this.required = false;
        this.addOnSpace = false;
        this.addOnEnter = false;
        this.debounceDelay = 100;
        this.maxResultsToShow = 10;
        this.displayProperty = 'text';
        this.allowedTagsPattern = '';
        this.enableEditingLastTag = false;
        this.placeholder = 'LBL_SELECT_TAG';
        this.addFromAutocompleteOnly = false;
        this.replaceSpacesWithDashes = false;
        this.visibleDepartmentName = false;
        this.tagLimitReachedMessage = false;
        this.shownItems = [];
        this.isValidTag = true;
        this.outerClick = false;
        this.selectedIndex = 0;
        this.selectedRemoval = false;
        this.showAutocomplete = false;
        this.onTagAdded = new EventEmitter();
        this.onTagInput = new EventEmitter();
        this.onTagClicked = new EventEmitter();
        this.onTagRemoved = new EventEmitter();
    }
    ngOnInit() {
        this.updateItems();
    }
    ngOnChanges(changes) {
        if (changes.items && !changes.items.firstChange)
            this.updateItems();
    }
    blur() {
        if (this.addOnSpace)
            this.validateInput();
    }
    focus() {
        if (this.inputHasMinLength())
            this.showAutocomplete = true;
        this.inputElementRef.nativeElement.focus();
    }
    change(event) {
        this.onTagInput.emit(event);
        const panel = document.getElementById('tags-input-items');
        this.inputElementRef.nativeElement.classList.remove('tag-input-invalid');
        this.error = false;
        switch (event.code) {
            case 'Space': {
                this.updateItems();
                this.selectedRemoval = false;
                if (this.tags.length > 0)
                    this.tags[this.tags.length - 1].removal = false;
                if (this.addOnSpace) {
                    this.inputElementRef.nativeElement.value = this.inputElementRef.nativeElement.value.slice(0, -1);
                    this.addTagFromInput();
                }
                break;
            }
            case 'Enter':
            case 'NumpadEnter': {
                if (this.addOnEnter)
                    this.validateInput();
                if (!GlobalFunctions.isEmpty(this.inputElementRef.nativeElement.value) && this.inputElementRef.nativeElement.value.length > 0)
                    this.addTag(this.shownItems[this.selectedIndex]);
                break;
            }
            case 'Escape': {
                this.showAutocomplete = false;
                break;
            }
            case 'ArrowUp': {
                if (this.selectedIndex != 0) {
                    panel?.scrollBy({ top: -26, behavior: 'smooth' });
                    this.selectedIndex--;
                }
                else {
                    panel?.scrollBy({ top: 200, behavior: 'smooth' });
                    this.selectedIndex = this.shownItems.length - 1;
                }
                break;
            }
            case 'ArrowDown': {
                if (this.selectedIndex != this.shownItems.length - 1) {
                    panel?.scrollBy({ top: 26, behavior: 'smooth' });
                    this.selectedIndex++;
                }
                else {
                    panel?.scrollTo({ top: 0, behavior: 'smooth' });
                    this.selectedIndex = 0;
                }
                break;
            }
            case 'Backspace': {
                this.updateItems();
                this.selectedIndex = 0;
                if (this.selectedRemoval) {
                    this.selectedRemoval = false;
                    this.removeTag(this.tags[this.tags.length - 1]);
                }
                else if (this.inputElementRef.nativeElement.value.length === 0) {
                    this.selectedRemoval = true;
                    if (this.tags.length > 0)
                        this.tags[this.tags.length - 1].removal = true;
                }
                break;
            }
            default: {
                this.updateItems();
                this.selectedIndex = 0;
                this.selectedRemoval = false;
                if (this.tags.length > 0)
                    this.tags[this.tags.length - 1].removal = false;
                if (this.inputHasMinLength())
                    this.showAutocomplete = true;
                else
                    this.showAutocomplete = false;
                break;
            }
        }
    }
    updateItems() {
        let items = [...this.items];
        items = this.filterPipe.transform(items, [this.displayProperty], this.inputElementRef.nativeElement.value);
        items = this.excludePipe.transform(items, this.tags);
        this.shownItems = items;
    }
    addTag(tag) {
        if (!GlobalFunctions.isEmpty(tag)) {
            this.tags.push(tag);
            this.onTagAdded.emit(tag);
            this.inputElementRef.nativeElement.classList.remove('tag-input-invalid');
        }
        else
            this.error = true;
        this.updateItems();
        this.inputElementRef.nativeElement.value = '';
        this.inputElementRef.nativeElement.focus();
        this.showAutocomplete = false;
    }
    clickTag(tag, event) {
        event.stopPropagation();
        this.onTagClicked.emit(tag);
    }
    removeTag(tag) {
        if (tag) {
            tag.removal = false;
            this.tags.splice(this.tags.indexOf(tag), 1);
            this.onTagRemoved.emit(tag);
        }
        this.updateItems();
    }
    addTagFromInput() {
        if (this.inputElementRef.nativeElement.value.length < this.minLength)
            this.inputElementRef.nativeElement.classList.add('tag-input-invalid');
        else {
            const input = {};
            input[this.displayProperty] = this.inputElementRef.nativeElement.value;
            if (this.tags.some(tag => tag[this.displayProperty] === input[this.displayProperty]))
                this.inputElementRef.nativeElement.classList.add('tag-input-invalid');
            else
                this.addTag(input);
        }
    }
    inputHasMinLength() {
        return this.inputElementRef.nativeElement.value.length >= this.minLength;
    }
    validateInput() {
        if (!GlobalFunctions.isEmpty(this.allowedTagsPattern) && !this.inputElementRef.nativeElement.value.match(this.allowedTagsPattern)) {
            this.inputElementRef.nativeElement.classList.add('tag-input-invalid');
            this.isValidTag = false;
        }
        else {
            this.isValidTag = true;
            this.addTagFromInput();
        }
    }
    trackById(index, item) {
        return item.Id;
    }
    click() {
        this.outerClick = false;
    }
    documentClick() {
        if (this.outerClick)
            this.showAutocomplete = false;
        this.outerClick = true;
        if (this.inputHasMinLength() && this.minLength !== 0 && this.addOnEnter)
            this.validateInput();
    }
};
__decorate([
    Input()
], TagsInputComponent.prototype, "id", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "tags", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "items", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "class", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "keyProperty", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "minTags", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "minLength", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "maxTags", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "error", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "alone", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "hidden", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "disabled", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "readonly", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "required", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "addOnSpace", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "addOnEnter", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "debounceDelay", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "maxResultsToShow", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "displayProperty", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "allowedTagsPattern", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "enableEditingLastTag", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "placeholder", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "addFromAutocompleteOnly", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "replaceSpacesWithDashes", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "visibleDepartmentName", void 0);
__decorate([
    Input()
], TagsInputComponent.prototype, "tagLimitReachedMessage", void 0);
__decorate([
    Output()
], TagsInputComponent.prototype, "onTagAdded", void 0);
__decorate([
    Output()
], TagsInputComponent.prototype, "onTagInput", void 0);
__decorate([
    Output()
], TagsInputComponent.prototype, "onTagClicked", void 0);
__decorate([
    Output()
], TagsInputComponent.prototype, "onTagRemoved", void 0);
__decorate([
    ViewChild('input', { static: true })
], TagsInputComponent.prototype, "inputElementRef", void 0);
__decorate([
    HostListener("click")
], TagsInputComponent.prototype, "click", null);
__decorate([
    HostListener("document:click")
], TagsInputComponent.prototype, "documentClick", null);
TagsInputComponent = __decorate([
    Component({
        selector: 'tags-input',
        templateUrl: './tags-input.component.html',
        styleUrls: ['./tags-input.component.scss']
    })
], TagsInputComponent);
export { TagsInputComponent };
//# sourceMappingURL=tags-input.component.js.map