var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { EmailType } from 'src/app/core/enums/global-enum';
import { BroadCastEventKeys, EntityName, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SuggestionSectionType } from "../../../core/enums/common-enums";
let SuggestionPanelComponent = class SuggestionPanelComponent {
    constructor(sessionManager, phoneManager, dialogManager, suggestionPanelManager, translateService, employeeService, cacheManager, applicationSettingManager, router, viewContainerRef, eventProvider) {
        this.sessionManager = sessionManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.suggestionPanelManager = suggestionPanelManager;
        this.translateService = translateService;
        this.employeeService = employeeService;
        this.cacheManager = cacheManager;
        this.applicationSettingManager = applicationSettingManager;
        this.router = router;
        this.viewContainerRef = viewContainerRef;
        this.eventProvider = eventProvider;
        this.title = '';
        this.maxSectionWidth = '100px';
        this.maxSectionHeight = '200px';
        this.suggestion = null;
        this.suggestionSectionTemplates = [];
        this.suggestionSectionType = SuggestionSectionType;
    }
    ngOnInit() {
        try {
            this.suggestion = this.applicationSettingManager.suggestionSetting.searchByRelationId(this.suggestionPanelManager.suggestionPanel.parameters.EditedData.Id, 'Tag');
            if (this.suggestion) {
                this.sessionManager.contactSessionNotesState.TagIdForSuggestionPanel = this.suggestionPanelManager.suggestionPanel.parameters.EditedData.Id;
                this.title = `${this.translateService.instant('LBL_SUGGESTION_TITLE')} #${this.suggestion.Name}`;
                setTimeout(() => this.resize(), 300);
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    onEmployee(employee) {
        if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem('employee'))
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, employee);
        else {
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = employee;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.EMPLOYEE}/${this.sessionManager.selectedEntity.Id}`;
            this.sessionManager.addBreadcrumbItems([employee], null, this.router.url);
            const isDetailView = this.router.url.includes(RoutePath.DETAIL_PATH);
            this.router.navigate([RoutePath.DETAIL_PATH, EntityName.EMPLOYEE]);
            if (isDetailView)
                setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW, true));
        }
    }
    onEmailTemplate(emailTemplate) {
        this.sessionManager.showUIOnTop = false;
        this.dialogManager.openEmailBasket(this.viewContainerRef, null, EmailType.Send, null, emailTemplate);
    }
    onCbnTemplate(cbnTemplate) {
        this.sessionManager.showUIOnTop = false;
        this.dialogManager.openAddCbnPanelWithSelectedTemplate(cbnTemplate, this.viewContainerRef);
    }
    onPopularNumber(popularNumber) {
        this.phoneManager.placeCall(popularNumber.Number, popularNumber.Name);
    }
    onLinkItem(selectedEntity) {
        try {
            if (selectedEntity) {
                let type = selectedEntity.ObjectSourceCaption.toLowerCase();
                if (type == "themepage")
                    type = "theme";
                selectedEntity.RelatedEntityFqdn = GlobalFunctions.toEntityFqdnString(type);
                if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(type)) {
                    selectedEntity.Partial = true;
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, selectedEntity);
                }
                else {
                    this.sessionManager.selectedEntity = selectedEntity;
                    this.sessionManager.selectedEntity.Partial = true;
                    selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${type}/${selectedEntity.Id}`;
                    this.sessionManager.addBreadcrumbItems([selectedEntity], null, RoutePath.DETAIL_PATH);
                    const isDetailView = this.router.url.includes(RoutePath.DETAIL_PATH);
                    this.router.navigate([RoutePath.DETAIL_PATH, type, selectedEntity.Id]);
                    if (isDetailView)
                        setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW, true));
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resize() {
        const suggestionPanelElement = $("#suggestionPanel");
        if (suggestionPanelElement) {
            const windowHeight = $(window).height();
            let newHeight = windowHeight - $("#suggestionPanelHeader").height() - suggestionPanelElement.position()?.top - 40;
            $("#suggestionPanelBody").height(newHeight + 'px');
            if (this.suggestion?.Sections?.length > 0) {
                newHeight = newHeight - (this.suggestion.Sections.length * 50);
                this.maxSectionHeight = (newHeight / this.suggestion.Sections.length) + "px";
                this.maxSectionWidth = ($("#suggestionPanelHeader").width() - 50) + "px";
            }
        }
    }
    close() {
        this.suggestionPanelManager.close();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.RESIZE_CSN);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.TOGGLE_SUGGESTION_PANEL);
    }
};
SuggestionPanelComponent = __decorate([
    Component({
        selector: 'suggestion-panel',
        templateUrl: './suggestion-panel.component.html',
        styleUrls: ['./suggestion-panel.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], SuggestionPanelComponent);
export { SuggestionPanelComponent };
//# sourceMappingURL=suggestion-panel.component.js.map