var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { OperationType } from 'src/app/core/enums/common-enums';
import { ContentType } from 'src/app/core/models/jkc-object/jkc-object';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let EmailTemplateSectionComponent = class EmailTemplateSectionComponent {
    constructor() {
        this.emailTemplateList = [];
        this.onEmailTemplate = new EventEmitter();
    }
    ngOnInit() {
        if (this.section.Items?.length > 0) {
            const emailTemplates = [];
            for (let index = 0; index < this.section.Items.length; index++) {
                if (GlobalFunctions.hasAllowDataRights(ContentType.Email, OperationType.TemplateTypes, this.section.Items[index].TypeId))
                    emailTemplates.push(this.section.Items[index]);
            }
            if (emailTemplates.length > 0)
                this.emailTemplateList = emailTemplates;
        }
    }
    emitEmailTemplate(emailTemplate) {
        this.onEmailTemplate.emit(emailTemplate);
    }
};
__decorate([
    Input()
], EmailTemplateSectionComponent.prototype, "section", void 0);
__decorate([
    Input()
], EmailTemplateSectionComponent.prototype, "maxSectionWidth", void 0);
__decorate([
    Input()
], EmailTemplateSectionComponent.prototype, "maxSectionHeight", void 0);
__decorate([
    Output()
], EmailTemplateSectionComponent.prototype, "onEmailTemplate", void 0);
EmailTemplateSectionComponent = __decorate([
    Component({
        selector: 'email-template-section',
        templateUrl: './email-template-section.component.html',
        styleUrls: ['./email-template-section.component.scss']
    })
], EmailTemplateSectionComponent);
export { EmailTemplateSectionComponent };
//# sourceMappingURL=email-template-section.component.js.map