var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from '@angular/core';
import { BroadCastEventKeys, RoutePath } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
let RelationListComponent = class RelationListComponent {
    constructor(router, dialogManager, eventProvider, sessionManager, applicationSettingManager) {
        this.router = router;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
    }
    remove(content) {
        if (!GlobalFunctions.isEmpty(content?.Id)) {
            this.sessionManager.removeFromDetailViewCachedEntityList(content.Id);
            if (content.RelatedEntityFqdn == 'Decos_Kcs_Persons_Entities_Person' || content.RelatedEntityFqdn == 'Decos_Kcs_Organizations_Entities_Organization') {
                if (this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson?.includes(content.StringRepresentation))
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = '';
                if (this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber?.includes(content.PhoneNumber))
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = '';
                if (this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail?.includes(content.EmailAddress))
                    this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail = '';
                if (!GlobalFunctions.isEmpty(this.searchEntityTags) && this.personTagRemoved && !GlobalFunctions.isEmpty(this.currentRelationType)) {
                    switch (this.currentRelationType) {
                        case 'Person':
                            if (content.RelatedEntityFqdn == 'Decos_Kcs_Persons_Entities_Person' && this.searchEntityTags[0].text.includes(content.StringRepresentation))
                                this.personTagRemoved(this.searchEntityTags[0]);
                            break;
                        case 'Organization':
                            if (content.RelatedEntityFqdn == 'Decos_Kcs_Organizations_Entities_Organization' && this.searchEntityTags[0].text.includes(content.StringRepresentation))
                                this.personTagRemoved(this.searchEntityTags[0]);
                            break;
                    }
                }
            }
        }
    }
    select(relatedEntity) {
        if (this.selectable) {
            let type = GlobalFunctions.getObjectTypeName(relatedEntity.RelatedEntityFqdn).toLowerCase();
            if (!GlobalFunctions.isEmpty(type) && relatedEntity && type !== 'chat') {
                if (type === 'contactmoment')
                    type = "contacthistory";
                if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(type))
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, relatedEntity);
                else {
                    this.sessionManager.loadedFromRelatedView = false;
                    this.sessionManager.selectedEntity = relatedEntity;
                    if (GlobalFunctions.supportsDeeplinking(type, relatedEntity.ObjectSource))
                        relatedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${type}/${relatedEntity.Id}`;
                    else
                        relatedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${type}`;
                    this.sessionManager.setBreadcrumbGrammer(relatedEntity);
                    this.sessionManager.addBreadcrumbItems([relatedEntity], null, RoutePath.DETAIL_PATH);
                    if (type === this.router.url.split('/')[2])
                        this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
                    this.router.navigate([relatedEntity.locationUrl]);
                }
            }
        }
    }
    ;
};
__decorate([
    Input()
], RelationListComponent.prototype, "selectable", void 0);
__decorate([
    Input()
], RelationListComponent.prototype, "personTagRemoved", void 0);
__decorate([
    Input()
], RelationListComponent.prototype, "searchEntityTags", void 0);
__decorate([
    Input()
], RelationListComponent.prototype, "currentRelationType", void 0);
RelationListComponent = __decorate([
    Component({
        selector: 'relation-list',
        templateUrl: './relation-list.component.html',
        styleUrls: ['./relation-list.component.scss']
    })
], RelationListComponent);
export { RelationListComponent };
//# sourceMappingURL=relation-list.component.js.map