var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { UpdateProfileRequest } from 'src/app/core/models/common/update-profile-request';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { SubSink } from 'subsink';
let ProfileComponent = class ProfileComponent extends BaseDialogComponent {
    constructor(translateService, dialogRef, userService, employeeService, dialog, sessionManager) {
        super();
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.userService = userService;
        this.employeeService = employeeService;
        this.dialog = dialog;
        this.sessionManager = sessionManager;
        this.selectContent = true;
        this.profileEntity = new UpdateProfileRequest();
        this.loggedInUserName = this.employeeService.loggedInEmployee.LoggedInUserName;
        this.loggedInUserImage = this.employeeService.loggedInEmployee.PictureData;
        this.nativeUserId = GlobalFunctions.getLoggedInUserId();
        this.subs = new SubSink();
        this.profileResponse = this.profileResponse.bind(this);
    }
    ngOnInit() {
        setTimeout(() => this.resize(), 300);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    close() {
        this.dialogRef.close();
    }
    updateProfile() {
        if (this.form.invalid)
            return;
        if (this.profileEntity.NewPassword != this.profileEntity.ConfirmPassword)
            return DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CHANGE_PASSWORD"), textMsg: this.translateService.instant("LBL_PASSWORD_DIFFERENT"), isConfirmation: false, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
        this.updateProfileRequest();
    }
    updateProfileRequest() {
        let req = new UpdateProfileRequest();
        req.CurrentPassword = this.profileEntity.CurrentPassword;
        req.NewPassword = this.profileEntity.NewPassword;
        req.LoggedInUserId = GlobalFunctions.getLoggedInUserId();
        this.startSpinner();
        this.userService.updateProfile(req);
        this.userService.setprofileResponseCallbacks(this.profileResponse);
    }
    profileResponse(result) {
        this.stopSpinner();
        let message = this.translateService.instant("LBL_CHANGE_PASSWORD");
        let header = this.translateService.instant("LBL_CHANGE_PASSWORD");
        switch (result.Result) {
            case -1:
                this.close();
                break;
            case 0:
                this.close();
                break;
            case 1:
                message = this.translateService.instant("LBL_PASSWORD_NOT_MATCH");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: false, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
                break;
            case 2:
                message = this.translateService.instant("LBL_PASSWORD_CHANGE_FAILED");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: false, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(() => this.close());
                break;
            case 3:
                message = this.translateService.instant("LBL_EXISTING_PASSWORD_NOT_ALLOW");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: false, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
                break;
            case 4:
                message = this.translateService.instant("LBL_PASSWORD_POLICY_ERROR");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: false, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
                break;
        }
    }
    resize() {
        let windowHeight = $(window).height();
        let newHeight = windowHeight - ($("#profileHeader").height() - $("#toSection").height()) - $("#profileFooter").height() - 350 + "px";
        $("#profileContainer").height(newHeight + "px");
    }
};
__decorate([
    ViewChild('form')
], ProfileComponent.prototype, "form", void 0);
ProfileComponent = __decorate([
    Component({
        selector: 'profile',
        templateUrl: './profile.component.html',
        styleUrls: ['./profile.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ProfileComponent);
export { ProfileComponent };
//# sourceMappingURL=profile.component.js.map