var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { SendMethodType } from 'src/app/core/enums/common-enums';
import { SendBasketRequest } from 'src/app/core/models/basket/send-basket-request';
import { BasketDto } from '../../../core/models/basket/basketdto';
import { GlobalFunctions } from '../../../shared/global-functions';
import { ExceptionHelper } from '../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../base-dialog.component';
let PrintComponent = class PrintComponent extends BaseDialogComponent {
    constructor(dialog, basketService, sessionManager, downloadService, translateService, dialogRef) {
        super();
        this.dialog = dialog;
        this.basketService = basketService;
        this.sessionManager = sessionManager;
        this.downloadService = downloadService;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.outboxItems = [];
        this.BasketDto = null;
        this.SendBasketRequest = null;
        this.setBasketResponseReceived = this.setBasketResponseReceived.bind(this);
        this.printBasketRelatedErrorCallback = this.printBasketRelatedErrorCallback.bind(this);
    }
    ngOnInit() {
        this.outboxItems = this.sessionManager.getSelectedItem(this.sessionManager.selectedEntity);
        this.sendBasketRequest();
    }
    close(result) {
        this.dialogRef.close(result);
    }
    printBasketRelatedErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_PRINT_ERROR_MSG"), this.translateService.instant("LBL_PRINT"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.close(false);
    }
    sendBasketRequest() {
        let basketItems = this.sessionManager.getMarkedItems(this.outboxItems);
        if (basketItems != null && basketItems.length > 0) {
            let basketDto = new BasketDto();
            basketDto.BasketItemList = basketItems;
            let sendBasketRequest = new SendBasketRequest();
            sendBasketRequest.HandlerId = GlobalFunctions.getLoggedInUserId();
            sendBasketRequest.SendMethodType = SendMethodType.Print;
            sendBasketRequest.BasketDto = basketDto;
            this.basketService.printBasket(sendBasketRequest, this.setBasketResponseReceived, this.printBasketRelatedErrorCallback);
        }
    }
    setBasketResponseReceived(result) {
        if (result && result.TicketIdList && result.TicketIdList.length > 0) {
            for (let index = 0; index < result.TicketIdList.length; index++) {
                this.downloadService.downloadFile(result.TicketIdList[index]).subscribe(res => { GlobalFunctions.downloadFileAsBlob(res); });
                this.sessionManager.clearBasketItems();
                this.close(true);
            }
            ;
        }
        else
            this.close(false);
    }
};
PrintComponent = __decorate([
    Component({
        selector: 'print',
        templateUrl: './print.component.html',
        styleUrls: ['./print.component.scss']
    })
], PrintComponent);
export { PrintComponent };
//# sourceMappingURL=print.component.js.map