var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { SubSink } from 'subsink';
import { ContactTypeOption } from '../../../core/enums/common-enums';
import { GlobalFunctions } from '../../../shared/global-functions';
import { BaseDialogComponent } from '../base-dialog.component';
let OutboxComponent = class OutboxComponent extends BaseDialogComponent {
    constructor(dialogManager, sessionManager, translateService, dialogRef) {
        super();
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.outboxItems = [];
        this.allSelected = true;
        this.hasEmailChannelEnabled = false;
        this.subs = new SubSink();
    }
    ngOnInit() {
        if (this.sessionManager.employeeStatus.hasChannelEnabled(ContactTypeOption.Email))
            this.hasEmailChannelEnabled = true;
        this.outboxItems = this.dialogManager.processOutBoxItems();
        this.sessionManager.showUIOnTop = false;
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    close() {
        this.dialogRef.close();
    }
    sendEmail() {
        this.dialogRef.close(true);
    }
    print() {
        if (!GlobalFunctions.isEmpty(this.outboxItems)) {
            let selectedItems = jlinq.from(this.outboxItems).starts("Item.IsMarked", true).select();
            if (selectedItems && selectedItems.length > 0) {
                this.dialogManager.openJsPanelOrDialog("PRINT_DIALOG", true).afterClosed().subscribe(result => {
                    if (result)
                        this.close();
                });
            }
        }
    }
    deleteItem(basketItemselected) {
        this.sessionManager.removeBasketItem(basketItemselected);
    }
    toggleSelectedAll() {
        this.outboxItems.forEach(value => {
            if (value != null)
                value.Item.IsMarked = this.allSelected;
        });
    }
    getSelectedItemCount() {
        let selectedItemCount = 0;
        this.outboxItems.forEach(outboxItem => {
            if (outboxItem.Item.IsMarked)
                selectedItemCount++;
        });
        return selectedItemCount;
    }
    checkSelectedItemCount() {
        if (this.getSelectedItemCount() === 0)
            this.allSelected = false;
        else if (this.getSelectedItemCount() === this.outboxItems.length)
            this.allSelected = true;
    }
};
OutboxComponent = __decorate([
    Component({
        selector: 'outbox',
        templateUrl: './outbox.component.html',
        styleUrls: ['./outbox.component.scss']
    })
], OutboxComponent);
export { OutboxComponent };
//# sourceMappingURL=outbox.component.js.map