var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { EntityName } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
import { DialogHelper } from '../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../base-dialog.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
let MergeLetterTemplateComponent = class MergeLetterTemplateComponent extends BaseDialogComponent {
    constructor(dialog, sessionManager, shortcutManager, downloadService, translateService, systemComponentService, applicationSettingManager, dialogRef) {
        super();
        this.dialog = dialog;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.downloadService = downloadService;
        this.translateService = translateService;
        this.systemComponentService = systemComponentService;
        this.applicationSettingManager = applicationSettingManager;
        this.dialogRef = dialogRef;
        this.typeList = [];
        this.createAs = "Docx";
        this.templateList = [];
        this.selectedType = null;
        this.selectedTemplate = null;
        this.selectedEntityType = this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().includes(EntityName.PERSON) ? '0' : '1';
        this.mergeLetterTemplateResponse = this.mergeLetterTemplateResponse.bind(this);
    }
    ngOnInit() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createLetterTemplate());
        this.typeList = this.applicationSettingManager.letterTemplateList.getLetterTemplateTypeList(this.selectedEntityType);
        if (this.typeList?.length > 0) {
            this.selectedType = this.typeList[0].Id;
            this.changeType();
        }
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    createLetterTemplate() {
        if (GlobalFunctions.isEmpty(this.selectedTemplate))
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_MERGE_LETTER_TEMPLATE'), textMsg: this.translateService.instant("LBL_MESSAGE_SELECT_LETTER_TEMPLATE") });
        else {
            this.startSpinner();
            this.systemComponentService.mergeLetterTemplate(this.sessionManager.selectedEntity, this.sessionManager.selectedEntity.RelatedEntityFqdn, this.createAs, this.selectedTemplate, this.mergeLetterTemplateResponse);
        }
    }
    ;
    mergeLetterTemplateResponse(response) {
        this.stopSpinner();
        let baseUrl = '';
        if (response != null && !GlobalFunctions.isEmpty(response.DownloadTicketId)) {
            this.downloadService.downloadFile(response.DownloadTicketId).subscribe(res => { GlobalFunctions.downloadFileAsBlob(res); });
            this.close();
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_MERGE_LETTER_TEMPLATE'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_CREATE_LETTER") });
    }
    ;
    changeType(type) {
        if (type)
            this.selectedType = type;
        this.templateList = this.applicationSettingManager.letterTemplateList.getTemplateByType(this.selectedType, this.selectedEntityType);
        if (this.templateList?.length > 0)
            this.selectedTemplate = this.templateList[0].Id;
    }
    ;
    changeTemplate(template) {
        this.selectedTemplate = template;
    }
    close() {
        this.dialogRef.close();
    }
    ;
};
MergeLetterTemplateComponent = __decorate([
    Component({
        selector: 'merge-letter-template',
        templateUrl: './merge-letter-template.component.html',
        styleUrls: ['./merge-letter-template.component.scss']
    })
], MergeLetterTemplateComponent);
export { MergeLetterTemplateComponent };
//# sourceMappingURL=merge-letter-template.component.js.map