var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { SubSink } from 'subsink';
import { RecordSelection } from '../../../core/enums/common-enums';
import { SourceType } from '../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../shared/global-functions';
import { DialogHelper } from '../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../base-dialog.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
import { SearchPopupComponent } from '../search-popup/search-popup.component';
let MergeDataComponent = class MergeDataComponent extends BaseDialogComponent {
    constructor(dialog, data, personService, searchService, sessionManager, translateService, organizationService, dialogRef) {
        super();
        this.dialog = dialog;
        this.data = data;
        this.personService = personService;
        this.searchService = searchService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.organizationService = organizationService;
        this.dialogRef = dialogRef;
        this.title = this.translateService.instant("LBL_MERGEDATA").toUpperCase() + " " + this.translateService.instant("LBL_TO").toUpperCase() + " " + this.sessionManager.selectedEntity.StringRepresentation.toUpperCase();
        this.sourceIds = [];
        this.resultList = [];
        this.showResults = false;
        this.subs = new SubSink();
        this.mergeResponse = this.mergeResponse.bind(this);
    }
    ngOnInit() {
        try {
            setTimeout(() => this.resize(), 300);
            if (!GlobalFunctions.isEmpty(this.searchService.selectedSearchOption?.searchQuery))
                this.openSearchPopup('|' + this.searchService.selectedSearchOption.searchQuery);
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    openSearchPopup(query) {
        this.data.mergeType = this.data.mergeType[0] + this.data.mergeType.slice(1).toLowerCase();
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), {
            name: this.data.mergeType + query + "#" + (this.data.mergeType.toLowerCase() === "person" ? SourceType.Person_Cdr : SourceType.Organization_Cdr),
            recordSelection: RecordSelection.Multiple
        }).afterClosed().subscribe(searchEntities => this.initSearchList(searchEntities));
    }
    ;
    initSearchList(searchEntities) {
        this.sourceIds = [];
        this.resultList = [];
        if (searchEntities != null && searchEntities.length > 0) {
            this.showResults = true;
            searchEntities.forEach(result => {
                if (result.ObjectSource.indexOf(".Cdr") >= 0 && result.Id != this.sessionManager.selectedEntity.Id) {
                    this.resultList.push(result);
                    this.sourceIds.push(result.Id);
                }
            });
        }
    }
    ;
    merge() {
        if (this.sourceIds.length > 0) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_MERGEDATA"), textMsg: this.translateService.instant("LBL_MSG_MERGE_DATA_CONFIRM"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (result) {
                    if (this.data.mergeType.toLowerCase() === "person")
                        this.personService.merge(this.sessionManager.selectedEntity.Id, this.sourceIds, this.mergeResponse);
                    else
                        this.organizationService.merge(this.sessionManager.selectedEntity.Id, this.sourceIds, this.mergeResponse);
                    this.startSpinner();
                }
            });
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_MERGEDATA"), textMsg: this.translateService.instant("LBL_NO_DATA_TO_MERGE") });
    }
    ;
    mergeResponse(response) {
        this.stopSpinner();
        if (response != null && response.Result == 0) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_MERGEDATA"), textMsg: this.translateService.instant("LBL_SUCCESS_MERGE_DATA") });
            this.close(true);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_MERGEDATA"), textMsg: this.translateService.instant("LBL_FAILED_MERGE_DATA") });
    }
    ;
    close(result) {
        this.dialogRef.close(result);
    }
    ;
    resize() {
        const windowHeight = $(window).height();
        const tableRowsHeight = windowHeight - $("#mergeDataHeader").height() - $("#mergeDataFooter").height() - 460 + "px";
        $(".tableRowsWithLazyLoading").height(tableRowsHeight);
    }
    ;
};
MergeDataComponent = __decorate([
    Component({
        selector: 'merge-data',
        templateUrl: './merge-data.component.html',
        styleUrls: ['./merge-data.component.scss'],
        host: { '(window:resize)': 'resize()' }
    }),
    __param(1, Inject(MAT_DIALOG_DATA))
], MergeDataComponent);
export { MergeDataComponent };
//# sourceMappingURL=merge-data.component.js.map