var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { BaseDialogComponent } from '../base-dialog.component';
let ManageBlockWiseLocalGroupPrivilegeComponent = class ManageBlockWiseLocalGroupPrivilegeComponent extends BaseDialogComponent {
    constructor(sessionManager, data, translateService, dialogRef) {
        super();
        this.sessionManager = sessionManager;
        this.data = data;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.blocks = [];
        this.localGroups = [];
        this.showErrorMessage = false;
        this.localUserGroups = this.data.localUserGroups;
        this.manageLocalGroupPrivilege = this.data.manageLocalGroupPrivilege;
    }
    ngOnInit() {
        try {
            if (GlobalFunctions.isEmpty(this.data.editorContent))
                return;
            const doc = new DOMParser().parseFromString(this.data.editorContent, 'text/html');
            const allSections = doc.getElementsByTagName('section');
            if (allSections?.length > 0) {
                this.blocks = [];
                for (let i = 0; i < allSections.length; i++) {
                    let block = { Id: allSections[i].id, Data: allSections[i].innerText != null ? allSections[i].innerText : allSections[i].innerText, Privileges: [] };
                    if (!GlobalFunctions.isEmpty(this.data.manageLocalGroupPrivilege)) {
                        let allBlockWiseAssignedLocalGroups = this.data.manageLocalGroupPrivilege.split(';');
                        if (!GlobalFunctions.isEmpty(allBlockWiseAssignedLocalGroups)) {
                            for (let j = 0; j < allBlockWiseAssignedLocalGroups.length; j++) {
                                let blockWiseAssignedLocalGroups = allBlockWiseAssignedLocalGroups[j].split('|');
                                if (!GlobalFunctions.isEmpty(blockWiseAssignedLocalGroups) && blockWiseAssignedLocalGroups.length == 2 && blockWiseAssignedLocalGroups[0] == block.Id && !GlobalFunctions.isEmpty(blockWiseAssignedLocalGroups[1])) {
                                    for (let k = 0; k < this.localUserGroups.length; k++) {
                                        if (blockWiseAssignedLocalGroups[1].indexOf(this.localUserGroups[k].Id) != -1)
                                            block.Privileges.push({ text: this.localUserGroups[k].Name, id: this.localUserGroups[k].Id });
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    this.blocks.push(block);
                }
            }
            if (this.localUserGroups?.length > 0) {
                for (let i = 0; i < this.localUserGroups.length; i++)
                    this.localGroups.push({ text: this.localUserGroups[i].Name, id: this.localUserGroups[i].Id });
            }
            setTimeout(() => this.resize(), 250);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    saveLocalGroupPrivilege() {
        if (this.blocks?.length > 0) {
            this.manageLocalGroupPrivilege = "";
            for (let i = 0; i < this.blocks.length; i++) {
                let privilege = this.blocks[i].Id + "|";
                if (this.blocks[i].Privileges && this.blocks[i].Privileges.length > 0) {
                    for (let j = 0; j < this.blocks[i].Privileges.length; j++)
                        privilege += this.blocks[i].Privileges[j].id + ",";
                    privilege = privilege.slice(0, -1);
                }
                if (i < this.blocks.length - 1)
                    privilege += ";";
                this.manageLocalGroupPrivilege += privilege;
            }
        }
        ;
        this.dialogRef.close(this.manageLocalGroupPrivilege);
    }
    resize() {
        let windowHeight = $(window).height();
        let newHeight;
        if (windowHeight < 700)
            newHeight = windowHeight - $("#manageBlockPrivilegeHeader").height() - $("#manageBlockPrivilegeFooter").height() - 80;
        else
            newHeight = windowHeight - $("#manageBlockPrivilegeHeader").height() - $("#manageBlockPrivilegeFooter").height() - 95;
        $("#blocksVisibilityContainer").height(newHeight + "px");
        $("#tbodyAssignBlockPrivilege").height(newHeight - 100 + "px");
    }
    close() {
        this.dialogRef.close(this.manageLocalGroupPrivilege);
    }
};
ManageBlockWiseLocalGroupPrivilegeComponent = __decorate([
    Component({
        selector: 'manage-block-wise-local-group-privilege',
        templateUrl: './manage-block-wise-local-group-privilege.component.html',
        styleUrls: ['./manage-block-wise-local-group-privilege.component.scss'],
        host: { '(window:resize)': 'resize()' }
    }),
    __param(1, Inject(MAT_DIALOG_DATA))
], ManageBlockWiseLocalGroupPrivilegeComponent);
export { ManageBlockWiseLocalGroupPrivilegeComponent };
//# sourceMappingURL=manage-block-wise-local-group-privilege.component.js.map