var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { EntityFqdn } from '../../../core/enums/core-enums';
import { GlobalFunctions } from '../../../shared/global-functions';
import { BaseDialogComponent } from '../base-dialog.component';
let X2JS = require('x2js');
let MailboxComponent = class MailboxComponent extends BaseDialogComponent {
    constructor(data, dialogRef, dialogManager, sessionManager, userSettingManager, integrationSettingManager, applicationSettingManager, emailService, basketService, translateService, systemComponentService) {
        super();
        this.data = data;
        this.dialogRef = dialogRef;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.userSettingManager = userSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.emailService = emailService;
        this.basketService = basketService;
        this.translateService = translateService;
        this.systemComponentService = systemComponentService;
        this.autoSave = false;
        this.mailboxItems = [];
        this.selectContent = true;
        this.defaultMailboxObj = { defaultMailbox: '' };
        this.allowToSelectSetting = this.applicationSettingManager.getApplicationSettingValueByKey("AllowToSelectMailboxPreference");
        this.allowToSelectMailbox = !GlobalFunctions.isEmpty(this.allowToSelectSetting) && this.allowToSelectSetting.toLowerCase() == "false" ? false : true;
        this.toolTipText = this.allowToSelectMailbox ? this.translateService.instant("LBL_SELECT_MAILBOX_TO_WORK") : this.translateService.instant("LBL_NO_RIGHTS_SELECTION_MAILBOX");
    }
    ngOnInit() {
        let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Email_Entities_Email, "MULTIPLEEMAILCONFIGURATION");
        this.setMailboxNiceName(result);
        this.initMailbox();
        this.autoSaveMailbox();
        this.sessionManager.showUIOnTop = false;
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    savePreference() {
        let settingValue = "";
        if (GlobalFunctions.isEmpty(this.defaultMailboxObj.defaultMailbox)) {
            this.validateEmailSelection = "LBL_VAL_MINIMUM_MAILBOX";
            return false;
        }
        this.startSpinner();
        for (let i = 0; i < this.mailboxItems.length; i++) {
            if (this.mailboxItems[i].IsMarked) {
                settingValue += this.mailboxItems[i].MailboxId + ';';
            }
        }
        settingValue = settingValue.substring(0, settingValue.length - 1);
        if (!GlobalFunctions.isEmpty(settingValue))
            settingValue += '|' + this.defaultMailboxObj.defaultMailbox;
        this.userSettingManager.setUserSettingValueByKey("mailboxPreference", settingValue);
        let userSettingDto = new Object();
        userSettingDto.Key = "mailboxPreference";
        userSettingDto.Value = settingValue;
        userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
        this.systemComponentService.updateUserSetting(userSettingDto);
        this.updateMailboxesOfDashboard();
        this.emailService.userMailboxPreference = settingValue;
        this.emailService.getPendingEmailsCount();
        this.stopSpinner();
        this.close();
    }
    ;
    updateMailboxesOfDashboard() {
        for (let i = 0; i < this.sessionManager.pendingCount.EmailCount.length; i++) {
            for (let j = 0; j < this.mailboxItems.length; j++) {
                if (this.sessionManager.pendingCount.EmailCount[i].MailboxId.toUpperCase() == this.mailboxItems[j].MailboxId.toUpperCase()) {
                    this.sessionManager.pendingCount.EmailCount[i].IsMarked = this.mailboxItems[j].IsMarked;
                    this.sessionManager.pendingCount.EmailCount[i].IsDefault = this.sessionManager.pendingCount.EmailCount[i].MailboxId.toUpperCase() == this.defaultMailboxObj.defaultMailbox.toUpperCase();
                    break;
                }
            }
        }
    }
    ;
    updateDefaultMailboxes(event, index) {
        if (this.mailboxItems != null) {
            this.mailboxItems[index].IsMarked = event.target.checked;
            this.defaultMailboxes = new Array();
            for (let i = 0; i < this.mailboxItems.length; i++) {
                if (this.mailboxItems[i].IsMarked) {
                    this.defaultMailboxes.push(this.mailboxItems[i]);
                    if (GlobalFunctions.isEmpty(this.defaultMailboxObj.defaultMailbox))
                        this.defaultMailboxObj.defaultMailbox = this.mailboxItems[i].MailboxId;
                }
                else {
                    if (this.mailboxItems[i].MailboxId == this.defaultMailboxObj.defaultMailbox && this.defaultMailboxes.length != 0)
                        this.defaultMailboxObj.defaultMailbox = this.defaultMailboxes[0].MailboxId;
                    else if (this.mailboxItems[i].MailboxId == this.defaultMailboxObj.defaultMailbox && this.defaultMailboxes.length == 0)
                        this.defaultMailboxObj.defaultMailbox = "";
                }
            }
        }
    }
    ;
    setMailboxNiceName(multipleEmailConfigValue) {
        if (this.sessionManager.userMailboxes.length > 0) {
            let x2js = new X2JS();
            let jsonObj = x2js.xml2js(multipleEmailConfigValue);
            if (jsonObj != null && jsonObj.MAILBOXES != null && jsonObj.MAILBOXES.MAILBOX != null) {
                jsonObj.MAILBOXES.MAILBOX = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.MAILBOXES.MAILBOX);
                for (let mailboxId = 0; mailboxId < this.sessionManager.userMailboxes.length; mailboxId++) {
                    for (let mailboxName = 0; mailboxName < jsonObj.MAILBOXES.MAILBOX.length; mailboxName++) {
                        if (this.sessionManager.userMailboxes[mailboxId].MailboxId.toUpperCase() == jsonObj.MAILBOXES.MAILBOX[mailboxName].MAILBOXLOGINNAME.toUpperCase()) {
                            this.sessionManager.userMailboxes[mailboxId].MailboxName = jsonObj.MAILBOXES.MAILBOX[mailboxName].MAILBOXNICENAME;
                            break;
                        }
                    }
                }
            }
        }
    }
    ;
    initMailbox() {
        this.mailboxItems = this.sessionManager.userMailboxes;
        const preferredMailboxes = this.userSettingManager.getUserSettingValueByKey("mailboxPreference");
        let preferredMailboxArray = [];
        if (preferredMailboxes) {
            let mailboxesPreference = preferredMailboxes.split('|');
            if (!GlobalFunctions.isEmpty(mailboxesPreference) && mailboxesPreference.length > 0 && !GlobalFunctions.isEmpty(mailboxesPreference[0]))
                preferredMailboxArray = mailboxesPreference[0].split(';');
            if (!GlobalFunctions.isEmpty(mailboxesPreference) && mailboxesPreference.length > 1)
                this.defaultMailboxObj.defaultMailbox = mailboxesPreference[1];
        }
        if (this.mailboxItems != null) {
            this.defaultMailboxes = new Array();
            for (let i = 0; i < this.mailboxItems.length; i++) {
                if (preferredMailboxArray.indexOf(this.mailboxItems[i].MailboxId) != -1) {
                    this.mailboxItems[i].IsMarked = true;
                    this.defaultMailboxes.push(this.mailboxItems[i]);
                    if (GlobalFunctions.isEmpty(this.defaultMailboxObj.defaultMailbox) && !GlobalFunctions.isEmpty(this.mailboxItems[i].IsOrganizationDefault) && this.mailboxItems[i].IsOrganizationDefault)
                        this.defaultMailboxObj.defaultMailbox = this.mailboxItems[i].MailboxId;
                }
                else {
                    this.mailboxItems[i].IsMarked = false;
                }
            }
            if (GlobalFunctions.isEmpty(this.defaultMailboxObj.defaultMailbox) && !GlobalFunctions.isEmpty(this.defaultMailboxes))
                this.defaultMailboxObj.defaultMailbox = this.defaultMailboxes[0].MailboxId;
        }
        this.timeoutIds.push(setTimeout(() => this.mailboxItems));
    }
    autoSaveMailbox() {
        if (this.autoSave) {
            if (this.mailboxItems != null && this.mailboxItems.length > 0) {
                for (let i = 0; i < this.mailboxItems.length; i++) {
                    this.mailboxItems[i].IsMarked = true;
                    if (!GlobalFunctions.isEmpty(this.mailboxItems[i].IsOrganizationDefault) && this.mailboxItems[i].IsOrganizationDefault)
                        this.defaultMailboxObj.defaultMailbox = this.mailboxItems[i].MailboxId;
                }
                if (GlobalFunctions.isEmpty(this.defaultMailboxObj.defaultMailbox))
                    this.defaultMailboxObj.defaultMailbox = this.mailboxItems[0].MailboxId;
                this.savePreference();
            }
            else
                this.close();
        }
    }
    ;
    close() {
        this.dialogRef.close();
    }
    ;
};
MailboxComponent = __decorate([
    Component({
        selector: 'mailbox',
        templateUrl: './mailbox.component.html',
        styleUrls: ['./mailbox.component.scss']
    }),
    __param(0, Inject(MAT_DIALOG_DATA))
], MailboxComponent);
export { MailboxComponent };
//# sourceMappingURL=mailbox.component.js.map