var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener, ViewChild } from '@angular/core';
import { CallStatus, PhoneStatus } from 'src/app/core/enums/phone-enum';
import { BroadCastEventKeys, Domain, EntityName, LocalStorageKey, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { CommonHelper } from 'src/app/shared/helper/common-helper';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { environment } from 'src/environments/environment';
import { SubSink } from 'subsink';
import { ContactTypeOption, OperationType, ResolutionType, ScreenMode } from '../../../core/enums/common-enums';
import { EntityFqdn } from '../../../core/enums/core-enums';
import { UpdateEmployeeStatusRequest } from '../../../core/models/employee/update-employee-status-request';
import { ContentType } from '../../../core/models/jkc-object/jkc-object';
import { EmployeePanelComponent } from '../../domain/employee/panel/employee-panel.component';
import { TaskReminderComponent } from '../../domain/task/reminder/task-reminder.component';
import { SessionSaveComponent } from '../../domain/task/subdomains/session/save/session-save.component';
import { AboutComponent } from '../about/about.component';
import { AdvancedSearchComponent } from '../advanced-search/advanced-search.component';
import { FeedbackComponent } from '../feedback/feedback.component';
import { MailboxComponent } from '../mailbox/mailbox.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
import { OutboxComponent } from '../outbox/outbox.component';
import { SearchComponent } from '../search.component';
import { ShortcutsComponent } from '../shortcuts/shortcuts.component';
let X2JS = require('x2js');
let HeaderComponent = class HeaderComponent extends SearchComponent {
    constructor(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef, sessionManager, applicationFeatureManager, dialogManager, searchService, popularService, employeeService, phoneManager, systemComponentService, userSettingManager, applicationSettingManager, integrationSettingManager, shortcutManager, sortManager, cacheManager, userService, phoneService, taskService, emailService, contactHistoryService, route, eventProvider, productService, chatManager, serviceManager) {
        super(router, searchService, popularService, sessionManager, translateService, eventProvider, serviceManager, zone, dialog, changeDetectorRef, viewContainerRef);
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.sessionManager = sessionManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.dialogManager = dialogManager;
        this.searchService = searchService;
        this.popularService = popularService;
        this.employeeService = employeeService;
        this.phoneManager = phoneManager;
        this.systemComponentService = systemComponentService;
        this.userSettingManager = userSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.shortcutManager = shortcutManager;
        this.sortManager = sortManager;
        this.cacheManager = cacheManager;
        this.userService = userService;
        this.phoneService = phoneService;
        this.taskService = taskService;
        this.emailService = emailService;
        this.contactHistoryService = contactHistoryService;
        this.route = route;
        this.eventProvider = eventProvider;
        this.productService = productService;
        this.chatManager = chatManager;
        this.serviceManager = serviceManager;
        this.isTrue = false;
        this.advancedMenu = false;
        this.searchValue = null;
        this.searchBox = false;
        this.ticketsConfiguration = {};
        this.eformLinkList = [];
        this.domains = [];
        this.availabilityChannel = { StringRepresentation: null, Key: null, Value: null };
        this.globalSearchdescription = 'Zoek op ........';
        this.showTicketsDropdown = false;
        this.showNoChannelSelectedMessage = false;
        this.isLowResolution = false;
        this.popularList = [];
        this.currentEntity = '';
        this.timeoutIds = [];
        this.subs = new SubSink();
        this.chatManager.initJSPanel(this.viewContainerRef);
        this.setCurrentStatus = this.setCurrentStatus.bind(this);
        this.searchRoleResponse = this.searchRoleResponse.bind(this);
        this.sessionStateChanged = this.sessionStateChanged.bind(this);
        this.emailContentFoundForNextEmail = this.emailContentFoundForNextEmail.bind(this);
        this.setFetchPrefillEformLinksComplete = this.setFetchPrefillEformLinksComplete.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.CLOSE_ALL_POPUPS).subscribe(() => this.closePopups());
    }
    ngOnInit() {
        try {
            this.sessionManager.headerViewContainerRef = this.viewContainerRef;
            this.sessionManager.setSessionStateChangeCallback(this.sessionStateChanged);
            this.subs.sink = this.eventProvider.event(BroadCastEventKeys.OPEN_VIEWER_PANEL).subscribe(selectedEntity => this.dialogManager.openJkcViewerPanelDialogue(selectedEntity, this.viewContainerRef));
            this.subs.sink = this.eventProvider.event(BroadCastEventKeys.SELECT_ROLE).subscribe(role => {
                if (!role)
                    this.selectRole();
                else
                    this.setRole(role);
            });
            this.sortManager.initialize();
            this.globalSearchdescription = this.applicationSettingManager.getSearchDescriptionText(ContentType.GlobalSearch);
            if (GlobalFunctions.isEmpty(this.globalSearchdescription))
                this.globalSearchdescription = this.translateService.instant('LBL_SEARCH_PLACE_HOLDER_TEXT');
            this.sessionManager.sessionDuration = this.applicationSettingManager.getApplicationSettingValueByKey("MaximumSessionDuration");
            this.sessionManager.isEWSEnabled = this.applicationSettingManager.isEmailEWSEnabled();
            this.applicationFeatureManager.setFeatureControlsVisibility();
            if (this.sessionManager.isEWSEnabled)
                this.emailService.connect().then(() => this.emailService.processEWSMailbox(this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Email_Entities_Email, "MULTIPLEEMAILCONFIGURATION")));
            let isCaseConnectEnabled = this.applicationSettingManager.isCaseConnectEnabled();
            if (isCaseConnectEnabled) {
                let connectSystemCode = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity, "CONNECTSYSTEMCODE");
                let connectPassword = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity, "CONNECTPASSWORD");
                this.cacheManager.fetchLayers(connectSystemCode, connectPassword);
            }
            else
                this.cacheManager.fetchLayers(null, null);
            $("#menuSettingDropDown").removeClass("dropdown-toggle");
            this.applicationSettingManager.setPrivacySettings();
            this.applicationSettingManager.setEntityRequiredPropertySettings();
            this.applicationSettingManager.setUIConfigurator();
            this.sessionManager.isCustomSelectionEnabled = this.applicationSettingManager.isCustomerOM();
            this.productService.connect().then(() => {
                if (GlobalFunctions.isEmpty(this.integrationSettingManager.getIntegrationSetting("EformList", "PREFILLEFORMLINKS"))) {
                    this.productService.setFetchPrefillEformLinksCallback(this.setFetchPrefillEformLinksComplete);
                    this.productService.fetchPrefillEformLinks();
                }
            });
            this.employeeService.connect().then(() => {
                this.setEmployeeStatus();
                this.setPhoneStatusList();
                this.subs.sink = this.employeeService.cacheLoggedInUser().subscribe(() => {
                    this.cacheManager.fetchCacheData();
                    if (this.phoneManager.phoneState.IsPhoneFeatureEnabled) {
                        this.phoneManager.phoneState.CurrentState = CallStatus.Unregistered;
                        let enablePhoneStatus = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Phone_Entities_Phone, "ENABLEPHONESTATUS");
                        this.applicationFeatureManager.isPhoneStatusEnabled = !GlobalFunctions.isEmpty(enablePhoneStatus) && enablePhoneStatus.toLowerCase() === "true";
                        if (this.sessionManager.employeeStatus.hasChannelEnabled(ContactTypeOption.Phone)) {
                            if (!GlobalFunctions.isEmpty(GlobalFunctions.getCookie(LocalStorageKey.REGISTERED_EXTENSION)))
                                this.phoneManager.autoRegisterInPhone(GlobalFunctions.getCookie(LocalStorageKey.REGISTERED_EXTENSION));
                            else {
                                const isAutoRegisterEnabled = this.applicationSettingManager.getApplicationSettingValueByKey("AutoRegister");
                                if ((GlobalFunctions.isEmpty(isAutoRegisterEnabled) || isAutoRegisterEnabled.toUpperCase() == "TRUE")) {
                                    const phoneRegisterValue = this.phoneManager.getPhoneRegisterValue();
                                    if (!GlobalFunctions.isEmpty(phoneRegisterValue))
                                        this.phoneManager.autoRegisterInPhone(phoneRegisterValue);
                                }
                            }
                        }
                    }
                });
            });
            this.setTicketsConfiguration();
            this.setDashboardDocumentConfiguration();
            this.setDomainConfiguration();
            this.setDefaultActionMenu();
            this.userService.connect().then(() => {
                this.subs.sink = this.userService.cacheNativeUsergroups().subscribe(() => this.userService.getNativeUsergroupList());
                this.subs.sink = this.userService.cacheUserPrivilegeData().subscribe(() => {
                    this.contactHistoryService.showContactSessionNotesPanel(this.viewContainerRef);
                    this.shortcutManager?.init().then(() => {
                        this.shortcutManager?.bind('LBL_SHORTCUT_SEARCH_BOX', () => this.focusSearch());
                        this.shortcutManager?.bind('LBL_SHORTCUT_SEARCH_WITHIN_RESULTS', () => this.focusLocalSearch());
                        this.shortcutManager?.bind('LBL_SHORTCUT_ADVANCE_SEARCH', () => this.focusAdvancedSearch());
                        this.shortcutManager?.bind('LBL_SHORTCUT_ADD_CALLBACK_NOTE', () => this.openJsPanelOrDialog('ADD_CALLBACKNOTE'));
                        this.shortcutManager?.bind('LBL_SHORTCUT_SEND_EMAIL', () => this.openJsPanelOrDialog('EMAIL_DIALOG'));
                        this.shortcutManager?.bind('LBL_SHORTCUT_EMPLOYEE_POPUP_PANEL', () => this.openJsPanelOrDialog('EMPLOYEE_POPUP_PANEL'));
                        this.shortcutManager?.bind('LBL_SHORTCUT_PHONE', () => this.menuPhoneClick());
                        this.shortcutManager?.bind('LBL_SHORTCUT_NEXT_EMAIL', () => this.nextEmailFeature());
                        this.shortcutManager?.bind('LBL_SHORTCUT_ACTIVATE_ACTION_MENU', () => this.openActionMenuList());
                        this.shortcutManager?.bind('LBL_SHORTCUT_ACTIVATE_SETTING_MENU', () => this.openSettingContextMenu());
                    });
                    if (GlobalFunctions.isEmpty(this.sessionManager.selectedRole))
                        this.userService.searchRole(this.searchRoleResponse, GlobalFunctions.getLoggedInUserId());
                });
            });
            if (this.applicationSettingManager.isSmartCJMEnabled()) {
                this.taskService.fetchLocationsRelatedToAppointment(response => {
                    if (response?.LocationList)
                        this.sessionManager.appointmentLocationList = response.LocationList;
                });
                this.taskService.fetchRelatedProducts(response => {
                    if (response?.ServiceList)
                        this.sessionManager.appointmentProductList = response.ServiceList;
                });
            }
            else if (this.applicationSettingManager.isQmaticEnabled()) {
                this.taskService.fetchLocationsRelatedToAppointment(response => {
                    if (response)
                        this.sessionManager.appointmentLocationList = response;
                });
            }
            this.getVersionInfo();
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.unbindShortcuts();
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    onChange() {
        if (this.sessionManager.isValidSession()) {
            if (GlobalFunctions.isEmpty(this.searchService.searchQuery)) {
                this.showPopularList();
                $(".jkcCircleCloseSearch").hide();
            }
            else {
                $(".jkcCircleCloseSearch").show();
                this.popularList = [];
                this.searchService.addSearchOption(this.searchService.searchQuery);
                setTimeout(() => {
                    this.popularService.fetchKeywordPopularList(this.searchService.searchQuery, this, this.completedPopularList)
                        .subscribe(data => console.log("fetchKeywordPopularList data received:", data), error => console.error("Error in fetchKeywordPopularList:", error));
                }, 700);
            }
        }
    }
    showPopularList() {
        this.subs.sink = this.popularService.fetchPopularList(this.completedPopularList).subscribe();
    }
    sessionStateChanged(state) {
        this.sessionManager.employeeStatus.statusIndex = (state == 'StartSession' || (this.sessionManager.keepPhoneBusy && state == 'EndSession')) ? "0" : "1";
        this.changeAvailabilityStatus(null);
    }
    ;
    openJsPanelOrDialog(key) {
        this.dialogManager.openJsPanelOrDialog(key, null, null, null, this.viewContainerRef);
    }
    setDashboardDocumentConfiguration() {
        this.sessionManager.pendingCount.ShowDocumentOption = false;
        this.sessionManager.pendingCount.DocumentTitle = this.translateService.instant("LBL_DOCUMENTS");
        let dashboardCollections = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Documents_Entities_Document, "DASHBOARDCOLLECTIONIDENTIFIERS");
        if (!GlobalFunctions.isEmpty(dashboardCollections)) {
            this.sessionManager.pendingCount.ShowDocumentOption = true;
            let dashboardTitle = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Documents_Entities_Document, "DASHBOARDTITLE");
            if (!GlobalFunctions.isEmpty(dashboardTitle))
                this.sessionManager.pendingCount.DocumentTitle = dashboardTitle;
        }
    }
    ;
    setDomainConfiguration() {
        let domains = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Domains_Entities_Domain, "DOMAINCONFIGURATION");
        if (!GlobalFunctions.isEmpty(domains)) {
            let addDomains = [];
            domains.forEach(domain => {
                let addDomain = jlinq.from(domain.Screens).equals("Type", "Add").first();
                if (addDomain != null)
                    addDomains.push(domain);
            });
            this.domains = addDomains;
        }
    }
    ;
    openAddDomain(domain) {
        this.dialogManager.openJsPanelOrDialog("ADD_DOMAIN", false, domain, false, this.viewContainerRef);
    }
    ;
    setRole(role) {
        if (role) {
            this.sessionManager.selectedRole = role;
            this.sessionManager.isRoleChanged = true;
            this.sessionManager.setRoleInBaseService(role.Id);
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.REFRESH_DASHBOARD);
            this.updateEmployeeStatus();
        }
    }
    ;
    setPhoneStatusList() {
        let phoneStatusList = this.applicationSettingManager.getApplicationSettingValueByKey("PHONEAVAILABILITYSTATUS");
        if (!GlobalFunctions.isEmpty(phoneStatusList)) {
            this.phoneManager.phoneState.PhoneStatusList = [];
            let x2Js = new X2JS();
            let phoneStatusListJson = x2Js.xml2js(phoneStatusList);
            if (phoneStatusListJson != null && phoneStatusListJson.PhoneAvailabilityStatuses != null && phoneStatusListJson.PhoneAvailabilityStatuses.PhoneAvailabilityStatus != null && phoneStatusListJson.PhoneAvailabilityStatuses.PhoneAvailabilityStatus.length > 0) {
                phoneStatusListJson.PhoneAvailabilityStatuses.PhoneAvailabilityStatus.forEach((phoneAvailabilityStatus) => {
                    this.phoneManager.phoneState.PhoneStatusList.push({
                        id: phoneAvailabilityStatus._Id,
                        key: phoneAvailabilityStatus._StatusIndex,
                        value: phoneAvailabilityStatus._StatusText,
                        color: phoneAvailabilityStatus._StatusColor,
                        code: GlobalFunctions.isEmpty(phoneAvailabilityStatus._StatusCode) ? "" : phoneAvailabilityStatus._StatusCode,
                        employeeStatus: GlobalFunctions.isEmpty(phoneAvailabilityStatus._EmployeeStatusIndex) ? "" : phoneAvailabilityStatus._EmployeeStatusIndex
                    });
                });
            }
            if (phoneStatusListJson != null && phoneStatusListJson.PhoneAvailabilityStatuses != null && phoneStatusListJson.PhoneAvailabilityStatuses.PhoneAvailabilityStatus != null && phoneStatusListJson.PhoneAvailabilityStatuses.PhoneAvailabilityStatusActions != null && phoneStatusListJson.PhoneAvailabilityStatuses.PhoneAvailabilityStatusActions.PhoneAvailabilityStatusAction.length > 0) {
                phoneStatusListJson.PhoneAvailabilityStatuses.PhoneAvailabilityStatusActions.PhoneAvailabilityStatusAction.forEach(phoneAvailabilityStatusAction => {
                    this.phoneManager.phoneState.PhoneStatusActionList.push({
                        Action: phoneAvailabilityStatusAction._Action,
                        Enabled: phoneAvailabilityStatusAction._Enabled == "true",
                        StatusId: phoneAvailabilityStatusAction._StatusId
                    });
                });
            }
        }
    }
    ;
    resize() {
        let newLeft = 0;
        const resolutionInfo = GlobalFunctions.getScreenResolutionInfo();
        if (resolutionInfo && !GlobalFunctions.isEmpty(resolutionInfo.Width)) {
            const searchBoxUl = document.getElementById("searchBoxUl");
            if (searchBoxUl) {
                searchBoxUl.style.marginLeft = "";
                if (resolutionInfo.ResolutionType == ResolutionType.MediumResolution || resolutionInfo.ResolutionType == ResolutionType.HighResolution) {
                    newLeft = ((resolutionInfo.Width - 1280) * (1 / 3));
                    const searchIcon = document.getElementById("autocomplete-search-icon");
                    if (searchIcon)
                        searchIcon.style.left = (newLeft + 310) + "px";
                    $("#typeheadSearchBox").width("345px");
                    searchBoxUl.style.marginLeft = newLeft + "px";
                }
            }
        }
    }
    ;
    selectRole() {
        if (this.sessionManager.isValiduser && !this.sessionManager.isRoleSelectionDialogOpen) {
            if (this.sessionManager.isSessionStart && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole))
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_ROLE'), textMsg: this.translateService.instant('LBL_ROLE_WARNING_MESSAGE') });
            else {
                if (this.cacheManager.roleList?.length === 1)
                    this.setRole(this.cacheManager.roleList[0]);
                else {
                    this.sessionManager.isRoleSelectionDialogOpen = true;
                    this.dialogManager.openRolePreference().afterClosed().toPromise().then(selectedRole => {
                        this.setRole(selectedRole);
                        this.sessionManager.isRoleSelectionDialogOpen = false;
                    });
                }
            }
        }
    }
    ;
    searchRoleResponse(response) {
        if (response?.RoleDtoList?.length > 0) {
            this.cacheManager.roleList = response.RoleDtoList;
            if (!this.route.snapshot.paramMap.get("detailId")) {
                if (this.cacheManager.roleList.length == 1)
                    this.setRole(this.cacheManager.roleList[0]);
                else
                    this.selectRole();
            }
        }
    }
    ;
    selectChannel(event, channel, update = true) {
        if (!GlobalFunctions.isEmpty(event)) {
            event.stopPropagation();
            event.cancelBubble = false;
            channel.IsChecked = event.target.checked;
        }
        this.sessionManager.employeeStatus.changeChannelIndex(channel, this.translateService);
        this.changeUIAsPerChannelSelection();
        if (channel.Key == ContactTypeOption.Phone.toString())
            this.registerPhone();
        if (update) {
            this.updateEmployeeStatus();
            this.changeRememberChannelPreference(null, false);
        }
    }
    changeUIAsPerChannelSelection() {
        this.sessionManager.employeeStatus.isEmailFeatureEnabledFromChannel = this.sessionManager.employeeStatus.hasChannelEnabled(ContactTypeOption.Email);
        this.sessionManager.employeeStatus.isSocialMediaFeatureEnabledFromChannel = this.sessionManager.employeeStatus.hasChannelEnabled(ContactTypeOption.SocialMedia);
        this.sessionManager.employeeStatus.isPhoneFeatureEnabledFromChannel = this.sessionManager.employeeStatus.hasChannelEnabled(ContactTypeOption.Phone);
        this.sessionManager.employeeStatus.isLetterFeatureEnabledFromChannel = this.sessionManager.employeeStatus.hasChannelEnabled(ContactTypeOption.Letter);
        if (this.sessionManager.employeeStatus.isEmailFeatureEnabledFromChannel) {
            if (!this.sessionManager.actionMenu?.isMenuItemExists("EMAIL_DIALOG"))
                this.sessionManager.actionMenu?.addMenuItem("LBL_EMAIL", "EMAIL_DIALOG", OperationType.Email, GlobalFunctions.toContentType("Email"));
        }
        else {
            if (this.sessionManager.actionMenu?.isMenuItemExists("EMAIL_DIALOG"))
                this.sessionManager.actionMenu?.removeMenuItem("EMAIL_DIALOG");
        }
        if (this.sessionManager.employeeStatus.isSocialMediaFeatureEnabledFromChannel) {
            if (!this.sessionManager.actionMenu?.isMenuItemExists("ADD_SOCIALMEDIA"))
                this.sessionManager.actionMenu?.addMenuItem("LBL_SOCIALMEDIA", "ADD_SOCIALMEDIA", OperationType.Add, GlobalFunctions.toContentType("SocialMedia"));
        }
        else {
            if (this.sessionManager.actionMenu?.isMenuItemExists("ADD_SOCIALMEDIA"))
                this.sessionManager.actionMenu?.removeMenuItem("ADD_SOCIALMEDIA");
        }
    }
    ;
    registerPhone() {
        if (this.sessionManager.employeeStatus.isPhoneFeatureEnabledFromChannel && GlobalFunctions.isEmpty(this.phoneManager.phoneState.RegisteredExtension)) {
            this.phoneManager.resetScreenPosition();
            this.phoneManager.registerPhoneEvents();
            this.timeoutIds.push(setTimeout(() => {
                $("#mainPhoneContainer").show();
            }, 10));
            let extensionTextField = $("#extensionTextField");
            if (extensionTextField)
                extensionTextField.focus();
            let dialExtensionTextField = $("#dialExtensionTextField");
            if (dialExtensionTextField)
                dialExtensionTextField.focus();
            if (event != undefined && event != null)
                event.stopPropagation();
        }
        else if (!this.sessionManager.employeeStatus.isPhoneFeatureEnabledFromChannel) {
            $("#mainPhoneContainer").hide();
            this.phoneManager.unregisterExtension();
        }
    }
    ;
    selectAllChannel(event) {
        if (!GlobalFunctions.isEmpty(event)) {
            event.stopPropagation();
            event.cancelBubble = false;
            this.sessionManager.employeeStatus.selectedAllChannel = event.target.checked;
        }
        if (this.sessionManager.employeeStatus.channelList != null && this.sessionManager.employeeStatus.channelList.length > 0) {
            for (let index = 0; index < this.sessionManager.employeeStatus.channelList.length; index++) {
                let channel = this.sessionManager.employeeStatus.channelList[index];
                if (channel.IsChecked != this.sessionManager.employeeStatus.selectedAllChannel) {
                    channel.IsChecked = this.sessionManager.employeeStatus.selectedAllChannel;
                    this.selectChannel(null, channel, false);
                }
            }
            this.updateEmployeeStatus();
            this.changeRememberChannelPreference(null, false);
        }
    }
    ;
    hidePopup(id) {
        let element = $('#' + id);
        if (element != null)
            element.hide();
    }
    ;
    updateEmployeeStatus() {
        if (this.employeeService.loggedInEmployee != null) {
            let updateEmployeeStatusRequest = new UpdateEmployeeStatusRequest();
            updateEmployeeStatusRequest.EmployeeStatus = this.sessionManager.employeeStatus.getEmployeeStatus();
            if (this.sessionManager.selectedRole && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Name))
                updateEmployeeStatusRequest.EmployeeStatus.CurrentRole = this.sessionManager.selectedRole.Name;
            this.phoneManager.setEmployeePhoneStatus(updateEmployeeStatusRequest.EmployeeStatus);
            this.employeeService.updateEmployeeAvailabilityStatus(updateEmployeeStatusRequest);
        }
    }
    ;
    changeRememberChannelPreference($event, setEmpty) {
        if (!GlobalFunctions.isEmpty($event)) {
            $event.stopPropagation();
            $event.cancelBubble = false;
            this.sessionManager.employeeStatus.rememberChannelPreference = $event.target.checked;
        }
        if (this.sessionManager.employeeStatus.rememberChannelPreference)
            this.updateChannelPreference(this.sessionManager.employeeStatus.selectedAvailabilityChannelIndex);
        else if (setEmpty)
            this.updateChannelPreference("");
    }
    ;
    updateChannelPreference(channelPreference) {
        this.userSettingManager.setUserSettingValueByKey("CHANNELPREFERENCE", channelPreference);
        let userSettingDto = new Object();
        userSettingDto.Key = "CHANNELPREFERENCE";
        userSettingDto.Value = channelPreference;
        userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
        this.systemComponentService.updateUserSetting(userSettingDto);
    }
    ;
    nextEmailFeature() {
        if (this.applicationFeatureManager.isShowNextEmailFeatureEnabled && this.sessionManager.employeeStatus.isEmailFeatureEnabledFromChannel) {
            const preferredMailboxes = this.userSettingManager.getUserSettingValueByKey("mailboxPreference");
            if (this.sessionManager.isEWSEnabled && !preferredMailboxes)
                this.openMailboxPreferences(true);
            else {
                if (this.sessionManager.loadedFromNextEmailButton && this.sessionManager.selectedEntity && this.sessionManager.selectedEntity.RelatedEntityFqdn && GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn).toLowerCase() == "email") {
                    let headerDescription = "";
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_NEXT_EMAIL_WARNING"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                        if (result) {
                            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header.Subject))
                                headerDescription = this.sessionManager.selectedEntity.Header.Subject;
                            DialogHelper.openDialog(this.dialog, SessionSaveComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { uiObject: null, uiState: null, calledDialog: null, defaultDescription: headerDescription, clickedFrom: 'nextEmail' }, 'sessionSaveComponent').afterClosed().subscribe(innerResult => {
                                if (innerResult)
                                    this.sendOldestPendingEmailRequest();
                            });
                        }
                    });
                }
                else
                    this.checkPendingSession();
            }
        }
    }
    ;
    sendOldestPendingEmailRequest() {
        // this.loadDefaultTemplate();
        let preferredMailboxes = this.userSettingManager.getUserSettingValueByKey("mailboxPreference");
        let preferredMailboxArray = [];
        if (preferredMailboxes) {
            let mailboxesPreference = preferredMailboxes.split('|');
            if (!GlobalFunctions.isEmpty(mailboxesPreference) && mailboxesPreference.length > 0 && !GlobalFunctions.isEmpty(mailboxesPreference[0]))
                preferredMailboxArray = mailboxesPreference[0].split(';');
        }
        this.emailService.getOldestPendingEmail(this.emailContentFoundForNextEmail, preferredMailboxArray);
    }
    ;
    emailContentFoundForNextEmail(result) {
        if (!GlobalFunctions.isEmpty(result)) {
            this.sessionManager.startSessionIfPossible("EMAIL", ScreenMode.List);
            this.sessionManager.loadedFromNextEmailButton = true;
            let handlerObject = this.cacheManager.getEmployeeById(GlobalFunctions.getLoggedInUserId());
            result.Header.LookingOnUserName = handlerObject.StringRepresentation;
            this.sessionManager.loadedFromRelatedView = false;
            result.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.EMAIL}`;
            this.sessionManager.selectedEntity = result;
            this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]), true);
            this.sessionManager.addBreadcrumbItems([result], null, this.router.url);
            this.router.navigate([result.locationUrl]);
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_NO_PENDING_EMAILS") });
            this.router.navigate([RoutePath.DASHBOARD]);
        }
    }
    ;
    checkPendingSession() {
        if (this.sessionManager.hasPendingSession) {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_EMAIL"), textMsg: this.translateService.instant("LBL_PENDING_SESSION_WARNING"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (result) {
                    this.sessionManager.requestedContentItem = "session";
                    this.router.navigate([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, EntityName.TASK]);
                }
                else if (!result)
                    this.sendOldestPendingEmailRequest();
            });
        }
        else
            this.sendOldestPendingEmailRequest();
    }
    ;
    setEmployeeStatus() {
        let availabilityChannelStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Employees_Entities_Employee, "AVAILABILITYCHANNELS");
        this.sessionManager.employeeStatus.initializeChannelList(availabilityChannelStr, this.translateService);
        let freeStatusStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Employees_Entities_Employee, "EMPLOYEESAVAILABILITYTATUS");
        if (!GlobalFunctions.isEmpty(freeStatusStr)) {
            this.sessionManager.employeeStatus.statusList = [];
            let x2Js = new X2JS();
            let freeStatusJson = x2Js.xml2js(freeStatusStr);
            if (freeStatusJson != null && freeStatusJson.EmployeeAvailabilityStatuses != null && freeStatusJson.EmployeeAvailabilityStatuses.EmployeeAvailabilityStatus != null && freeStatusJson.EmployeeAvailabilityStatuses.EmployeeAvailabilityStatus.length > 0) {
                freeStatusJson.EmployeeAvailabilityStatuses.EmployeeAvailabilityStatus.forEach(employeeAvailabilityStatus => {
                    this.sessionManager.employeeStatus.statusList.push({
                        key: employeeAvailabilityStatus._AvailabilityStatusIndex,
                        value: employeeAvailabilityStatus._AvailabilityStatusText,
                        color: employeeAvailabilityStatus._AvailabilityColor
                    });
                });
                this.employeeService.getEmployeeStatusByKey(this.setCurrentStatus);
                this.sessionManager.employeeStatus.statusList.sort((a, b) => a.key - b.key);
            }
            if (this.sessionManager.employeeStatus.statusList.length < 1)
                this.sessionManager.employeeStatus.isEnabled = false;
            else
                this.sessionManager.employeeStatus.isEnabled = true;
        }
        this.subs.sink = this.userSettingManager.cacheUserSetting(GlobalFunctions.getLoggedInUserId()).subscribe(() => {
            if (this.sessionManager.employeeStatus) {
                let channelPreference = this.userSettingManager.getUserSettingValueByKey("CHANNELPREFERENCE");
                if (GlobalFunctions.isEmpty(channelPreference))
                    this.sessionManager.employeeStatus.rememberChannelPreference = false;
                else {
                    this.sessionManager.employeeStatus.rememberChannelPreference = true;
                    if (channelPreference == "0")
                        this.sessionManager.employeeStatus.selectedAvailabilityChannelIndex = "0";
                    else {
                        for (let index = 0; index < this.sessionManager.employeeStatus.channelList.length; index++) {
                            let channel = this.sessionManager.employeeStatus.channelList[index];
                            if (channelPreference.indexOf(channel.Key) != -1) {
                                channel.IsChecked = true;
                                this.selectChannel(null, channel, false);
                            }
                        }
                        this.updateEmployeeStatus();
                    }
                    this.sessionManager.employeeStatus.selectedAvailabilityChannelIndex = channelPreference;
                }
                this.changeUIAsPerChannelSelection();
            }
        });
    }
    ;
    setCurrentStatus(employeeStatus) {
        if (employeeStatus != null) {
            if (employeeStatus.Channels.length == 1 && employeeStatus.Channels[0] == "7") {
                this.sessionManager.employeeStatus.statusIndex = "1";
                this.sessionManager.employeeStatus.selectedAvailabilityChannelIndex = "0";
            }
            else
                this.sessionManager.employeeStatus.statusIndex = employeeStatus.CurrentStatus + "";
            this.sessionManager.employeeStatus.statusDescription = employeeStatus.CurrentStatusText;
            this.sessionManager.employeeStatus.restorePreviousChannelSelection(employeeStatus.Channels, this.translateService);
            this.changeUIAsPerChannelSelection();
            this.showNoChannelSelectedMessage = !GlobalFunctions.isEmpty(this.sessionManager.employeeStatus.channelList) && this.sessionManager.employeeStatus.selectedAvailabilityChannelIndex == "0" && location.pathname.toLowerCase().indexOf(`${RoutePath.DETAIL_PATH}/callbacknote`) === -1;
            if (this.showNoChannelSelectedMessage)
                this.showHeaderOnTop();
        }
        this.changeAvailabilityStatus(null);
    }
    ;
    changeAvailabilityStatus(key) {
        if (!GlobalFunctions.isEmpty(key))
            this.sessionManager.employeeStatus.statusIndex = key;
        this.sessionManager.employeeStatus.changeStatusIndex(this.sessionManager.employeeStatus.statusIndex);
        this.updateEmployeeStatus();
    }
    ;
    handleEscEvent(keyCode, event) {
        switch (keyCode) {
            case 27:
                {
                    if ($("#mainPhoneContainer") != null && $("#mainPhoneContainer").is(":visible"))
                        $("#mainPhoneContainer").toggle();
                    if ($("#advancedSearchMenu") != null && $("#advancedSearchMenu").hasClass('open'))
                        $("#advancedSearchMenu").removeClass('open');
                    $("#applicationBody").focus();
                    break;
                }
        }
    }
    openAddTicket(ticketType) {
        this.closePopups();
        this.dialogManager.openAddTicket(ticketType, this.viewContainerRef);
    }
    ;
    setTicketsConfiguration() {
        let configuration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
        if (!GlobalFunctions.isEmpty(configuration)) {
            if (!GlobalFunctions.isEmpty(configuration.TicketTypes))
                this.showTicketsDropdown = jlinq.from(configuration.TicketTypes).equals("HasAddRight", true).any();
            if (!GlobalFunctions.isEmpty(configuration.TicketGroupTitle)) {
                let titleParts = configuration.TicketGroupTitle.split("|");
                // Assign Action menu title
                if (titleParts[0] && !GlobalFunctions.isEmpty(titleParts[0].trim()))
                    this.translateService.set('LBL_TICKET', titleParts[0].trim());
                // Assign Dashboard Left menu title
                if (titleParts[1] && !GlobalFunctions.isEmpty(titleParts[1].trim()))
                    this.translateService.set('LBL_TICKETS', titleParts[1].trim());
            }
            this.ticketsConfiguration = configuration;
        }
    }
    ;
    showHeaderOnTop(isTrue = false) {
        this.sessionManager.showUIOnTop = this.actionMenu || this.availabilityChannelMenu || this.settingMenuItem || this.showNoChannelSelectedMessage || isTrue || this.phoneStatusMenu;
        if ($('#mainPhoneContainer:visible').length != 0)
            this.sessionManager.showUIOnTop = true;
    }
    ;
    updateProfile() {
        if (this.employeeService.loggedInEmployee.IsNative)
            this.openJsPanelOrDialog('PROFILE_DIALOG');
    }
    logout() {
        if (this.sessionManager.isSessionStart)
            this.dialogManager.showEndSessionDialog();
        else
            this.dialogManager.showLogoutDialog().afterClosed().subscribe(result => {
                if (result)
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT);
            });
    }
    setPhoneIcon() {
        let phoneIconClass = 'jkcPhoneOfflineWhite jkcSizeMedium';
        if (!GlobalFunctions.isEmpty(this.phoneManager.phoneState.RegisteredExtension))
            phoneIconClass = 'jkcPhoneOnlineWhite jkcSizeMedium';
        if (this.phoneManager.phoneState.CurrentState != CallStatus.Unregistered && this.phoneManager.phoneState.PhoneAvailableStatus === PhoneStatus.NotAvailable)
            phoneIconClass = 'jkcPhoneBusyWhite jkcSizeMedium';
        return phoneIconClass;
    }
    showCurrentHandlerTitle(value) {
        return GlobalFunctions.showCurrentHandlerTitle(value);
    }
    openAboutUs() {
        DialogHelper.openDialog(this.dialog, AboutComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    openKeyShortcut() {
        DialogHelper.openDialog(this.dialog, ShortcutsComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { hotkeys: this.shortcutManager.getShortcutDetails(this.phoneManager, this.applicationFeatureManager) });
    }
    openOutbox() {
        DialogHelper.openDialog(this.dialog, OutboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState)).afterClosed().subscribe(result => {
            if (result)
                this.dialogManager.openJsPanelOrDialog("EMAIL_DIALOG", true, null, false, this.viewContainerRef);
        });
    }
    openEmployeePanel() {
        DialogHelper.openDialog(this.dialog, EmployeePanelComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { isSearchSelected: false }, 'employeePanelComponent').afterClosed().subscribe(result => {
            if (result?.emailId != undefined && result?.targetButton == "SEND_EMAIL" && GlobalFunctions.checkRights('Email'))
                this.dialogManager.loadSendEmailDialog(result.emailId);
            else if (result?.targetButton != undefined)
                this.openJsPanelOrDialog(result.targetButton);
        });
    }
    openFeedback() {
        DialogHelper.openDialog(this.dialog, FeedbackComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    openMailboxPreferences(autoSave) {
        DialogHelper.openDialog(this.dialog, MailboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { autoSave });
    }
    openTaskReminder() {
        DialogHelper.openDialog(this.dialog, TaskReminderComponent, '100%', 'auto', '52vh', '43vw');
    }
    ;
    redirectToManagementConsole() {
        window.open(window.location.protocol + "//" + window.location.host + "//ManagementConsole", '_blank');
    }
    saveStatusText() {
        this.updateEmployeeStatus();
    }
    ;
    loadSearchResultView(domain) {
        let url = `${RoutePath.LIST}/`;
        switch (domain.toUpperCase()) {
            case Domain.THEME:
            case Domain.PERSON:
                url = url.replace(':domain', domain.toLowerCase());
                break;
        }
        this.router.navigate([url], { replaceUrl: true });
    }
    onSelected(selection) {
        if (!selection.item) {
            this.sessionManager.startSessionIfPossible(selection.searchType, ScreenMode.List);
            let selectedSearchOption = {
                style: selection.style,
                selectable: selection.selectable,
                searchType: selection.searchType,
                searchQuery: this.searchService.searchQuery,
                formattedText: selection.formattedText,
                item: selection.item,
                currentDateTime: new Date(),
                url: selection.url,
                sourceLocation: selection.sourceLocation
            };
            this.searchService.searchOptionChanged(selectedSearchOption);
        }
        else
            this.popularSelect(selection.item);
    }
    ;
    loadEformLink(eform) {
        if (eform.IsPrefillable)
            this.productService.showEform(eform.Url);
        else
            GlobalFunctions.popUpCenter(eform.Url, 1024, 550);
    }
    menuPhoneClick(event) {
        this.phoneManager.resetScreenPosition();
        let showUI = false;
        $("#mainPhoneContainer").toggle(() => {
            if ($("#mainPhoneContainer").is(":visible"))
                showUI = true;
            else if ($("#availabilityChannelList:visible").length == 0)
                showUI = false;
        });
        this.sessionManager.showUIOnTop = showUI;
        let extensionTextField = $("#extensionTextField");
        if (extensionTextField)
            extensionTextField.focus();
        let dialExtensionTextField = $("#dialExtensionTextField");
        if (dialExtensionTextField)
            dialExtensionTextField.focus();
        $("#dialPadDiv").show();
        $("#btnPhoneCall").show();
        $("#employeeSearchDiv").hide();
        $("#popular").show();
        $("#dialerPad").hide();
        $("#dialExtensionTextField").val('');
        document.getElementById('advancedSearchDropdown').style.display = "none";
        if (event != null)
            event.stopPropagation();
    }
    changePhoneStatus(phoneStatus) {
        this.phoneManager.phoneState.SelectedPhoneStatus = phoneStatus;
        let key = phoneStatus.key === "2" ? PhoneStatus.NotAvailable : phoneStatus.key;
        this.phoneManager.updatePhoneAvailabilityStatus(key, phoneStatus.code);
    }
    openActionMenuDialog() {
        const dialogName = this.sessionManager.actionMenu.defaultActionMenuItem.key;
        const actionMenuKeys = this.sessionManager.actionMenu.defaultActionMenuItem.key.split('|');
        if (actionMenuKeys[0] == "ADD_TICKET")
            this.openAddTicket(jlinq.from(this.ticketsConfiguration.TicketTypes).equals("Id", actionMenuKeys[1]).first());
        else if (actionMenuKeys[0] == "_EFORM_")
            this.loadEformLink(jlinq.from(this.eformLinkList).equals("Id", actionMenuKeys[1]).first());
        else
            this.openJsPanelOrDialog(dialogName);
    }
    ;
    setDefaultActionMenu() {
        const defaultActionMenuSetting = this.applicationSettingManager.getApplicationSettingValueByKey("ConfigureDefaultActionMenu");
        if (defaultActionMenuSetting) {
            const actionMenuKeys = defaultActionMenuSetting.split('|');
            if (actionMenuKeys[0] == "ADD_TICKET") {
                if (!GlobalFunctions.isEmpty(actionMenuKeys[1]) && !GlobalFunctions.isEmpty(this.ticketsConfiguration) && !GlobalFunctions.isEmpty(this.ticketsConfiguration.TicketTypes)) {
                    const ticketContentType = GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket]);
                    const ticketTypeId = actionMenuKeys[1];
                    if (GlobalFunctions.hasRight(ticketContentType, OperationType.Add, ticketTypeId)) {
                        const ticket = jlinq.from(this.ticketsConfiguration.TicketTypes).equals("Id", actionMenuKeys[1]).first();
                        this.sessionManager.actionMenu.defaultActionMenuItem = { key: defaultActionMenuSetting, title: ticket?.Title };
                    }
                }
            }
            else {
                const defaultActionMenuItem = jlinq.from(this.sessionManager.actionMenu.actionMenuItems).equals("key", actionMenuKeys[0]).first();
                if (defaultActionMenuItem)
                    this.sessionManager.actionMenu.defaultActionMenuItem = defaultActionMenuItem;
            }
        }
    }
    openHelpUrl(key) {
        CommonHelper.openHelpUrl(key);
    }
    getVersionInfo() {
        this.subs.sink = this.applicationSettingManager.getVersion(environment.api_url + '/AppData?param=versionNumber').subscribe(result => {
            if (!GlobalFunctions.isEmpty(result))
                this.sessionManager.applicationInfo.ApplicationVersion = result;
        });
    }
    redirectToAdmin() {
        this.subs.sink = this.applicationSettingManager.getVersion(environment.api_url + '/AppData?param=appsettingkey&appsettingvalue=JKCAdminUrl').subscribe(result => {
            if (!GlobalFunctions.isEmpty(result))
                window.open(result, '_blank');
        });
    }
    focusSearch() {
        this.closePopups();
        if (!GlobalFunctions.isEmpty(this.headerSearchBox) && !GlobalFunctions.isEmpty(this.headerSearchBox.nativeElement))
            this.headerSearchBox.nativeElement.focus();
    }
    focusLocalSearch() {
        document.getElementById('localsearch')?.focus();
    }
    focusAdvancedSearch() {
        this.closePopups();
        if (!GlobalFunctions.isEmpty(this.advancedSearchComp)) {
            this.advancedSearchComp.advancedSearchDropdown.nativeElement.style.display = 'block';
            this.advancedSearchComp.advancedSearchSelectOption.nativeElement.focus();
        }
    }
    openActionMenuList() {
        this.closePopups();
        this.timeoutIds.push(setTimeout(() => {
            // Let Bootstrap open the dropdown natively
            this.actionMenuDropDownToggle.nativeElement.click();
        }, 500));
    }
    openSettingContextMenu() {
        this.closePopups();
        this.timeoutIds.push(setTimeout(() => {
            // Let Bootstrap open the dropdown natively
            this.menuSettingDropDown.nativeElement.click();
            if (!GlobalFunctions.isEmpty(this.employeeAvailabilityStatusText) && !GlobalFunctions.isEmpty(this.employeeAvailabilityStatusText.nativeElement))
                this.employeeAvailabilityStatusText.nativeElement.focus();
        }, 500));
    }
    closePopups() {
        if (!GlobalFunctions.isEmpty(this.headerSearchBox) && !GlobalFunctions.isEmpty(this.headerSearchBox.nativeElement))
            this.headerSearchBox.nativeElement.blur();
        if (!GlobalFunctions.isEmpty(this.settingMenuItems) && !GlobalFunctions.isEmpty(this.settingMenuItems.nativeElement))
            this.settingMenuItems.nativeElement?.classList.remove('show');
        if (!GlobalFunctions.isEmpty(this.dropDownActionMenuItems) && !GlobalFunctions.isEmpty(this.dropDownActionMenuItems.nativeElement))
            this.dropDownActionMenuItems.nativeElement.classList.remove('show');
        if (!GlobalFunctions.isEmpty(this.advancedSearchComp))
            this.advancedSearchComp.advancedSearchDropdown.nativeElement.style.display = 'none';
    }
    setFetchPrefillEformLinksComplete(response) {
        let applicationEFormList = [];
        if (response.EFormDtoList?.length > 0) {
            for (let index = 0; index < response.EFormDtoList.length; index++) {
                if (response.EFormDtoList[index].Level == 0)
                    applicationEFormList.push(response.EFormDtoList[index]);
            }
        }
        this.eformLinkList = applicationEFormList;
        this.integrationSettingManager.addIntegrationSetting("EformList", "PREFILLEFORMLINKS", applicationEFormList);
        const defaultActionMenuSetting = this.applicationSettingManager.getApplicationSettingValueByKey("ConfigureDefaultActionMenu");
        if (defaultActionMenuSetting) {
            const actionMenuKeys = defaultActionMenuSetting.split('|');
            if (actionMenuKeys[0] == "_EFORM_") {
                if (!GlobalFunctions.isEmpty(actionMenuKeys[1]) && !GlobalFunctions.isEmpty(applicationEFormList)) {
                    const eform = jlinq.from(applicationEFormList).equals("Id", actionMenuKeys[1]).first();
                    this.sessionManager.actionMenu.defaultActionMenuItem = { key: defaultActionMenuSetting, title: eform.Description };
                }
            }
        }
    }
    ;
    unbindShortcuts() {
        this.shortcutManager?.unbind('LBL_SHORTCUT_SEARCH_BOX');
        this.shortcutManager?.unbind('LBL_SHORTCUT_SEARCH_WITHIN_RESULTS');
        this.shortcutManager?.unbind('LBL_SHORTCUT_ADVANCE_SEARCH');
        this.shortcutManager?.unbind('LBL_SHORTCUT_ADD_CALLBACK_NOTE');
        this.shortcutManager?.unbind('LBL_SHORTCUT_SEND_EMAIL');
        this.shortcutManager?.unbind('LBL_SHORTCUT_EMPLOYEE_POPUP_PANEL');
        this.shortcutManager?.unbind('LBL_SHORTCUT_PHONE');
        this.shortcutManager?.unbind('LBL_SHORTCUT_NEXT_EMAIL');
        this.shortcutManager?.unbind('LBL_SHORTCUT_ACTIVATE_ACTION_MENU');
        this.shortcutManager?.unbind('LBL_SHORTCUT_ACTIVATE_SETTING_MENU');
    }
    clickedOut(event) {
        const target = event.target;
        // Advanced search
        if (this.advancedSearchComp?.advancedSearchDropdown && !this.advancedSearchComp?.advancedSearchDropdown?.nativeElement.contains(target)) {
            const backdrop = document.querySelector('.cdk-overlay-backdrop');
            if (!backdrop || window.getComputedStyle(backdrop).display === 'none')
                this.advancedSearchComp.advancedSearchDropdown.nativeElement.style.display = 'none';
        }
    }
};
__decorate([
    ViewChild('dropDownActionMenuItems')
], HeaderComponent.prototype, "dropDownActionMenuItems", void 0);
__decorate([
    ViewChild('settingMenuItems')
], HeaderComponent.prototype, "settingMenuItems", void 0);
__decorate([
    ViewChild('headerSearchBox')
], HeaderComponent.prototype, "headerSearchBox", void 0);
__decorate([
    ViewChild('employeeAvailabilityStatusText')
], HeaderComponent.prototype, "employeeAvailabilityStatusText", void 0);
__decorate([
    ViewChild('actionMenuDropDownToggle')
], HeaderComponent.prototype, "actionMenuDropDownToggle", void 0);
__decorate([
    ViewChild('menuSettingDropDown')
], HeaderComponent.prototype, "menuSettingDropDown", void 0);
__decorate([
    ViewChild(AdvancedSearchComponent)
], HeaderComponent.prototype, "advancedSearchComp", void 0);
__decorate([
    HostListener("document:click", ['$event'])
], HeaderComponent.prototype, "clickedOut", null);
HeaderComponent = __decorate([
    Component({
        selector: 'header-content',
        templateUrl: './header.component.html',
        styleUrls: ['./header.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], HeaderComponent);
export { HeaderComponent };
//# sourceMappingURL=header.component.js.map