var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { SubSink } from 'subsink';
import { FilterList } from '../../../core/models/filter/filter-list';
import { DialogHelper } from '../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../shared/helper/exception-helper';
import { FilterColumnListComponent } from '../filter-column-list/filter-column-list.component';
let FilterListComponent = class FilterListComponent {
    constructor(dialog, sessionManager) {
        this.dialog = dialog;
        this.sessionManager = sessionManager;
        this.filterList = new FilterList();
        this.showFilterList = false;
        this.setResultList = new EventEmitter();
        this.subs = new SubSink();
    }
    ngOnInit() {
        try {
            for (let i = 0; i < this.filterList.FilterOptions.length; i++) {
                let filterOption = this.filterList.FilterOptions[i];
                if (!filterOption.Enabled)
                    filterOption.Enabled = true;
            }
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, null, true, e.message, "");
        }
    }
    ;
    ngOnChanges(changes) {
        if (changes.filterList && !changes.filterList.firstChange)
            this.ngOnInit();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    togglePanel() {
        this.showFilterList = !this.showFilterList;
    }
    ;
    selectOrDeselectFilterOption(filterOption) {
        if (filterOption.Selected) {
            this.filterList.FilterOptions.forEach(option => {
                if (option.Id == filterOption.Id) {
                    filterOption.Entries.forEach(entity => {
                        entity.Selected = true;
                        this.updateFilterList(filterOption, entity, true);
                    });
                }
            });
        }
        else {
            this.filterList.FilterOptions.forEach(option => {
                if (option.Id == filterOption.Id) {
                    filterOption.Entries.forEach(entity => {
                        entity.Selected = false;
                        this.updateFilterList(filterOption, entity, false);
                    });
                }
            });
        }
        this.setResultList.emit();
    }
    disableFilterOption(filterOption) {
        filterOption.Enabled = false;
        filterOption.Selected = false;
        filterOption.Entries.forEach(entity => entity.Selected = false);
        let removedFilterList = jlinq.from(this.filterList.Filters).equals("Id", filterOption.Id).select();
        while (removedFilterList.length)
            this.filterList.Filters.splice(this.filterList.Filters.indexOf(removedFilterList.pop()), 1);
        this.setResultList.emit();
    }
    applyUpdatedFilterColumnList() {
        this.filterList.FilterOptions.forEach(filterOption => {
            if (!filterOption.Enabled) {
                filterOption.Selected = false;
                filterOption.Entries.forEach((entity) => {
                    entity.Selected = false;
                    let filter = jlinq.from(this.filterList.Filters).equals("Title", entity.Title).first();
                    if (filter)
                        this.filterList.Filters.splice(this.filterList.Filters.indexOf(filter), 1);
                });
            }
        });
        this.setResultList.emit();
    }
    ;
    addOrRemoveFilter(filterOption, entry) {
        this.updateFilterList(filterOption, entry, entry.Selected);
        this.setResultList.emit();
    }
    ;
    updateFilterList(filterOption, entry, isSelected) {
        let filter = jlinq.from(this.filterList.Filters).equals("Key", entry.Key).equals("Id", filterOption.Id).first();
        if (isSelected) {
            if (!filter) {
                filter = new Object();
                filter.Id = filterOption.Id;
                filter.Key = entry.Key;
                filter.Title = entry.Title;
                filter.Type = filterOption.Title;
                this.filterList.Filters.push(filter);
            }
        }
        else {
            filterOption.Selected = false;
            if (filter)
                this.filterList.Filters.splice(this.filterList.Filters.indexOf(filter), 1);
        }
    }
    ;
    arrangeFilterColumn(event) {
        event?.stopPropagation();
        DialogHelper.openDialog(this.dialog, FilterColumnListComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { filterOptions: this.filterList.FilterOptions }).afterClosed().subscribe(result => {
            if (result) {
                this.showFilterList = true;
                this.applyUpdatedFilterColumnList();
            }
        });
    }
    ;
    removeFilter(event, filter) {
        event.stopPropagation();
        this.filterList.Filters.splice(this.filterList.Filters.indexOf(filter), 1);
        this.filterList.FilterOptions.forEach(filterOption => {
            filterOption.Entries.forEach(entity => {
                if (filterOption.Id == filter.Id && entity.Key == filter.Key) {
                    filterOption.Selected = false;
                    entity.Selected = false;
                }
            });
        });
        this.setResultList.emit();
    }
    ;
    resetAll(event) {
        event.stopPropagation();
        this.filterList.FilterOptions.forEach(filterOption => {
            filterOption.Selected = false;
            filterOption.Entries.forEach(entity => entity.Selected = false);
        });
        this.filterList.Filters = [];
        this.setResultList.emit();
    }
    ;
    noFiltersEnabled() {
        return this.filterList.FilterOptions.length > 0 && this.filterList.EnableAddColumn && !this.filterList.FilterOptions.some(x => x.Enabled);
    }
};
__decorate([
    Input()
], FilterListComponent.prototype, "filterList", void 0);
__decorate([
    Output()
], FilterListComponent.prototype, "setResultList", void 0);
FilterListComponent = __decorate([
    Component({
        selector: 'filter-list',
        templateUrl: './filter-list.component.html',
        styleUrls: ['./filter-list.component.scss']
    })
], FilterListComponent);
export { FilterListComponent };
//# sourceMappingURL=filter-list.component.js.map