var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from '../../../shared/global-functions';
let FeedbackComponent = class FeedbackComponent {
    constructor(employeeService, translateService, dialogRef, sessionManager) {
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.sessionManager = sessionManager;
    }
    ngOnInit() {
        this.generateFeedbackUrl();
        this.sessionManager.showUIOnTop = false;
    }
    generateFeedbackUrl() {
        this.feedbackUrl = 'https://decos.freshdesk.com/widgets/feedback_widget/new?&widgetType=embedded&formTitle={FEEDBACK_WELCOME_MESSAGE}&screenshot=No&searchArea=no&helpdesk_ticket[requester]={FEEDBACK_EMAIL}&helpdesk_ticket[name]={FEEDBACK_NAME}&helpdesk_ticket[subject]=Feedback:&helpdesk_ticket[ticket_type]={FEEDBACK_PRODUCT_NAME}&helpdesk_ticket[custom_field][cf_versie_416176]={FEEDBACK_PRODUCT_VERSION}&helpdesk_ticket[custom_field][melding_416176]=Feedback&helpdesk_ticket[custom_field][cf_voor_thijs_416176]=Productie&helpdesk_ticket[custom_field]cf_locatie_jkc_416176]=Lokaal&submitTitle=Submit&submitThanks={FEEDBACK_THANK_YOU_MESSAGE}&disable[name]=true&disable[ticket_type]=true&disable[custom_field][cf_versie_416176]=true&disable[custom_field][melding_416176]=Feedback&disable[custom_field][melding_416176]=true&disable[custom_field][cf_voor_thijs_416176]=true&helpdesk_ticket[custom_field][cf_dreiging_416176]=Geen impact&disable[custom_field][cf_dreiging_416176]=true';
        this.feedbackUrl = this.feedbackUrl.replace(/{FEEDBACK_WELCOME_MESSAGE}/g, this.translateService.instant('LBL_FEEDBACK_WELCOME_MESSAGE'));
        if (GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee.EmailAddress)) {
            this.feedbackUrl = this.feedbackUrl.replace(/{FEEDBACK_EMAIL}/g, '');
        }
        else {
            this.feedbackUrl = this.feedbackUrl.replace(/{FEEDBACK_EMAIL}/g, this.employeeService.loggedInEmployee.EmailAddress);
            this.feedbackUrl = this.feedbackUrl + '&disable[requester]=true';
        }
        this.feedbackUrl = this.feedbackUrl.replace(/{FEEDBACK_NAME}/g, this.employeeService.loggedInEmployee.EmailAddress);
        this.feedbackUrl = this.feedbackUrl.replace(/{FEEDBACK_PRODUCT_NAME}/g, 'JOIN klantcontact');
        this.feedbackUrl = this.feedbackUrl.replace(/{FEEDBACK_PRODUCT_VERSION}/g, '2.0');
        this.feedbackUrl = this.feedbackUrl.replace(/{FEEDBACK_THANK_YOU_MESSAGE}/g, this.translateService.instant('LBL_FEEDBACK_THANKYOU_MESSAGE'));
    }
    closeModal() {
        this.dialogRef.close();
    }
};
FeedbackComponent = __decorate([
    Component({
        selector: 'feedback',
        templateUrl: './feedback.component.html',
        styleUrls: ['./feedback.component.scss']
    })
], FeedbackComponent);
export { FeedbackComponent };
//# sourceMappingURL=feedback.component.js.map