var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Output } from '@angular/core';
import { RecordOperationMode } from '../../../core/enums/common-enums';
import { SessionStatus } from '../../../core/enums/session-enum';
import { DashboardWebpartLink } from '../../../core/models/dashboard/dashboard-webpart-link';
import { FavouriteDto } from '../../../core/models/dashboard/favouriteDto';
import { BroadCastEventKeys, RoutePath } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
import { DialogHelper } from '../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../shared/helper/exception-helper';
import { ContextMenuComponent } from '../context-menu.component';
import { MessageboxComponent } from '../messagebox/messagebox.component';
let BreadcrumbComponent = class BreadcrumbComponent extends ContextMenuComponent {
    constructor(cacheManager, dialogManager, sessionManager, systemComponentService, sessionService, datePipe, localSearchResultDataService, router, zone, dialog, changeDetectorRef, viewContainerRef, translateService, eventProvider, suggestionPanelManager, taskService, linkService, socialMediaService, themeService, contactHistoryService, fileentityService, productService, integrationSettingManager, noteService, emailService, userSettingManager, ticketService, phoneManager, contextMenuService, organizationService, personService, searchService, shortcutManager, location, applicationSettingManager) {
        super(cacheManager, dialogManager, sessionManager, userSettingManager, integrationSettingManager, noteService, emailService, systemComponentService, translateService, router, zone, dialog, changeDetectorRef, viewContainerRef, eventProvider, suggestionPanelManager, taskService, linkService, socialMediaService, themeService, contactHistoryService, fileentityService, localSearchResultDataService, productService, ticketService, phoneManager, organizationService, personService, shortcutManager, contextMenuService, location, applicationSettingManager);
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.systemComponentService = systemComponentService;
        this.sessionService = sessionService;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.translateService = translateService;
        this.eventProvider = eventProvider;
        this.suggestionPanelManager = suggestionPanelManager;
        this.taskService = taskService;
        this.linkService = linkService;
        this.socialMediaService = socialMediaService;
        this.themeService = themeService;
        this.contactHistoryService = contactHistoryService;
        this.fileentityService = fileentityService;
        this.productService = productService;
        this.integrationSettingManager = integrationSettingManager;
        this.noteService = noteService;
        this.emailService = emailService;
        this.userSettingManager = userSettingManager;
        this.ticketService = ticketService;
        this.phoneManager = phoneManager;
        this.contextMenuService = contextMenuService;
        this.organizationService = organizationService;
        this.personService = personService;
        this.searchService = searchService;
        this.shortcutManager = shortcutManager;
        this.location = location;
        this.applicationSettingManager = applicationSettingManager;
        this.RoutePath = RoutePath;
        this.hideActionButtons = false;
        this.localSearchTextChange = new EventEmitter();
        this.detailSearchTextChange = new EventEmitter();
        this.timeoutIds = [];
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RESIZE_CSN).subscribe(() => this.resize());
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.OPEN_VIEWER_PANEL).subscribe(() => this.resize());
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.TOGGLE_VIEWER_PANEL).subscribe(() => this.resize());
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.TOGGLE_SUGGESTION_PANEL).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.resize();
        this.bindShortcuts();
    }
    ngOnDestroy() {
        this.unbindShortcuts();
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    loadInViewer() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
            let itemToLoad = this.sessionManager.selectedEntity;
            if (this.sessionManager.BreadcrumbItems.length > 1) {
                let selectedBreadcrumbItem = this.sessionManager.BreadcrumbItems[1];
                this.loadBreadCrumbItem(selectedBreadcrumbItem[0], selectedBreadcrumbItem, false, true);
            }
            else {
                this.navigate(RoutePath.DASHBOARD, true);
            }
            requestAnimationFrame(() => {
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, itemToLoad);
            });
        }
    }
    favouriteToggle() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
            let favouriteDto = new FavouriteDto(this.sessionManager.selectedEntity);
            if (this.sessionManager.selectedEntity.IsFavourite) {
                this.systemComponentService.makeFavourite(favouriteDto, RecordOperationMode.Delete);
                this.sessionManager.selectedEntity.IsFavourite = false;
                this.cacheManager.removeItemFromDashboardCache("MyFavourite", favouriteDto);
            }
            else {
                this.systemComponentService.makeFavourite(favouriteDto, RecordOperationMode.New);
                this.sessionManager.selectedEntity.IsFavourite = true;
                let webpartItem = new DashboardWebpartLink().FromFavourite(favouriteDto);
                this.cacheManager.addItemToDashboardCache("MyFavourite", webpartItem);
            }
        }
    }
    createSessionErrorCallback(status) {
        if (status == 0) {
            this.sessionManager.endSession();
            if (!GlobalFunctions.isEmpty(this.loadItem))
                this.sessionManager.loadSession(this.loadItem, this.dialogManager, this.viewContainerRef);
        }
        else {
            let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant("LBL_CREATE_ERROR_MSG"), [this.translateService.instant("LBL_SESSION")]);
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), helpMessage, "");
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    saveExistingSession(item, saveSession, sessionItem) {
        if (saveSession) {
            let session = this.sessionManager.createCurrentSession(SessionStatus.Park, item.Description, null, item.uiObject, item.uiState, this.sessionManager.sessionStartDateTime);
            this.sessionService.createOrUpdateSession(session, null, this.createSessionErrorCallback);
            this.loadItem = sessionItem;
        }
        else {
            if (!GlobalFunctions.isEmpty(item.Id))
                this.sessionService.handleSession(item.Id, null);
            this.sessionManager.endSession();
        }
    }
    loadBreadCrumbItem(breadCrumItem, currentBreadcrumList, fromSubMenu, fromViewer = false) {
        if (breadCrumItem?.isDeleted || breadCrumItem?.isDisabled || (GlobalFunctions.isEmpty(breadCrumItem?.locationUrl) && this.router.url.toLowerCase() === breadCrumItem?.locationUrl?.toLowerCase() && GlobalFunctions.isEmpty(breadCrumItem?.sourceUrl) && breadCrumItem?.sourceUrl?.toLowerCase().indexOf(RoutePath.LIST_PATH) != -1 && fromSubMenu))
            return;
        this.sessionManager.loadedFromRelatedView = false;
        if (breadCrumItem?.itemData != null && breadCrumItem?.itemData?.RelatedEntityFqdn.indexOf("Item") != -1 && !breadCrumItem?.itemData?.HasDetailView && fromSubMenu) {
            window.open(breadCrumItem?.itemData?.Link, "_blank");
            return;
        }
        if (breadCrumItem?.itemData != null && breadCrumItem?.itemData?.RelatedEntityFqdn.indexOf("Session") != -1) {
            if (this.sessionManager.currentSession != null) {
                const messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_SESSION"), this.translateService.instant("LBL_MESSAGE_HANDLE_SESSION"), true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                    if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession)) {
                        if (result)
                            this.saveExistingSession(this.sessionManager.currentSession, true, breadCrumItem.itemData);
                        else {
                            if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession.Id))
                                this.saveExistingSession(this.sessionManager.currentSession, false, null);
                            this.sessionManager.loadSession(breadCrumItem.itemData, this.dialogManager, this.viewContainerRef);
                        }
                    }
                });
            }
            else
                this.sessionManager.loadSession(breadCrumItem?.itemData, this.dialogManager, this.viewContainerRef);
            return;
        }
        currentBreadcrumList?.forEach(item => item.isSelected = item.itemData.Id == breadCrumItem?.itemData?.Id ? true : false);
        if (!GlobalFunctions.isEmpty(breadCrumItem?.sourceUrl) && breadCrumItem?.sourceUrl.toLowerCase().indexOf(RoutePath.LIST_PATH) == -1 || fromSubMenu) {
            if (!GlobalFunctions.isEmpty(this.sessionManager.BreadcrumbItems[0][0].locationUrl) && !GlobalFunctions.isEmpty(breadCrumItem?.locationUrl) && this.sessionManager.BreadcrumbItems[0][0].locationUrl.toLowerCase() !== breadCrumItem?.locationUrl?.toLowerCase())
                this.sessionManager.addBreadcrumbTypeItems([breadCrumItem], fromSubMenu, true);
            else if (breadCrumItem?.loadFirstElement)
                this.sessionManager.addBreadcrumbTypeItems([breadCrumItem], fromSubMenu, true);
            if (breadCrumItem?.itemData?.ScheduledWorkType != undefined && breadCrumItem?.itemData?.ObjectSourceDto != undefined)
                this.sessionManager.selectedEntity = breadCrumItem?.itemData?.ObjectSourceDto;
            else {
                let cacheObject = this.sessionManager.getItemsFromDetailViewCacheList(breadCrumItem?.itemData?.Id);
                if (cacheObject != null)
                    this.sessionManager.selectedEntity = cacheObject;
                else
                    this.sessionManager.selectedEntity = breadCrumItem?.itemData;
            }
            this.sessionManager.SelectedBreadcrumbItem.title = this.sessionManager.selectedEntity.Title != undefined ? this.sessionManager.selectedEntity.Title : this.sessionManager.selectedEntity.StringRepresentation;
            if (GlobalFunctions.isEmpty(breadCrumItem?.locationUrl)) {
                let contentType = GlobalFunctions.getObjectTypeName(breadCrumItem.itemData.RelatedEntityFqdn).toLowerCase();
                breadCrumItem.locationUrl = `${RoutePath.DETAIL_PATH}/${contentType}/${breadCrumItem.itemData.Id}`;
            }
            this.navigateToDetail(breadCrumItem?.locationUrl, fromViewer);
        }
        else {
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
            if (currentBreadcrumList != null && currentBreadcrumList.length > 0) {
                this.sessionManager.addBreadcrumbTypeItems(currentBreadcrumList, fromSubMenu);
                this.localSearchResultDataService.localSearchResultData.contentType = breadCrumItem?.sourceUrl.substring(breadCrumItem?.sourceUrl?.lastIndexOf("/") + 1);
                currentBreadcrumList.forEach((breadcrumb) => {
                    this.localSearchResultDataService.localSearchResultData.localResult.push(breadcrumb?.itemData);
                    this.localSearchResultDataService.localSearchResultData.contentType = breadcrumb?.sourceUrl?.substring(breadcrumb?.sourceUrl?.lastIndexOf("/") + 1);
                });
                if (currentBreadcrumList[0].sourceUrl.includes(`/${RoutePath.LIST_PATH}/${RoutePath.ACTIVITY_PATH}?:`))
                    this.checkAndNavigateToActivityScreen(currentBreadcrumList);
                else
                    this.navigateToDetail(currentBreadcrumList[0].sourceUrl, fromViewer);
            }
        }
    }
    navigateToDetail(url, fromViewer) {
        this.navigate(url, true);
        let domainUrl = url?.split('/').length > 2 ? url.split('/', 2).join('/') : url;
        if (this.router.url.indexOf(domainUrl) != -1 && !fromViewer)
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
    }
    loadHistoryItem() {
        this.sessionManager.loadedFromRelatedView = false;
        if (this.sessionManager.selectedBreadcrumbIndex == null)
            this.sessionManager.selectedBreadcrumbIndex = 0;
        this.sessionManager.selectedBreadcrumbIndex += 1;
        if (this.sessionManager.selectedBreadcrumbIndex <= this.sessionManager.BreadcrumbItems.length - 1) {
            this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex - 1].isLoaded = true;
            while (this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex].isLoaded == true)
                this.sessionManager.selectedBreadcrumbIndex += 1;
            let currentBreadcrumList = this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex];
            if (currentBreadcrumList.length == 1 && currentBreadcrumList[0].isDeleted)
                currentBreadcrumList = this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex - 1];
            if (!currentBreadcrumList)
                return;
            let breadCrumbItem;
            currentBreadcrumList.forEach(item => {
                if (item.isSelected)
                    breadCrumbItem = item;
                if (item.itemData.Id == this.sessionManager.selectedEntity.Id && this.sessionManager.selectedEntity.ObjectSource != undefined) {
                    if (this.sessionManager.selectedEntity.ObjectSource.indexOf("Tasks") != -1) {
                        item.itemData.LookingBy = this.sessionManager.selectedEntity.LookingBy;
                        item.itemData.LookingOn = this.sessionManager.selectedEntity.LookingOn;
                    }
                    else if (this.sessionManager.selectedEntity.ObjectSource.indexOf("Email") != -1)
                        item.itemData.Header.LookingOn = this.sessionManager.selectedEntity.Header.LookingOn;
                }
                else {
                    if (item.itemData.ObjectSource == this.sessionManager.selectedEntity.ObjectSource) {
                        if (this.sessionManager.selectedEntity.ObjectSource.indexOf("Tasks") != -1) {
                            item.itemData.LookingBy = "";
                            item.itemData.LookingOn = null;
                        }
                        else if (this.sessionManager.selectedEntity.ObjectSource.indexOf("Email") != -1)
                            item.itemData.Header.LookingOn = null;
                    }
                }
            });
            this.sessionManager.SelectedBreadcrumbItem = breadCrumbItem;
            if (currentBreadcrumList[0].sourceUrl.toLowerCase().indexOf(RoutePath.LIST_PATH) == -1) {
                if (breadCrumbItem.itemData.ScheduledWorkType != undefined && breadCrumbItem.itemData.ObjectSourceDto != undefined)
                    this.sessionManager.selectedEntity = breadCrumbItem.itemData.ObjectSourceDto;
                else {
                    let cacheObject = this.sessionManager.getItemsFromDetailViewCacheList(breadCrumbItem.itemData.Id);
                    if (cacheObject != null)
                        this.sessionManager.selectedEntity = cacheObject;
                    else
                        this.sessionManager.selectedEntity = breadCrumbItem.itemData;
                }
                let isSameDetailPath = GlobalFunctions.isSameDetailPath(this.router.url.substring(1), breadCrumbItem.locationUrl);
                this.router.navigate([breadCrumbItem.locationUrl]);
                if (isSameDetailPath)
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
            }
            else {
                if (currentBreadcrumList != null && currentBreadcrumList.length > 0) {
                    this.sessionManager.SelectedBreadcrumbItem = currentBreadcrumList[0];
                    this.localSearchResultDataService.localSearchResultData.localResult = [];
                    this.localSearchResultDataService.localSearchResultData.contentType = currentBreadcrumList[0].sourceUrl.substring(currentBreadcrumList[0].sourceUrl.lastIndexOf("/") + 1);
                    currentBreadcrumList.forEach(el => {
                        this.localSearchResultDataService.localSearchResultData.localResult.push(el.itemData);
                        this.localSearchResultDataService.localSearchResultData.contentType = el.sourceUrl.substring(el.sourceUrl.lastIndexOf("/") + 1);
                    });
                    // Check if sourceUrl includes '/list/activity?:number' , if yes then replace url with 'activity/number' for navigating back to Activities (during phone call)
                    if (currentBreadcrumList[0].sourceUrl.includes(`/${RoutePath.LIST_PATH}/${RoutePath.ACTIVITY_PATH}?:`))
                        this.checkAndNavigateToActivityScreen(currentBreadcrumList);
                    else
                        this.navigate(currentBreadcrumList[0].sourceUrl, true);
                }
            }
            if (this.sessionManager.SelectedBreadcrumbItem != null || this.sessionManager.SelectedBreadcrumbItem !== undefined)
                this.sessionManager.SelectedBreadcrumbItem.title = this.getBreadcrumItemTitle(this.sessionManager.SelectedBreadcrumbItem);
        }
        else
            this.navigate('/', true);
    }
    limitContentOfDropdownWithEllipsis(text) {
        return GlobalFunctions.limitContentOfDropdownWithEllipsis(text, 140);
    }
    setFocusToLocalSearch() {
        document.getElementById("localsearch")?.focus();
    }
    // TODO Tristan: this should not be used in HTML directly
    getBreadcrumItemTitle(breadcrumItem) {
        let title = "";
        if (breadcrumItem != null) {
            if (GlobalFunctions.isEmpty(breadcrumItem.subTitle))
                title = breadcrumItem.title;
            else
                title = breadcrumItem.subTitle;
        }
        return title;
    }
    getBreadcrumClass(breadcrumItem) {
        if (breadcrumItem != null) {
            let entityName = breadcrumItem.sourceUrl.toLowerCase().includes(RoutePath.LIST_PATH) ? RoutePath.LIST_PATH : breadcrumItem.itemData?.RelatedEntityFqdn?.split('_')[breadcrumItem.itemData.RelatedEntityFqdn.split('_').length - 1].toLowerCase();
            if (!GlobalFunctions.isEmpty(entityName)) {
                let entity = entityName.replace(/^\w/, c => c.toUpperCase());
                if (!GlobalFunctions.isEmpty(entity))
                    return "jkc" + entity + " jkcSizeNormal";
            }
        }
    }
    localSearch() {
        this.searchService.isLocalSearch = true;
        if (this.sessionManager.localSearchQuery.length > 2 || this.sessionManager.localSearchQuery.length == 0) {
            this.sessionManager.localSearchQuery = GlobalFunctions.tryParseToDateString(this.sessionManager.localSearchQuery, this.datePipe, this.sessionManager.defaultOptions.defaultDateFormat);
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOCAL_SEARCH_TEXT_CHANGE, this.sessionManager.localSearchQuery);
        }
    }
    ondetailSearchTextChange(event) {
        if (event.target.value.length > 2 || event.target.value.length == 0) {
            this.sessionManager.detailSearchQuery = event.target.value;
            this.detailSearchTextChange.emit(event.target.value);
        }
    }
    clearSearch() {
        this.sessionManager.detailSearchQuery = "";
    }
    resetContextMenu() {
        if (this.sessionManager.selectedEntity.RelatedEntityFqdn == "Decos_Kcs_Products_Entities_Product")
            for (let i = 0; i < this.sessionManager.contextMenu.menuItems.length; i++)
                delete this.sessionManager.contextMenu.menuItems[i].showId;
    }
    resize() {
        this.timeoutIds.push(setTimeout(() => this.hideActionButtons = document.getElementById('breadcrumb-content').clientWidth - +$('#breadcrumb-content').css('padding-right').split('px')[0] < 700, 500));
    }
    checkAndNavigateToActivityScreen(currentBreadcrumbList) {
        const numberFromUrl = currentBreadcrumbList[0]?.sourceUrl?.split(':')[1];
        if (!numberFromUrl)
            return;
        this.router.navigate([`${RoutePath.ACTIVITY_PATH}/${numberFromUrl}`]);
    }
};
__decorate([
    Output()
], BreadcrumbComponent.prototype, "localSearchTextChange", void 0);
__decorate([
    Output()
], BreadcrumbComponent.prototype, "detailSearchTextChange", void 0);
BreadcrumbComponent = __decorate([
    Component({
        selector: 'breadcrumb',
        templateUrl: './breadcrumb.component.html',
        styleUrls: ['./breadcrumb.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], BreadcrumbComponent);
export { BreadcrumbComponent };
//# sourceMappingURL=breadcrumb.component.js.map