var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from "@angular/core";
import { BroadCastEventKeys, RoutePath } from "src/app/shared/constants";
import { GlobalFunctions } from "src/app/shared/global-functions";
import { SubSink } from "subsink";
let BaseRelatedListComponent = class BaseRelatedListComponent {
    constructor(translateService, activatedRoute, sessionManager, eventProvider, dialogManager, applicationSettingManager, router, phoneManager) {
        this.translateService = translateService;
        this.activatedRoute = activatedRoute;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.dialogManager = dialogManager;
        this.applicationSettingManager = applicationSettingManager;
        this.router = router;
        this.phoneManager = phoneManager;
        this.relatedFor = '';
        this.relatedResultList = [];
        this.showProgressBar = false;
        this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_MORE');
        this.isTagFeatureEnabled = this.applicationSettingManager.tagSetting.tagList.length > 0;
        this.relatedItemsToDisplay = 5;
        this.subs = new SubSink();
    }
    ngOnInit() {
        this.subs.sink = this.activatedRoute.params.subscribe(params => this.type = params.domain);
    }
    ngOnChanges(changes) {
        if (changes.relatedResultList != null && changes.relatedResultList.currentValue != changes.relatedResultList.previousValue)
            this.relatedResultList = changes.relatedResultList.currentValue;
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    showMoreOrLessItems() {
        if (this.relatedItemsToDisplay === 5) {
            this.relatedItemsToDisplay = this.relatedResultList.length;
            this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_LESS');
        }
        else {
            this.relatedItemsToDisplay = 5;
            this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_MORE');
        }
    }
    select(contentType, selectedEntity) {
        if (selectedEntity) {
            if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(contentType) && this.relatedFor === 'VIEWER')
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_VIEWER_VIEW, { type: contentType, item: selectedEntity });
            else {
                if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(contentType))
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, selectedEntity);
                else
                    this.openItemInDetailView(selectedEntity, contentType);
            }
        }
    }
    openItemInDetailView(item, contentType) {
        if (GlobalFunctions.isEmpty(item.Id) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto.ServiceNumber))
            item.Id = item.AdministeredPersonDto.ServiceNumber;
        this.sessionManager.loadedFromRelatedView = true;
        this.sessionManager.selectedEntity = item;
        contentType = contentType.toLowerCase();
        if (GlobalFunctions.supportsDeeplinking(contentType, item.ObjectSource))
            item.locationUrl = `/${RoutePath.DETAIL_PATH}/${contentType}/${item.Id}`;
        else
            item.locationUrl = `/${RoutePath.DETAIL_PATH}/${contentType}`;
        this.sessionManager.setBreadcrumbGrammer(item);
        this.sessionManager.addBreadcrumbItems([item], null, this.router.url);
        if (contentType === this.router.url.split('/')[2])
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
        this.router.navigate([item.locationUrl]);
    }
    placeCall(phoneNumber, name, picture, id = null) {
        GlobalFunctions.placeCall(this.phoneManager, phoneNumber, name, picture, id);
    }
    ;
    startSpinner() {
        this.showProgressBar = true;
    }
    stopSpinner() {
        this.showProgressBar = false;
    }
    handleMissingImage(event) {
        GlobalFunctions.handleMissingImage(event);
    }
};
__decorate([
    Input()
], BaseRelatedListComponent.prototype, "relatedFor", void 0);
__decorate([
    Input()
], BaseRelatedListComponent.prototype, "relatedResultList", void 0);
BaseRelatedListComponent = __decorate([
    Component({
        selector: 'base-related-list',
        template: '<span></span>'
    })
], BaseRelatedListComponent);
export { BaseRelatedListComponent };
//# sourceMappingURL=base-related-list.component.js.map