var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { CommonHelper } from "src/app/shared/helper/common-helper";
import { GlobalFunctions } from "../../shared/global-functions";
import { Component } from "@angular/core";
let BaseDialogComponent = class BaseDialogComponent {
    constructor() {
        this.errorMessage = '';
        this.showProgressBar = false;
        this.timeoutIds = [];
        this.dateClass = (cellDate, view) => {
            const day = cellDate.getDate();
            this.timeoutIds.push(setTimeout(() => GlobalFunctions.formatDaysWithLeadingZeros()));
            // handle UI representation of day
            if (!GlobalFunctions.isEmpty(view) && view.toLowerCase() == 'month')
                return (day >= 1 && day <= 9) ? 'custom-cell' : '';
        };
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    startSpinner() {
        this.showProgressBar = true;
    }
    stopSpinner() {
        this.showProgressBar = false;
    }
    openHelpUrl(key) {
        CommonHelper.openHelpUrl(key);
    }
};
BaseDialogComponent = __decorate([
    Component({
        selector: 'base-dialog',
        template: '<span></span>'
    })
], BaseDialogComponent);
export { BaseDialogComponent };
//# sourceMappingURL=base-dialog.component.js.map