var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from "@angular/core";
import { CommonHelper } from "src/app/shared/helper/common-helper";
import { SubSink } from 'subsink';
import { Menu } from "../../core/models/common/menu";
import { GlobalFunctions } from "../../shared/global-functions";
let BaseDetailComponent = class BaseDetailComponent {
    constructor(phoneManager, dialogManager, translateService) {
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.menu = new Menu();
        this.showProgressBar = false;
        this.isTextAreaEmpty = false;
        this.hasRightLocation = false;
        this.isNormalSizeDetailView = true;
        this.addMenuItem = new EventEmitter();
        this.toggleProgressBar = new EventEmitter();
        this.onShowLocationMap = new EventEmitter();
        this.sendRelatedRequest = new EventEmitter();
        this.subs = new SubSink();
    }
    openHelpUrl(key) {
        CommonHelper.openHelpUrl(key);
    }
    startSpinner() {
        this.showProgressBar = true;
        this.toggleProgressBar.emit(true);
    }
    stopSpinner() {
        this.showProgressBar = false;
        this.toggleProgressBar.emit(false);
    }
    openImage(imageUrl) {
        if (!GlobalFunctions.isEmpty(imageUrl))
            window.open(imageUrl, "_blank", "toolbar=0,location=0,menubar=0,status=1,scrollbars=1,resizable=1,width=1000,height=500");
    }
    emitShowLocationMap() {
        this.onShowLocationMap.emit();
    }
    placeCall(phoneNumber, name, picture, id = null) {
        GlobalFunctions.placeCall(this.phoneManager, phoneNumber, name, picture, id);
    }
    loadSendEmailDialog(emailId) {
        GlobalFunctions.loadSendEmailDialog(emailId, this.dialogManager);
    }
    handleMissingImage(event) {
        GlobalFunctions.handleMissingImage(event);
    }
    openEmployeeDetailPopUp(employeeId) {
        this.dialogManager.openEmployeeDetailPopUp(employeeId);
    }
};
__decorate([
    Input()
], BaseDetailComponent.prototype, "relatedFor", void 0);
__decorate([
    Output()
], BaseDetailComponent.prototype, "addMenuItem", void 0);
__decorate([
    Output()
], BaseDetailComponent.prototype, "toggleProgressBar", void 0);
__decorate([
    Output()
], BaseDetailComponent.prototype, "onShowLocationMap", void 0);
__decorate([
    Output()
], BaseDetailComponent.prototype, "sendRelatedRequest", void 0);
BaseDetailComponent = __decorate([
    Component({
        selector: 'base-detail',
        template: '<span></span>'
    })
], BaseDetailComponent);
export { BaseDetailComponent };
//# sourceMappingURL=base-detail.component.js.map