var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from "@angular/core";
import { BroadCastEventKeys, RoutePath } from "../../shared/constants";
import { GlobalFunctions } from "../../shared/global-functions";
let BaseAssociatedListComponent = class BaseAssociatedListComponent {
    constructor(router, eventProvider, sessionManager, translateService, applicationSettingManager) {
        this.router = router;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.associatedResultList = [];
        this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_MORE');
        this.associatedItemsToDisplay = 5;
    }
    showMoreOrLessItems() {
        if (this.associatedItemsToDisplay === 5) {
            this.associatedItemsToDisplay = this.associatedResultList.length;
            this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_LESS');
        }
        else {
            this.associatedItemsToDisplay = 5;
            this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_MORE');
        }
    }
    select(type, item) {
        if (item) {
            if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(type))
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, item);
            else
                this.openItemInDetailView(item, type);
        }
    }
    openItemInDetailView(item, contentType) {
        if (GlobalFunctions.isEmpty(item.Id) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto.ServiceNumber))
            item.Id = item.AdministeredPersonDto.ServiceNumber;
        this.sessionManager.loadedFromRelatedView = true;
        this.sessionManager.selectedEntity = item;
        this.sessionManager.setBreadcrumbGrammer(item);
        this.sessionManager.addBreadcrumbItems([item], null, this.router.url);
        this.router.navigate([RoutePath.DETAIL_PATH, contentType]);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW);
    }
};
__decorate([
    Input()
], BaseAssociatedListComponent.prototype, "associatedResultList", void 0);
BaseAssociatedListComponent = __decorate([
    Component({
        selector: 'base-associated-list',
        template: '<span></span>'
    })
], BaseAssociatedListComponent);
export { BaseAssociatedListComponent };
//# sourceMappingURL=base-associated-list.component.js.map