var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { SubSink } from 'subsink';
import { BroadCastEventKeys } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
let AutocompleteSearchComponent = class AutocompleteSearchComponent {
    constructor(renderer, eventProvider, searchService, productService, sessionManager) {
        this.renderer = renderer;
        this.eventProvider = eventProvider;
        this.searchService = searchService;
        this.productService = productService;
        this.sessionManager = sessionManager;
        this._fixedList = [];
        this.selected = new EventEmitter();
        this.show = false;
        this.matches = [];
        this.activeIdx = -1;
        this.activeSubMenuIndex = 0;
        this.HOT_KEYS = ['Tab', 'Enter', 'Escape', 'ArrowUp', 'ArrowRight', 'ArrowDown'];
        this.subs = new SubSink();
        this.removeEventListeners = [];
        this.removeMenuNavigationListener = () => { };
    }
    set fixedList(fixedList) {
        this._fixedList = fixedList;
        this.getMatchesAsync();
    }
    ;
    ngOnInit() {
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.CLOSE_AUTOCOMPLETE_SEARCH).subscribe(() => this.show = false);
        this.removeEventListeners.push(this.renderer.listen(document, 'click', event => {
            if (event.target.id != 'headerSearchBox')
                this.show = false;
        }));
        this.removeEventListeners.push(this.renderer.listen(document.getElementById('headerSearchBox'), 'click', () => this.show = true));
        this.removeEventListeners.push(this.renderer.listen(document.getElementById('headerSearchBox'), 'contextmenu', () => this.show = true));
        this.removeEventListeners.push(this.renderer.listen(document.getElementById('headerSearchBox'), 'keydown', event => this.menuNavigation(event)));
        this.removeMenuNavigationListener = this.renderer.listen(document.getElementById('typeheadSearchBox'), 'keydown', event => this.menuNavigation(event));
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.removeEventListeners.forEach(removeEventListener => removeEventListener());
        this.removeMenuNavigationListener();
    }
    resetMatches() {
        this.matches = [];
        this.activeIdx = -1;
    }
    ;
    isActive(matchIdx) {
        if (this.activeIdx === matchIdx)
            return this.matches[matchIdx].model.selectable;
        else
            return false;
    }
    isDisabled(matchIdx) {
        if (this.matches[matchIdx].model.searchQuery.indexOf('<div id="currentLocationBtn"') === 0) {
            this.matches[matchIdx].model.selectable = false;
            return true;
        }
        if (!this.matches[matchIdx].model.searchQuery) {
            this.matches[matchIdx].model.selectable = false;
            return true;
        }
        return false;
    }
    customClass(styleClassName) {
        return styleClassName;
    }
    selectActive(matchIdx) {
        this.activeIdx = matchIdx;
    }
    selectMatch(activeIdx, sourceLocationName, event) {
        event.stopPropagation();
        if (!this.allowSelectionSource(activeIdx, sourceLocationName))
            return;
        if (!GlobalFunctions.autoCompleteSearchBoxOperations(this.matches[activeIdx].model.item, event, this.productService, this.sessionManager)) {
            this.matches[activeIdx].model.sourceLocation = sourceLocationName;
            this.select(activeIdx);
        }
    }
    allowSelection(activeIdx) {
        let allow = true;
        const currentMatch = this.matches[activeIdx];
        if (currentMatch && currentMatch.isMultiple && !currentMatch.allowMultipleSourceSearch) {
            this.showSubMenu(true);
            allow = false;
        }
        return allow;
    }
    allowSelectionSource(activeIdx, sourceLocation) {
        let allow = true;
        let currentMatch = this.matches[activeIdx];
        if (!sourceLocation && currentMatch && currentMatch.isMultiple && !currentMatch.allowMultipleSourceSearch)
            allow = false;
        return allow;
    }
    select(activeIdx) {
        if (this.matches[activeIdx].model.selectable) {
            this.show = false;
            this.searchService.isAdvancedSearch = false;
            this.searchService.isLeftMenuSearch = false;
            this.searchService.isAutoCompleteSearch = true;
            this.selected.emit(this.matches[activeIdx].model);
        }
    }
    getMatchesAsync() {
        if (this.searchService.searchOptions?.length > 0 || this._fixedList?.length > 0) {
            this.activeIdx = 0;
            this.matches = [];
            let sortedList = jlinq.from(this.searchService.searchOptions).sort("-orderScore").select();
            let defaultSelectRecord = jlinq.from(sortedList).starts("defaultSelect", "true").first();
            let firstMatchRecord;
            if (defaultSelectRecord != null && defaultSelectRecord.isMatch)
                firstMatchRecord = defaultSelectRecord;
            else
                firstMatchRecord = jlinq.from(sortedList).starts("isMatch", "true").first();
            for (let i = 0; i < sortedList.length; i++) {
                this.matches.push({
                    label: sortedList[i].formattedText,
                    model: sortedList[i],
                    style: sortedList[i].style,
                    isMatch: sortedList[i].isMatch,
                    orderScore: sortedList[i].orderScore,
                    isMultiple: sortedList[i].isMultiple,
                    multipleSources: sortedList[i].multipleSources,
                    allowMultipleSourceSearch: sortedList[i].allowMultipleSourceSearch,
                });
            }
            if (this._fixedList?.length > 0) {
                for (let j = this._fixedList.length - 1; j >= 0; j--) {
                    this.matches.unshift({
                        label: this._fixedList[j].formattedText,
                        model: this._fixedList[j],
                        style: this._fixedList[j].style,
                        isMultiple: this._fixedList[j].isMultiple,
                        multipleSources: this._fixedList[j].multipleSources,
                        allowMultipleSourceSearch: this._fixedList[j].allowMultipleSourceSearch,
                    });
                }
            }
            if (firstMatchRecord != null)
                this.activeIdx = this._fixedList == null || this._fixedList.length == 0 ? sortedList.indexOf(firstMatchRecord) + this._fixedList.length : this._fixedList.indexOf(jlinq.from(this._fixedList).starts("selectable", "true").first());
        }
        else
            this.resetMatches();
    }
    menuNavigation(event) {
        this.show = true;
        event.stopPropagation();
        if (this.matches.length === 0 || !this.HOT_KEYS.includes(event.key))
            return;
        if (event.key === 'ArrowDown' || event.key === 'ArrowUp') {
            this.activeIdx = (this.activeIdx + (event.key === 'ArrowDown' ? 1 : -1)) % this.matches.length;
            if (this.activeIdx < 0)
                this.activeIdx = this.matches.length - 1;
            $('#searchMenuItem' + this.activeIdx).trigger('focus');
        }
        if (event.key === 'ArrowRight') {
            if (this.matches[this.activeIdx].isMultiple === false)
                return;
            this.showSubMenu(true);
            this.activeSubMenuIndex = 0;
            const subMenuElement = '#subMenuItem' + this.activeIdx + this.activeSubMenuIndex;
            $(subMenuElement).trigger('focus');
            $(subMenuElement).addClass("active");
            this.removeMenuNavigationListener();
            this.removeMenuNavigationListener = this.renderer.listen(document.getElementById('searchSubMenuItem' + this.activeIdx), 'keydown', event => this.subMenuNavigation(event));
        }
        if (event.key === 'Enter' || event.key === 'Tab') {
            if (!this.allowSelection(this.activeIdx))
                return;
            this.select(this.activeIdx);
            this.showSubMenu(false);
            this.show = false;
            this.resetMatches();
        }
        if (event.key === 'Escape') {
            document.getElementById('headerSearchBox')?.blur();
            this.resetMatches();
        }
    }
    subMenuNavigation(event) {
        event.stopPropagation();
        let subMenuElement = '#subMenuItem' + this.activeIdx + this.activeSubMenuIndex;
        if (event.key === 'ArrowDown' || event.key === 'ArrowUp') {
            this.activeSubMenuIndex = (this.activeSubMenuIndex + (event.key === 'ArrowDown' ? 1 : -1)) % this.matches[this.activeIdx].multipleSources.length;
            if (this.activeSubMenuIndex < 0)
                this.activeSubMenuIndex = this.matches[this.activeIdx].multipleSources.length - 1;
            $(subMenuElement).removeClass('active');
            subMenuElement = '#subMenuItem' + this.activeIdx + this.activeSubMenuIndex;
            $(subMenuElement).trigger('focus');
            $(subMenuElement).addClass('active');
        }
        if (event.key === 'ArrowLeft') {
            $(subMenuElement).removeClass('active');
            this.showSubMenu(false);
            const menuElement = '#searchMenuItem' + this.activeIdx;
            $(menuElement).trigger('focus');
            $(menuElement).addClass('active');
            this.setMenuNavigation();
        }
        if (event.key === 'Enter' || event.key === 'Tab') {
            this.matches[this.activeIdx].model.sourceLocation = this.matches[this.activeIdx].multipleSources[this.activeSubMenuIndex].SourceLocationName;
            this.select(this.activeIdx);
            this.setMenuNavigation();
        }
        if (event.key === 'Escape') {
            this.show = false;
            this.setMenuNavigation();
        }
    }
    showSubMenu(show) {
        $('#searchSubMenuItem' + this.activeIdx).css('display', show ? 'block' : 'none');
    }
    setMenuNavigation() {
        this.removeMenuNavigationListener();
        this.removeMenuNavigationListener = this.renderer.listen(document.getElementById('typeheadSearchBox'), 'keydown', event => this.menuNavigation(event));
    }
};
__decorate([
    Input()
], AutocompleteSearchComponent.prototype, "fixedList", null);
__decorate([
    Output()
], AutocompleteSearchComponent.prototype, "selected", void 0);
AutocompleteSearchComponent = __decorate([
    Component({
        selector: 'autocomplete-search',
        templateUrl: './autocomplete-search.component.html',
        styleUrls: ['./autocomplete-search.component.scss']
    })
], AutocompleteSearchComponent);
export { AutocompleteSearchComponent };
//# sourceMappingURL=autocomplete-search.component.js.map