var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener, ViewChild } from '@angular/core';
import { parse } from 'date-fns';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { SubSink } from 'subsink';
import { ContactTypeOption, LicenseSpecificFeature, ScreenMode } from '../../../core/enums/common-enums';
import { SearchDto } from '../../../core/models/common/searchDto';
import { ContactHistorySearchField } from '../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../shared/global-functions';
import { CommonHelper } from '../../../shared/helper/common-helper';
import { JkcDatePickerHelper } from '../../../shared/helper/jkc-date-picker-helper';
let X2JS = require('x2js');
let AdvancedSearchComponent = class AdvancedSearchComponent {
    constructor(searchService, sessionManager, translateService, userSettingManager, systemComponentService, applicationSettingManager, eventProvider, renderer, datePipe, dateAdapter) {
        this.searchService = searchService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.applicationSettingManager = applicationSettingManager;
        this.eventProvider = eventProvider;
        this.renderer = renderer;
        this.datePipe = datePipe;
        this.dateAdapter = dateAdapter;
        this.subs = new SubSink();
        this.DateJS = Date;
        this.sourceLocationList = [];
        this.searchDto = new SearchDto;
        this.advancedSearchMatrixlength = 0;
        this.selectedAdvancedSearchValue = "Case";
        this.allSource = this.translateService.instant("LBL_ALL_SOURCES");
        this.selectedSourceLocation = { 'selectedValue': this.allSource };
        this.rights = {
            caseEntity: false,
            contactHistory: false,
            document: false,
            organization: false,
            person: false,
            ticket: false
        };
        this.prevFromDate = "";
        this.prevToDate = "";
        this.dateInputIds = [];
        this.timeoutIds = [];
        this.dateClass = (cellDate, view) => {
            const day = cellDate.getDate();
            this.timeoutIds.push(setTimeout(() => GlobalFunctions.formatDaysWithLeadingZeros()));
            // handle UI representation of day
            if (!GlobalFunctions.isEmpty(view) && view.toLowerCase() == 'month')
                return (day >= 1 && day <= 9) ? 'custom-cell' : '';
        };
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.CLEAR_SESSION).subscribe(() => {
            this.selectedAdvancedSearchValue = "Case";
            this.update();
        });
    }
    ngOnInit() {
        this.setRights();
        if (this.advancedSearchMatrix == null || this.advancedSearchMatrix == undefined)
            this.sessionManager.addAdvancedSearchItems();
        this.advancedSearchMatrix = this.sessionManager.getAdvancedSearchMatrixFor(this.selectedAdvancedSearchValue);
        if (this.advancedSearchMatrix && this.advancedSearchMatrix !== null)
            this.advancedSearchMatrixlength = this.advancedSearchMatrix.length;
        this.getSourceLocations();
        this.updateAdvancedSearchMatrixWithUserSelectedCriteria();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    stopPropagation(event) {
        event.preventDefault();
        event.stopPropagation();
    }
    setRights() {
        this.rights.caseEntity = GlobalFunctions.checkRights('CaseEntity');
        this.rights.contactHistory = GlobalFunctions.checkRights('ContactHistory');
        this.rights.document = GlobalFunctions.checkRights('Document');
        this.rights.organization = GlobalFunctions.checkRights('Organization');
        this.rights.person = GlobalFunctions.checkRights('Person');
        this.rights.ticket = GlobalFunctions.checkRights('Ticket') && this.isLicenseSpecificFeatureEnabled();
    }
    isLicenseSpecificFeatureEnabled() {
        return GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Ticket);
    }
    getSourceLocations() {
        this.sourceLocationList = this.applicationSettingManager.getSourceLocationsByEntity(this.selectedAdvancedSearchValue);
        this.selectedSourceLocation = this.sourceLocationList.length > 1 ? { 'selectedValue': this.allSource } : { 'selectedValue': "" };
    }
    ;
    update(selectedAdvancedSearchValue) {
        if (selectedAdvancedSearchValue)
            this.selectedAdvancedSearchValue = selectedAdvancedSearchValue;
        if (this.advancedSearchMatrix == null || this.advancedSearchMatrix == undefined)
            this.sessionManager.addAdvancedSearchItems();
        this.advancedSearchMatrix = this.sessionManager.getAdvancedSearchMatrixFor(this.selectedAdvancedSearchValue);
        this.advancedSearchMatrixlength = this.advancedSearchMatrix.length;
        this.validationMessage = undefined;
        this.getSourceLocations();
        this.updateAdvancedSearchMatrixWithUserSelectedCriteria();
    }
    ;
    updateAdvancedSearchMatrixWithUserSelectedCriteria() {
        let xmlText = this.userSettingManager.getUserSettingValueByKey("ADVANCEDSEARCHCRITERIASELECTION");
        let x2js = new X2JS();
        this.userCriterialSelection = x2js.xml2js(xmlText);
        let relatedEntityFqdn = this.selectedAdvancedSearchValue;
        if (this.userCriterialSelection != null && this.userCriterialSelection.AdvancedSearchCriteriaSelection != null && this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields != null) {
            this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields = GlobalFunctions.ConvertToArrayIfOnlySingleObject(this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields);
            for (let i = 0; i < this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields.length; i++) {
                let contentType = GlobalFunctions.getObjectTypeName(this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields[i]._ContentType);
                if (contentType.toUpperCase() == relatedEntityFqdn.toUpperCase()) {
                    let criterias = [];
                    let innerValueCriterias = this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields[i].SearchCriteriaField;
                    if (innerValueCriterias instanceof Array)
                        criterias = innerValueCriterias;
                    else
                        criterias.push(innerValueCriterias);
                    if (criterias != null && criterias.length > 0) {
                        for (let k = 0; k < this.advancedSearchMatrix.length; k++) {
                            let oldFieldName = this.advancedSearchMatrix[k].SearchCriteria.Name;
                            let tokens = oldFieldName?.split(".").slice(5);
                            let fieldName = tokens?.join(".");
                            for (let j = 0; j < criterias.length; j++) {
                                if (!GlobalFunctions.isEmpty(criterias[j])) {
                                    let oldCriteriaFieldName = criterias[j]._Name;
                                    let criteriaTokens = oldCriteriaFieldName.split(".").slice(5);
                                    let criteriaFieldName = criteriaTokens.join(".");
                                    if (fieldName.toLowerCase() == criteriaFieldName.toLowerCase()) {
                                        let critIndex = parseInt(criterias[j]._Value);
                                        this.advancedSearchMatrix[k].SearchCriteria.TypeOfCompareType[critIndex].selected = true;
                                        if (this.advancedSearchMatrix[k].SearchCriteria.TypeOfCompareType[critIndex].Text == 'Between')
                                            this.advancedSearchMatrix[k].IsToDateInputBoxEnabled = false;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
            }
        }
    }
    ;
    changeVisibility(value, advancedSearchItem) {
        if (value)
            advancedSearchItem.SearchCriteria.CompareType = value;
        if (advancedSearchItem && advancedSearchItem.SearchCriteria && advancedSearchItem.SearchCriteria.CompareType) {
            switch (advancedSearchItem.SearchCriteria.CompareType) {
                case "5":
                    this.advancedSearchMatrixlength += 1;
                    break;
                default:
                    this.advancedSearchMatrixlength = this.advancedSearchMatrix.length;
                    break;
            }
        }
        advancedSearchItem.IsToDateInputBoxEnabled = false;
        advancedSearchItem.SearchCriteria.TypeOfCompareType[advancedSearchItem.SearchCriteria.CompareType].criteriaChanged = true;
        if (advancedSearchItem.IsCalenderEnabled && advancedSearchItem.SearchCriteria.CompareType == 5)
            advancedSearchItem.IsToDateInputBoxEnabled = true;
    }
    ;
    search() {
        if (this.validate()) {
            document.getElementById('advancedSearchDropdown').style.display = 'none';
            this.prepareSearchDto();
            if (this.searchDto != null) {
                let entity = this.selectedAdvancedSearchValue.toLowerCase();
                let advancedSearchOption = new Object();
                advancedSearchOption.searchDto = this.searchDto;
                advancedSearchOption.searchType = entity;
                advancedSearchOption.sourceLocation = this.selectedSourceLocation.selectedValue == this.allSource ? "" : this.selectedSourceLocation.selectedValue;
                this.searchService.isAdvancedSearch = true;
                this.sessionManager.startSessionIfPossible(entity, ScreenMode.List);
                this.searchService.advanceSearch(advancedSearchOption);
            }
        }
        this.searchService.isAdvancedSearch = true;
        JkcDatePickerHelper.setOverlayBackgroundColor(true, this.renderer);
    }
    ;
    validate() {
        let count = 0;
        this.validationMessage = undefined;
        for (let item in this.advancedSearchMatrix) {
            if (this.advancedSearchMatrix[item].IsRequired)
                break;
            if (this.advancedSearchMatrix[item].TypeOfSearchCriteria == "DateCriteria") {
                if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].FromDate)) {
                    this.advancedSearchMatrix[item].SearchCriteria.Value = this.advancedSearchMatrix[item].FromDate;
                    count++;
                }
                else if (this.datePipe.transform(this.advancedSearchMatrix[item].FromDate, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')
                    this.advancedSearchMatrix[item].SearchCriteria.Value = this.advancedSearchMatrix[item].SearchCriteria.Query = this.advancedSearchMatrix[item].FromDate.toString(this.sessionManager.defaultOptions.mdyyyy);
                else if (GlobalFunctions.validDate(this.manualFromDate))
                    this.advancedSearchMatrix[item].SearchCriteria.Value = this.advancedSearchMatrix[item].SearchCriteria.Query = this.datePipe.transform(this.manualFromDate, this.sessionManager.defaultOptions.mdyyyy);
                else
                    this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
                if (this.advancedSearchMatrix[item].SearchCriteria.CompareType == 5) {
                    if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].ToDate)) {
                        this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate;
                        count++;
                    }
                    else if (this.datePipe.transform(this.advancedSearchMatrix[item].ToDate, this.sessionManager.defaultOptions.mdyyyy) !== '1/1/1970')
                        this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate.toString(this.sessionManager.defaultOptions.mdyyyy);
                    else if (GlobalFunctions.validDate(this.manualToDate))
                        this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.datePipe.transform(this.manualToDate, this.sessionManager.defaultOptions.mdyyyy);
                    else
                        this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
                }
                else
                    this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate = "";
            }
            else if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].SearchCriteria.Value) || this.advancedSearchMatrix[item].SearchCriteria.Value == 0)
                count++;
        }
        if (count >= this.advancedSearchMatrixlength) {
            this.validationMessage = this.translateService.instant("LBL_EMPTY_ADVANCED_SEARCH_ERROR");
        }
        else {
            for (let item in this.advancedSearchMatrix) {
                if (this.advancedSearchMatrix[item].SearchCriteria.Value != undefined && this.advancedSearchMatrix[item].SearchCriteria.Value != "") {
                    if (this.advancedSearchMatrix[item].TypeOfSearchCriteria != "DateCriteria") {
                        if (this.advancedSearchMatrix[item].SearchCriteria.CompareType != 0 && this.advancedSearchMatrix[item].SearchCriteria.Value.length < 3) {
                            this.validationMessage = this.translateService.instant("LBL_QUERY_LENGTH_ADVANCED_SEARCH_ERROR");
                            break;
                        }
                    }
                    if (this.advancedSearchMatrix[item].RegularExpressionValidator != null) {
                        if (!this.isValid(this.advancedSearchMatrix[item].SearchCriteria.Value, this.advancedSearchMatrix[item].RegularExpressionValidator)) {
                            this.validationMessage = this.advancedSearchMatrix[item].ValidationMessage;
                            break;
                        }
                    }
                    else if (this.advancedSearchMatrix[item].TypeOfSearchCriteria == "DateCriteria") {
                        let parsedDateFormat = this.advancedSearchMatrix[item].SearchCriteria.Value;
                        if (!parsedDateFormat || parsedDateFormat == '[object Object]' || parsedDateFormat == 'Invalid Date') {
                            this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
                            break;
                        }
                        else
                            this.advancedSearchMatrix[item].SearchCriteria.Value = parsedDateFormat;
                        if (!GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].SearchCriteria.ToDate)) {
                            let parsedToDateFormat = this.advancedSearchMatrix[item].SearchCriteria.ToDate;
                            if (!parsedToDateFormat || parsedToDateFormat == '[object Object]' || parsedToDateFormat == 'Invalid Date') {
                                this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
                                break;
                            }
                            else {
                                this.advancedSearchMatrix[item].SearchCriteria.ToDate = parsedToDateFormat;
                                if (new this.DateJS(this.advancedSearchMatrix[item].SearchCriteria.ToDate) < new this.DateJS(this.advancedSearchMatrix[item].SearchCriteria.Value)) {
                                    this.validationMessage = this.translateService.instant("LBL_INVALID_DATE_BETWEEN_ERROR");
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.validationMessage == undefined ? true : false;
    }
    ;
    isValid(searchQuery, validFormat) {
        return searchQuery.match(validFormat) != null;
    }
    ;
    prepareSearchDto() {
        this.searchDto.StringCriteriaList = new Array();
        this.searchDto.NumericCriteriaList = new Array();
        this.searchDto.DateCriteriaList = new Array();
        this.searchDto.EnumCriteriaList = new Array();
        this.searchService.advancedSearchQuery = '';
        let searchContentType = new Object();
        searchContentType._ContentType = this.selectedAdvancedSearchValue;
        //searchContentType.SourceLocation = this.selectedAdvancedSourceLocationValue;
        searchContentType.SearchCriteriaField = [];
        for (let item in this.advancedSearchMatrix) {
            if (this.advancedSearchMatrix[item].SearchCriteria.Value != null && this.advancedSearchMatrix[item].SearchCriteria.Value != "") {
                if (this.advancedSearchMatrix[item].SearchCriteria.TypeOfCompareType[this.advancedSearchMatrix[item].SearchCriteria.CompareType].criteriaChanged) {
                    let searchField = new Object();
                    searchField._Name = this.advancedSearchMatrix[item].SearchCriteria.Name;
                    searchField._Value = this.advancedSearchMatrix[item].SearchCriteria.CompareType;
                    searchContentType.SearchCriteriaField.push(searchField);
                }
                if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                    this.searchService.advancedSearchQuery += ' , ';
                this.setAdvancedSearchQuery(this.advancedSearchMatrix[item].SearchCriteria, this.advancedSearchMatrix[item].TypeOfSearchCriteria);
                switch (this.advancedSearchMatrix[item].TypeOfSearchCriteria) {
                    case 'StringCriteria':
                        this.searchDto.StringCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'NumericCriteria':
                        this.searchDto.NumericCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'DateCriteria':
                        this.searchDto.DateCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'EnumCriteria':
                        this.searchDto.EnumCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                }
            }
        }
        let relatedEntityFqdn = this.selectedAdvancedSearchValue;
        let searchCriteriaFields = [];
        if (this.userCriterialSelection == null) {
            this.userCriterialSelection = new Object();
            this.userCriterialSelection.AdvancedSearchCriteriaSelection = new Object();
            this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields = new Array();
        }
        let value = this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields;
        if (value instanceof Array)
            searchCriteriaFields = value;
        else
            searchCriteriaFields.push(value);
        this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields = new Array();
        this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields = searchCriteriaFields;
        let contentTypeFound = false;
        for (let i = 0; i < searchCriteriaFields.length; i++) {
            let contentType = GlobalFunctions.getObjectTypeName(searchCriteriaFields[i]._ContentType);
            if (contentType.toUpperCase() == relatedEntityFqdn.toUpperCase()) {
                this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields[i] = searchContentType;
                contentTypeFound = true;
                break;
            }
        }
        if (!contentTypeFound)
            this.userCriterialSelection.AdvancedSearchCriteriaSelection.SearchCriteriaFields.push(searchContentType);
        let x2js = new X2JS();
        let xmlValue = x2js.js2xml(this.userCriterialSelection);
        this.userSettingManager.setUserSettingValueByKey("ADVANCEDSEARCHCRITERIASELECTION", xmlValue);
        let userSettingDto = new Object();
        userSettingDto.Key = "ADVANCEDSEARCHCRITERIASELECTION";
        userSettingDto.Value = xmlValue;
        userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
        this.systemComponentService.updateUserSetting(userSettingDto);
    }
    ;
    setAdvancedSearchQuery(searchDto, TypeOfSearchCriteria) {
        try {
            let criteria;
            searchDto.TypeOfCompareType.forEach((value, key) => {
                if (key != null && key == searchDto.CompareType)
                    criteria = value.Text;
            });
            let searchQuery;
            let searchDtoToDate;
            if (TypeOfSearchCriteria == "DateCriteria") {
                searchQuery = this.datePipe.transform(searchDto.Value, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                searchQuery = GlobalFunctions.removeDotAfterMonth(searchQuery);
                if (searchDto.CompareType == "5") {
                    searchDtoToDate = this.datePipe.transform(searchDto.ToDate, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                    searchDtoToDate = GlobalFunctions.removeDotAfterMonth(searchDtoToDate);
                    searchQuery += " - " + searchDtoToDate;
                }
            }
            if (searchDto.Name == ContactHistorySearchField.ContactType)
                searchQuery = searchQuery ? searchQuery : ContactTypeOption[searchDto.Value];
            else
                searchQuery = searchQuery ? "'" + searchQuery + "'" : "'" + searchDto.Value + "'";
            this.searchService.advancedSearchQuery += '{' + this.translateService.instant(searchDto.DisplayName) + '} ' + this.translateService.instant("LBL_" + criteria.toUpperCase()) + " " + searchQuery + " ";
        }
        catch (e) { }
    }
    ;
    initDatePickerState() {
        JkcDatePickerHelper.setMargin('337px', '-45px', 'fixed', this.renderer);
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
    }
    clicked(event) {
        let jkcCaretDown = event.target.className;
        this.dropdownState = document.getElementById('advancedSearchDropdown');
        if (jkcCaretDown == 'jkcCaretDown jkcSizeSmall')
            this.dropdownState.style.display = (this.dropdownState.style.display === "none" || this.dropdownState.style.display === "") ? "block" : "none";
        this.stopPropagation(event);
        this.handleDateInputClick(this.dateInputIds, event);
        JkcDatePickerHelper.isDatePickerClosed = false;
    }
    clickedOut(event) {
        try {
            if (JkcDatePickerHelper.isDatePickerClosed) {
                this.timeoutIds.push(setTimeout(() => {
                    JkcDatePickerHelper.setOverlayBackgroundColor(true, this.renderer);
                }, 500));
            }
            else {
                if (event.target.className.includes("cdk-overlay-backdrop")) {
                    this.timeoutIds.push(setTimeout(() => {
                        JkcDatePickerHelper.setOverlayBackgroundColor(true, this.renderer);
                    }, 500));
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    handleDateInputClick(inputId, event) {
        inputId.forEach(index => {
            const from_Date = document.getElementById(`fromDate${index}`);
            const to_Date = document.getElementById(`toDate${index}`);
            if (!this.dateInputIds.includes(index))
                this.dateInputIds.push(index);
            this.timeoutIds.push(setTimeout(() => {
                if (!GlobalFunctions.isEmpty(from_Date) && from_Date.value !== this.prevFromDate) {
                    if (CommonHelper.getLanguageCode() === "nl-NL" && from_Date) {
                        from_Date.value = from_Date.value.split('-').reverse().join('-');
                        if (this.manualFromDate)
                            from_Date.value = this.datePipe.transform(this.manualFromDate, this.sessionManager.defaultOptions.defaultDateFormat);
                    }
                    const dateValue = from_Date.value !== '1/1/1970' ? from_Date.value : this.manualFromDate;
                    GlobalFunctions.setDateFormat(from_Date?.id, dateValue, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
                    this.prevFromDate = from_Date.value;
                }
                if (!GlobalFunctions.isEmpty(to_Date) && to_Date.value !== this.prevToDate) {
                    if (CommonHelper.getLanguageCode() === "nl-NL" && to_Date) {
                        to_Date.value = to_Date.value.split('-').reverse().join('-');
                        if (this.manualToDate)
                            to_Date.value = this.datePipe.transform(this.manualToDate, this.sessionManager.defaultOptions.defaultDateFormat);
                    }
                    const dateValue = to_Date.value !== '1/1/1970' ? to_Date.value : this.manualToDate;
                    GlobalFunctions.setDateFormat(to_Date.id, dateValue, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
                    this.prevToDate = to_Date.value;
                }
            }, 10));
        });
        if (event) {
            this.timeoutIds.push(setTimeout(() => {
                const inputElement = event.target;
                if (inputElement instanceof HTMLInputElement)
                    inputElement.focus();
            }, 100));
            JkcDatePickerHelper.isDatePickerClosed = true;
        }
    }
    handleManualDateInput(target, isFromDate) {
        if (!GlobalFunctions.isEmpty(target)) {
            let dateFormat;
            if (target.value.length === 8)
                dateFormat = this.sessionManager.defaultOptions.ddMMyyyy;
            else if (target.value.length === 6)
                dateFormat = this.sessionManager.defaultOptions.ddMMyy;
            else if (target.value.length === 10)
                dateFormat = this.sessionManager.defaultOptions.dateMonthYear;
            else if (target.value.length === 11)
                dateFormat = this.sessionManager.defaultOptions.defaultDateFormat;
            if (!GlobalFunctions.isEmpty(dateFormat))
                isFromDate ? this.manualFromDate = parse(target.value, dateFormat, new Date()) : this.manualToDate = parse(target.value, dateFormat, new Date());
        }
    }
    togglePanel() {
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.CLOSE_AUTOCOMPLETE_SEARCH);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.CLOSE_ALL_POPUPS);
    }
};
__decorate([
    ViewChild('fromDatePickerInput')
], AdvancedSearchComponent.prototype, "fromDateInput", void 0);
__decorate([
    ViewChild('toDatePickerInput')
], AdvancedSearchComponent.prototype, "toDateInput", void 0);
__decorate([
    ViewChild('advancedSearchDropdown')
], AdvancedSearchComponent.prototype, "advancedSearchDropdown", void 0);
__decorate([
    ViewChild('advancedSearchSelectOption')
], AdvancedSearchComponent.prototype, "advancedSearchSelectOption", void 0);
__decorate([
    HostListener("click", ['$event'])
], AdvancedSearchComponent.prototype, "clicked", null);
__decorate([
    HostListener("document:click", ['$event'])
], AdvancedSearchComponent.prototype, "clickedOut", null);
AdvancedSearchComponent = __decorate([
    Component({
        selector: 'advanced-search',
        templateUrl: './advanced-search.component.html',
        styleUrls: ['./advanced-search.component.scss']
    })
], AdvancedSearchComponent);
export { AdvancedSearchComponent };
//# sourceMappingURL=advanced-search.component.js.map