var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { SubSink } from 'subsink';
import { ActivityItems } from '../../../core/models/common/activity-items';
import { BroadCastEventKeys, RoutePath } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
import { BaseDialogComponent } from '../base-dialog.component';
let ActivityComponent = class ActivityComponent extends BaseDialogComponent {
    constructor(router, taskService, phoneManager, eventProvider, sessionManager, activatedRoute, translateService, contactHistoryService, applicationSettingManager) {
        super();
        this.router = router;
        this.taskService = taskService;
        this.phoneManager = phoneManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.activatedRoute = activatedRoute;
        this.translateService = translateService;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.activityItems = [];
        this.groupedActivityKeys = [];
        this.groupedActivityItems = [];
        this.activityItemsToDisplay = 5;
        this.userId = GlobalFunctions.getLoggedInUserId();
        this.uniqueId = GlobalFunctions.createGuid();
        this.phoneNumber = '';
        this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_MORE');
        this.showNoActivityFoundMessage = false;
        this.relatedStatusList = [];
        this.relatedResultList = [];
        this.updatedActivityItems = [];
        this.onShowMoreOrLessItems = new EventEmitter();
        this.isTagFeatureEnabled = this.applicationSettingManager.tagSetting.tagList.length > 0;
        this.subs = new SubSink();
        this.relatedResultFound = this.relatedResultFound.bind(this);
        this.searchStartedNotification = this.searchStartedNotification.bind(this);
        this.searchCompletedNotification = this.searchCompletedNotification.bind(this);
    }
    ngOnInit() {
        this.subs.sink = this.activatedRoute.params.subscribe(params => {
            this.phoneNumber = params.number;
            if (!GlobalFunctions.isEmpty(this.phoneNumber)) {
                let windowHeight = $(window).height();
                let newHeight = windowHeight - 150 + "px";
                $("#RELATED_ACTIVITY").height(newHeight);
                this.startSpinner();
                this.taskService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
                this.taskService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
                this.contactHistoryService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
                this.contactHistoryService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
                this.taskService.getRecentActivities(this.phoneNumber);
                this.contactHistoryService.getRecentActivities(this.phoneNumber);
            }
        });
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.subs.unsubscribe();
    }
    select(type, item) {
        if (item != null) {
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = item;
            type = type.toLowerCase();
            if (GlobalFunctions.supportsDeeplinking(type, item.ObjectSource))
                item.locationUrl = `${RoutePath.DETAIL_PATH}/${type}/${item.Id}`;
            else
                item.locationUrl = `${RoutePath.DETAIL_PATH}/${type}`;
            this.sessionManager.addBreadcrumbItems(this.updatedActivityItems, item, `/${RoutePath.LIST_PATH}/${RoutePath.ACTIVITY_PATH}?:${this.phoneNumber}`, this.translateService.instant("LBL_ACTIVITIES"));
            const isDetailView = this.router.url.includes(RoutePath.DETAIL_PATH);
            this.router.navigate([item.locationUrl]);
            if (isDetailView)
                this.timeoutIds.push(setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_DETAIL_VIEW), 300));
        }
    }
    relatedResultFound(result, contentType) {
        this.stopSpinner();
        if (result?.length > 0) {
            this.sessionManager.isActivityFound = true;
            contentType = contentType.toUpperCase();
            if (this.relatedResultList[contentType] == null)
                this.relatedResultList[contentType] = [];
            this.relatedResultList[contentType] = this.relatedResultList[contentType].concat(result);
            if (contentType.includes("TASK") || contentType.includes("CONTACTMOMENT"))
                this.updateActivityItems(contentType, result);
            if (contentType == "CONTACTMOMENT")
                this.resolveCallNumberFromRecentActivity("CONTACTMOMENT");
        }
    }
    ;
    searchStartedNotification(message) {
        let entityFqdn = GlobalFunctions.getObjectTypeName(message.ContentType);
        entityFqdn = entityFqdn.toUpperCase();
        if (this.relatedStatusList[entityFqdn] == null)
            this.relatedStatusList[entityFqdn] = 0;
        this.relatedStatusList[entityFqdn] += 1;
    }
    ;
    searchCompletedNotification(message) {
        let entityFqdn = GlobalFunctions.getObjectTypeName(message.ContentType);
        entityFqdn = entityFqdn.toUpperCase();
        this.relatedStatusList[entityFqdn] -= 1;
        if (this.relatedStatusList[entityFqdn] === 0)
            this.showNoActivityFoundMessage = (this.relatedStatusList["TASK"] !== null && this.relatedStatusList["TASK"] === 0 && this.relatedStatusList["CONTACTMOMENT"] !== null && this.relatedStatusList["CONTACTMOMENT"] === 0 && this.activityItems.length === 0);
    }
    ;
    updateActivityItems(contentType, result) {
        let activityItems = new ActivityItems();
        activityItems.addOrUpdateActivityItem(result, contentType, this.translateService);
        let dateJS = Date;
        for (let i = 0; i < activityItems.activityItemList.length; i++) {
            if (activityItems.activityItemList[i].date > new dateJS.today().addMonths(-6) || activityItems.activityItemList[i].date < 0) {
                if (activityItems.activityItemList[i].contentType == 'TASK')
                    activityItems.activityItemList[i].contentType = activityItems.activityItemList[i].entityObject.TaskType;
                const { contentType, entityObject } = activityItems.activityItemList[i];
                if (!GlobalFunctions.isEmpty(entityObject)) {
                    entityObject.locationUrl = contentType === 'CONTACTMOMENT' || contentType === 'CONTACTHISTORY' ? `${RoutePath.DETAIL_PATH}/contacthistory` : contentType === 'TASK' ? `${RoutePath.DETAIL_PATH}/${contentType}/${entityObject.Id}` : null;
                    this.updatedActivityItems.push(entityObject);
                }
                this.activityItems.push(activityItems.activityItemList[i]);
            }
        }
        GlobalFunctions.remove_duplicates(this.activityItems);
        this.activityItems.sort((a, b) => (a.fullDate < b.fullDate) ? 1 : -1);
        this.showActivityItems(this.activityItems.slice(0, 5));
    }
    showActivityItems(activityItemList) {
        this.activityItemsToDisplay = activityItemList.length;
        this.groupedActivityItems = jlinq.from(activityItemList).group("date");
        this.groupedActivityKeys = Object.keys(this.groupedActivityItems);
    }
    resolveCallNumberFromRecentActivity(contentType) {
        if (!GlobalFunctions.isEmpty(this.phoneNumber) && this.relatedResultList[contentType] != null && !this.phoneManager.phoneState.IsCallerIdResolved) {
            const contactPerson = this.relatedResultList[contentType][0];
            if (!GlobalFunctions.isEmpty(contactPerson) && !GlobalFunctions.isEmpty(contactPerson.ContactPerson)) {
                this.phoneManager.phoneState.CurrentCaller.Name = contactPerson.ContactPerson;
                if (this.applicationSettingManager.isCustomerOM())
                    this.phoneManager.phoneState.CurrentCallerRecentActivity = contactPerson;
            }
            else
                this.phoneManager.phoneState.CurrentCaller.Name = this.translateService.instant("LBL_NO_PERSON_FOUND");
            this.phoneManager.phoneState.IsCallerIdResolved = true;
        }
    }
    showMoreOrLessItems() {
        if (this.activityItemsToDisplay === 5) {
            this.onShowMoreOrLessItems.emit(this.activityItems);
            this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_LESS');
        }
        else {
            this.onShowMoreOrLessItems.emit(this.activityItems.slice(0, 5));
            this.showMoreOrLessText = this.translateService.instant('LBL_SHOW_MORE');
        }
    }
};
__decorate([
    Input()
], ActivityComponent.prototype, "activityItems", void 0);
__decorate([
    Input()
], ActivityComponent.prototype, "groupedActivityKeys", void 0);
__decorate([
    Input()
], ActivityComponent.prototype, "groupedActivityItems", void 0);
__decorate([
    Input()
], ActivityComponent.prototype, "activityItemsToDisplay", void 0);
__decorate([
    Output()
], ActivityComponent.prototype, "onShowMoreOrLessItems", void 0);
ActivityComponent = __decorate([
    Component({
        selector: 'activity',
        templateUrl: './activity.component.html',
        styleUrls: ['./activity.component.scss']
    })
], ActivityComponent);
export { ActivityComponent };
//# sourceMappingURL=activity.component.js.map