import { LanaguageCode, Locale } from '../shared/constants';
import { GlobalFunctions } from '../shared/global-functions';
import { CommonHelper } from '../shared/helper/common-helper';
export class BaseComponent {
    constructor(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef) {
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
    }
    openHelpUrl(key) {
        CommonHelper.openHelpUrl(key);
    }
    navigate(route, replaceUrl = false) {
        this.zone.run(() => GlobalFunctions.navigateWithOptionalQueryParam(this.router, route, replaceUrl));
    }
    getLanguageCode() {
        let locale = Locale.NL_NL;
        if (navigator.language === LanaguageCode.EN_CODE)
            locale = Locale.EN_EN;
        return locale;
    }
}
//# sourceMappingURL=base-component.js.map