var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { NavigationStart } from '@angular/router';
import { filter } from 'rxjs/internal/operators/filter';
import { SubSink } from 'subsink';
import { environment } from '../environments/environment';
import { BaseComponent } from './components/base-component';
import { OperationType } from './core/enums/common-enums';
import { ContentType } from './core/models/jkc-object/jkc-object';
import { BroadCastEventKeys } from './shared/constants';
import { GlobalFunctions } from './shared/global-functions';
let AppComponent = class AppComponent extends BaseComponent {
    constructor(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef, appManager, eventProvider, sessionManager) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.appManager = appManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.subs = new SubSink();
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.LOGOUT).subscribe(() => this.appManager.logout());
    }
    ngOnInit() {
        this.router.events
            .pipe(filter(event => event instanceof NavigationStart))
            .subscribe((event) => {
            let url = event.url.toLowerCase();
            if ((url.includes('list/noteentity') || url.includes('search/note')) && !GlobalFunctions.hasRight(ContentType.Note, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('list/theme') && !GlobalFunctions.hasRight(ContentType.Theme, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('search/contacthistory') && !GlobalFunctions.hasRight(ContentType.ContactMoment, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('search/task') && !GlobalFunctions.hasRight(ContentType.Task, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('search/ticket') && !GlobalFunctions.hasRight(ContentType.Ticket, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('search/socialmedia') && !GlobalFunctions.hasRight(ContentType.SocialMedia, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('search/email') && !GlobalFunctions.hasRight(ContentType.Email, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('list/news') && !GlobalFunctions.hasRight(ContentType.News, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
            else if (url.includes('list/document') && !GlobalFunctions.hasRight(ContentType.Document, OperationType.View))
                this.router.navigateByUrl('/dashboard', { replaceUrl: true });
        });
        this.translateService.use(navigator.language.split('-')[0]);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    beforeUnload(event) {
        if (environment.production && !this.sessionManager.isLoggedOut)
            event.preventDefault(); // Gives user a confirmation popup before closing JKC
    }
};
AppComponent = __decorate([
    Component({
        selector: 'app',
        templateUrl: './app.component.html',
        host: { '(window:beforeunload)': 'beforeUnload($event)' }
    })
], AppComponent);
export { AppComponent };
//# sourceMappingURL=app.component.js.map