/**
 * This is a configuration javascript file to create a layers list for pdok api
 *
 * At this moment it can contain 3 layertypes: WMTS (preferred), WMS and TMS
 *
 * A layer Object is an Object with properties with OpenLayers-Layer property names
 * Only 'layertype' and 'name' are unique for the api
 *
 * NOTE: because we use OpenLayers properties, the property names are type aware:
 * eg: for a WMTS the layernames is defined in a 'layer' property
 * while for a WMS it is called 'layers' (mind the s on the end)
 */

var Pdok = Pdok || {};
window.Pdok = Pdok;

Pdok.Api.prototype.defaultLayers = {

  //AAN: {
  //  layertype: 'WMTS',
  //  name: 'AAN - Agrarisch Areaal Nederland (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'aan',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN1_100M: {
  //  layertype: 'WMTS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 100 meter (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/ahn1?',
  //  layer: 'ahn1_100m',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN1_100M_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 100 meter (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn1/wms',
  //  layers: 'ahn1_100m',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},  
  //AHN1_25M: {
  //  layertype: 'WMTS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 25 meter (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/ahn1?',
  //  layer: 'ahn1_25m',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN1_25M_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 25 meter (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn1/wms',
  //  layers: 'ahn1_25m',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},  
  //AHN1_5M: {
  //  layertype: 'WMTS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 5 meter (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/ahn1?',
  //  layer: 'ahn1_5m',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN1_5M_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 5 meter (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn1/wms',
  //  layers: 'ahn1_5m',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //AHN1_BlADINDEX: {
  //  layertype: 'WMS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 25 meter - Bladindex (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn1/wms',
  //  layers: 'ahn1_bladindex',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //AHN1_PUNTDICHTHEIDGEBIEDEN: {
  //  layertype: 'WMS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 25 meter - Pundichtheidgebieden (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn1/wms',
  //  layers: 'puntdichtheidgebieden',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //AHN1_STADSPOLYGONEN: {
  //  layertype: 'WMS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 25 meter - Stadspolygonen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn1/wms',
  //  layers: 'stadspolygonen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //AHN1_VLIEGLIJNEN: {
  //  layertype: 'WMS',
  //  name: 'AHN1 - Actueel Hoogtebestand NL 25 meter - Vlieglijnen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn1/wms',
  //  layers: 'vlieglijnen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},  
  //AHN2_5M: {
  //  layertype: 'WMTS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 5 meter (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/ahn2?',
  //  layer: 'ahn2_5m',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN2_5M_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 5 meter (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn2/wms',
  //  layers: 'ahn2_5m',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //AHN2_5M_BLADINDEX_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 5 meter Bladindex (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn2/wms',
  //  layers: 'ahn2_bladindex',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},  
  //AHN2_05M_INT: {
  //  layertype: 'WMTS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 0.5 meter geinterpoleerd (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/ahn2?',
  //  layer: 'ahn2_05m_int',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN2_05M_INT_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 0.5 meter geinterpoleerd (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn2/wms',
  //  layers: 'ahn2_05m_int',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //AHN2_05M_NON: {
  //  layertype: 'WMTS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 0.5 meter niet geinterpoleerd (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/ahn2?',
  //  layer: 'ahn2_05m_non',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN2_05M_NON_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 0.5 meter niet geinterpoleerd (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn2/wms',
  //  layers: 'ahn2_05m_non',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //AHN2_05M_RUW: {
  //  layertype: 'WMTS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 0.5 meter ruw (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/ahn2?',
  //  layer: 'ahn2_05m_ruw',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //AHN2_05M_RUW_WMS: {
  //  layertype: 'WMS',
  //  name: 'AHN2 - Actueel Hoogtebestand NL 0.5 meter ruw (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ahn2/wms',
  //  layers: 'ahn2_05m_ruw',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BAG_LIGPLAATS: {
  //  layertype: 'WMS',
  //  name: 'BAG - Ligplaats (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bag/wms',
  //  layers: 'ligplaats',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BAG_PAND: {
  //  layertype: 'WMS',
  //  name: 'BAG - Pand (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bag/wms',
  //  layers: 'pand',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BAG_STANDPLAATS: {
  //  layertype: 'WMS',
  //  name: 'BAG - Standplaats (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bag/wms',
  //  layers: 'standplaats',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BAG_VERBLIJFSOBJECT: {
  //  layertype: 'WMS',
  //  name: 'BAG - Verblijfsobject (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bag/wms',
  //  layers: 'verblijfsobject',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BAG_WOONPLAATS: {
  //  layertype: 'WMS',
  //  name: 'BAG - Woonplaats (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bag/wms',
  //  layers: 'woonplaats',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BBG2008: {
  //  layertype: 'WMS',
  //  name: 'BBG - Bestand Bodemgebruik 2008 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bestandbodemgebruik2008/wms',
  //  layers: 'bbg2008',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BBG2008_hoofdgroep: {
  //  layertype: 'WMS',
  //  name: 'BBG - Bestand Bodemgebruik 2008 Hoofdgroep (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bestandbodemgebruik2008/wms',
  //  layers: 'bbg2008_hoofdgroep',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BESCHERMDENATUURMONUMENTEN: {
  //  layertype: 'WMS',
  //  name: 'Beschermde Natuurmonumenten (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/beschermdenatuurmonumenten/wms',
  //  layers: 'beschermdenatuurmonumenten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BG_PROVINCIEGRENZEN: {
  //  layertype: 'WMS',
  //  name: 'Bestuurlijke grenzen - Provinciegrenzen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bestuurlijkegrenzen/wms',
  //  layers: 'provincies',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BG_GEMEENTEGRENZEN: {
  //  layertype: 'WMS',
  //  name: 'Bestuurlijke grenzen - Gemeentegrenzen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bestuurlijkegrenzen/wms',
  //  layers: 'gemeenten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BG_GEMEENTEGRENZEN_LABEL: {
  //  layertype: 'WMS',
  //  name: 'Bestuurlijke grenzen - Gemeentegrenzen met labels (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bestuurlijkegrenzen/wms?sld=' + Pdok.ApiUrl + '/sld/gemeentegrenzen_label_grijs_gestippeld.sld',
  //  layers: 'gemeenten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BG_LANDSGRENS: {
  //  layertype: 'WMS',
  //  name: 'Bestuurlijke grenzen - Landsgrens (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bestuurlijkegrenzen/wms',
  //  layers: 'landsgrens',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BGT_ACHTERGROND_WMTS: {
  //  layertype: 'WMTS',
  //  name: 'Basisregistratie Grootschalige Topografie Achtergrond (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'bgtachtergrond',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},  
  //BGT_ACHTERGROND_TMS: {
  //  layertype: 'TMS',
  //  name: 'Basisregistratie Grootschalige Topografie Achtergrond (TMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tms/',
  //  layername: 'bgtachtergrond',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //}, 
  //BGT_LIJNGERICHT_WMTS: {
  //  layertype: 'WMTS',
  //  name: 'Basisregistratie Grootschalige Topografie Lijngericht (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'bgtlijngericht',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},  
  //BGT_LIJNGERICHT_TMS: {
  //  layertype: 'TMS',
  //  name: 'Basisregistratie Grootschalige Topografie Lijngericht (TMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tms/',
  //  layername: 'bgtlijngericht',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},    
  //BGT_OMTREKGERICHT_WMTS: {
  //  layertype: 'WMTS',
  //  name: 'Basisregistratie Grootschalige Topografie Omtrekgericht (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'bgtomtrekgericht',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},  
  //BGT_OMTREKGERICHT_TMS: {
  //  layertype: 'TMS',
  //  name: 'Basisregistratie Grootschalige Topografie Omtrekgericht (TMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tms/',
  //  layername: 'bgtomtrekgericht',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},   
  //BGT_STANDAARD_WMTS: {
  //  layertype: 'WMTS',
  //  name: 'Basisregistratie Grootschalige Topografie Standaard (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'bgtstandaard',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},  
  //BGT_STANDAARD_TMS: {
  //  layertype: 'TMS',
  //  name: 'Basisregistratie Grootschalige Topografie Standaard (TMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tms/',
  //  layername: 'bgtstandaard',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},   
  //BRP_LIGHT: {
  //  layertype: 'WMS',
  //  name: 'BRP-light - Gewaspercelen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/brpgewaspercelen/wms?',
  //  layers: 'brpgewaspercelen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //BRT: {
  //  layertype: 'WMTS',
  //  name: 'BRT Achtergrondkaart (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'brtachtergrondkaart',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: true,
  //  attribution: '(c) OSM & Kadaster'
  //},
  //BRTTIJDELIJK: {
  //  layertype: 'WMTS',
  //  name: 'BRT Achtergrondkaart tijdelijk (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'brtachtergrondkaarttijdelijk',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: true,
  //  attribution: '(c) OSM & Kadaster'
  //},
  //BRTGRIJSTIJDELIJK: {
  //  layertype: 'WMTS',
  //  name: 'BRT Achtergrondkaart Grijs tijdelijk (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wmts/',
  //  layer: 'brtachtergrondkaartgrijstijdelijk',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: true,
  //  attribution: '(c) OSM & Kadaster'
  //},
  //CBS_KERNEN_NAMEN: {
  //  layertype: 'WMS',
  //  name: 'CBS Bevolkingskern namen 2008 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bevolkingskernen2008/wms',
  //  layers: 'naamgeving_kernen_40k_plus,naamgeving_kernen_alles',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_KERNEN: {
  //  layertype: 'WMS',
  //  name: 'CBS Bevolkingskernen 2008 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bevolkingskernen2008/wms',
  //  layers: 'cbsbevolkingskernen2008',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_GEMEENTEN: {
  //  layertype: 'WMS',
  //  name: 'CBS Gemeentegrenzen 2008 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bevolkingskernen2008/wms',
  //  layers: 'gemeentegrens_generalisatie_2008',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_PROVINCIES_2008: {
  //  layertype: 'WMS',
  //  name: 'CBS Provinciegrenzen 2008 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/bevolkingskernen2008/wms',
  //  layers: 'provgrens_generalisatie_2008',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_PROVINCIES_2012: {
  //  layertype: 'WMS',
  //  name: 'CBS Provinciegrenzen 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cbsprovincies/wms',
  //  layers: 'cbsprovincies2012',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_4KANTEN100M_INWONERS2012: {
  //  layertype: 'WMS',
  //  name: 'CBS Vierkanten 100m - Inwoners 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cbsvierkanten100m/wms',
  //  layers: 'inwoners_2012',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_4KANTEN100M_INWONERS2011: {
  //  layertype: 'WMS',
  //  name: 'CBS Vierkanten 100m - Inwoners 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cbsvierkanten100m/wms',
  //  layers: 'inwoners_2011',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_4KANTEN100M_WONINGEN2011: {
  //  layertype: 'WMS',
  //  name: 'CBS Vierkanten 100m - Woningen 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cbsvierkanten100m/wms',
  //  layers: 'woningen_2011',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_4KANTEN100M_TOENAMEINWONERS2000TOT2010: {
  //  layertype: 'WMS',
  //  name: 'CBS Vierkanten 100m - Toename inwoners 2000 - 2010 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cbsvierkanten100m/wms',
  //  layers: 'toename_inwoners_2000_2010',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_4KANTEN500M_INWONERS2012: {
  //  layertype: 'WMS',
  //  name: 'CBS Vierkanten 500m - Inwoners 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cbsvierkanten500m/wms',
  //  layers: 'inwoners_2012',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_4KANTEN500M_TOENAMEINWONERS2000TOT2010: {
  //  layertype: 'WMS',
  //  name: 'CBS Vierkanten 500m - Toename inwoners 2000 - 2010 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cbsvierkanten500m/wms',
  //  layers: 'toename_inwoners_2000_2010',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CULTUURHISTORISCHEOBJECTEN_ELEMENTEN: {
  //  layertype: 'WMS',
  //  name: 'Cultuurhistorische objecten - Elementen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cultgis/wms',
  //  layers: 'elementen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CULTUURHISTORISCHEOBJECTEN_AANDACHTSGEBIEDEN: {
  //  layertype: 'WMS',
  //  name: 'Cultuurhistorische objecten - Aandachtsgebieden (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cultgis/wms',
  //  layers: 'aandachtsgebied',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CULTUURHISTORISCHEOBJECTEN_DEELLANDSCHAPPEN: {
  //  layertype: 'WMS',
  //  name: 'Cultuurhistorische objecten - Deellandschappen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cultgis/wms',
  //  layers: 'deellandschap',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CULTUURHISTORISCHEOBJECTEN_LANDSCHAPPEN: {
  //  layertype: 'WMS',
  //  name: 'Cultuurhistorische objecten - Landschappen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cultgis/wms',
  //  layers: 'landschap',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CULTUURHISTORISCHEOBJECTEN_REGIOS: {
  //  layertype: 'WMS',
  //  name: 'Cultuurhistorische objecten - Regio\'s (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/cultgis/wms',
  //  layers: 'regios',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //DTB_PUNTEN: {
  //  layertype: 'WMS',
  //  name: 'Digitaal Topografisch Bestand (DTB) - Punten (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/digitaaltopografischbestand/wms',
  //  layers: 'punten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //DTB_LIJNEN: {
  //  layertype: 'WMS',
  //  name: 'Digitaal Topografisch Bestand (DTB) - Lijnen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/digitaaltopografischbestand/wms',
  //  layers: 'lijnen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //DTB_VLAKKEN: {
  //  layertype: 'WMS',
  //  name: 'Digitaal Topografisch Bestand (DTB) - Vlakken (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/digitaaltopografischbestand/wms',
  //  layers: 'vlakken',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //ECOTOPEN_CYCLUS_01: {
  //  layertype: 'WMS',
  //  name: 'Ecotopen Cyclus 1 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ecotopen/wms',
  //  layers: 'cyclus_een',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //ECOTOPEN_CYCLUS_02: {
  //  layertype: 'WMS',
  //  name: 'Ecotopen Cyclus 2 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ecotopen/wms',
  //  layers: 'cyclus_twee',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //ECOTOPEN_CYCLUS_03: {
  //  layertype: 'WMS',
  //  name: 'Ecotopen Cyclus 3 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/ecotopen/wms',
  //  layers: 'cyclus_drie',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //FYSISCH_GEOGRAFISCHE_REGIOS: {
  //  layertype: 'WMS',
  //  name: 'Fysisch Geografische Regios (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/fysischgeografischeregios/wms',
  //  layers: 'fysischgeografischeregios',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //GELUIDSKAARTEN_ETMAAL: {
  //  layertype: 'WMS',
  //  name: 'Geluidskaarten etmaal (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rwsgeluidskaarten/wms',
  //  layers: 'geluidskaartenetmaal',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //GELUIDSKAARTEN_NACHT: {
  //  layertype: 'WMS',
  //  name: 'Geluidskaarten nacht (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rwsgeluidskaarten/wms',
  //  layers: 'geluidskaartennacht',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //GELUIDSKAARTEN_ETMAAL_2006: {
  //  layertype: 'WMS',
  //  name: 'Geluidskaarten etmaal 2006 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rwsgeluidskaarten/wms',
  //  layers: 'geluidskaartenetmaal2006',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //GELUIDSKAARTEN_NACHT_2006: {
  //  layertype: 'WMS',
  //  name: 'Geluidskaarten nacht 2006 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rwsgeluidskaarten/wms',
  //  layers: 'geluidskaartennacht2006',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //INSPIRE_ADRESSEN: {
  //  layertype: 'WMS',
  //  name: 'Adressen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/inspireadressen/wms',
  //  layers: 'inspireadressen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //KNOOPPUNTEN: {
  //  layertype: 'WMS',
  //  name: 'Fietsknooppuntnetwerken (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/fietsknooppuntennetwerk/wms',
  //  layers: 'netwerken,knooppunten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //LAWROUTES: {
  //  layertype: 'WMS',
  //  name: 'Lange-afstandswandelroutes (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/lawroutes/wms',
  //  layers: 'lawroutes',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //LFROUTES: {
  //  layertype: 'WMS',
  //  name: 'Landelijke Fietsroutes (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/lfroutes/wms',
  //  layers: 'lfroutes',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //LUFO: {
  //  layertype: 'WMTS',
  //  name: 'PDOK achtergrond luchtfoto\'s (WMTS)',
  //  url: 'http://geodata1.nationaalgeoregister.nl/luchtfoto/wmts?',
  //  version: "1.3.0",
  //  layer: 'luchtfoto',
  //  style: '',
  //  matrixSet: 'nltilingschema',
  //  visibility: true,
  //  isBaseLayer: true,
  //  format: 'image/jpeg',
  //  attribution: '<a href="https://www.pdok.nl/nl/copyright/luchtfotos/" target="_blank">(c) CC-BY-NC</a>',
  //  zoomOffset: 2
  //},
  //MOSSELENOESTERHABITATS: {
  //  layertype: 'WMS',
  //  name: 'Mossel en Oester habitats (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/mosselenoesterhabitats/wms',
  //  layers: 'mosselenoesterhabitats',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //MOSSELZAADINVANGINSTALLATIES: {
  //  layertype: 'WMS',
  //  name: 'Mosselzaad invanginstallaties (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/mosselzaadinvanginstallaties/wms',
  //  layers: 'mosselzaadinvanginstallaties',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NATIONALE_PARKEN: {
  //  layertype: 'WMS',
  //  name: 'Nationale parken (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nationaleparken/wms',
  //  layers: 'nationaleparken',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NATURA2000: {
  //  layertype: 'WMTS',
  //  name: 'Natura 2000 (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/natura2000?',
  //  layer: 'natura2000',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //NATURA2000_WMS: {
  //  layertype: 'WMS',
  //  name: 'Natura 2000 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/natura2000/wms?',
  //  layers: 'natura2000',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NHI_DM_Links: {
  //  layertype: 'WMS',
  //  name: 'Nationaal Hydrologisch Instrumentarium (NHI) - DM Links (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nhi/wms',
  //  layers: 'dmlinks',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NHI_DM_NODES: {
  //  layertype: 'WMS',
  //  name: 'Nationaal Hydrologisch Instrumentarium (NHI) - DM Nodes (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nhi/wms',
  //  layers: 'dmnodes',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2011: {
  //  layertype: 'WMTS',
  //  name: 'NOK2011 - Natuurmeting Op Kaart (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/nok2011',
  //  layer: 'nok2011',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false
  //},
  //NOK2011_BEGRENZING_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2011 - Begrenzing 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2011/wms?',
  //  layers: 'begrenzing',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2011_EHS_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2011 - EHS 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2011/wms?',
  //  layers: 'planologischeehs',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2011_VERWERVINGINRICHTING_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2011 - Verwerving inrichting 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2011/wms?',
  //  layers: 'verwervinginrichting',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2012_BEGRENZING_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2012 - Begrenzing 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2012/wms?',
  //  layers: 'begrenzing',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2012_EHS_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2012 - EHS 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2012/wms?',
  //  layers: 'planologischeehs',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2012_VERWERVINGINRICHTING_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2012 - Verwerving inrichting 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2012/wms?',
  //  layers: 'verwervinginrichting',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2012_BEHEER_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2012 - Beheer 2012 (WMS)',
  //  url: 'http://test.geodata.nationaalgeoregister.nl/nok2012/wms?',
  //  layers: 'beheer',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2013_BEGRENZING_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2013 - Begrenzing 2013 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2013/wms?',
  //  layers: 'begrenzing',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2013_EHS_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2013 - EHS 2013 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2013/wms?',
  //  layers: 'planologischeehs',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2013_VERWERVINGINRICHTING_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2013 - Verwerving inrichting 2013 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2013/wms?',
  //  layers: 'verwervinginrichting',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOK2013_BEHEER_WMS: {
  //  layertype: 'WMS',
  //  name: 'NOK2013 - Beheer 2013 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nok2013/wms?',
  //  layers: 'beheer',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_KABELS_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Kabels (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/noordzeekabelsenleidingen/wms?',
  //  layers: 'kabels',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_LEID_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Leidingen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/noordzeekabelsenleidingen/wms?',
  //  layers: 'leidingen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_MARBASIS_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Maritieme grenzen Basis (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/maritiemegrenzen/wms?',
  //  layers: 'nederlandsebasislijn',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_MAR01_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Maritieme grenzen 1 mijl grens (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/maritiemegrenzen/wms?',
  //  layers: 'nautische01mijlgrens',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_MAR03_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Maritieme grenzen 3 mijl grens (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/maritiemegrenzen/wms?',
  //  layers: 'nautische03mijlgrens',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_MAR06_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Maritieme grenzen 6 mijl grens (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/maritiemegrenzen/wms?',
  //  layers: 'nautische06mijlgrens',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_MAR12_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Maritieme grenzen 12 mijl grens (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/maritiemegrenzen/wms?',
  //  layers: 'nautische12mijlgrens',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_MAR24_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Maritieme grenzen 24 mijl grens (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/maritiemegrenzen/wms?',
  //  layers: 'nautische24mijlgrens',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_WIN_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Wingebieden (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/noordzeewingebieden/wms?',
  //  layers: 'noordzeewingebieden',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_VAARDRIJVEND_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Vaarwegmarkeringen Drijvend (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/noordzeevaarwegmarkeringenrd/wms?',
  //  layers: 'markdrijvendrd',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NOORD_VAARVAST_WMS: {
  //  layertype: 'WMS',
  //  name: 'Noordzee Vaarwegmarkeringen Vast (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/noordzeevaarwegmarkeringenrd/wms?',
  //  layers: 'markvastrd',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NWB_SPOORWEGEN: {
  //  layertype: 'WMS',
  //  name: 'NWB Spoorwegen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nwbspoorwegen/wms',
  //  layers: 'hectopunten,overgangen,oversteken,spoorvakken,treinstations',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NWB_VAARWEGEN: {
  //  layertype: 'WMS',
  //  name: 'NWB Vaarwegen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nwbvaarwegen/wms',
  //  layers: 'vaarwegvakken,kmmarkeringen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //NWB_WEGEN: {
  //  layertype: 'WMS',
  //  name: 'NWB Wegen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/nwbwegen/wms',
  //  layers: 'wegvakken,hectopunten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //OVERHEIDSDIENSTEN: {
  //  layertype: 'WMS',
  //  name: 'Administratieve en sociale overheidsdiensten (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/overheidsdiensten/wms',
  //  layers: 'overheidsdiensten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //RD_INFO_STATIONS: {
  //  layertype: 'WMS',
  //  name: 'RD Info Stations (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rdinfo/wms',
  //  layers: 'stations',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //RD_INFO_PUNTEN: {
  //  layertype: 'WMS',
  //  name: 'RD Info Punten (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rdinfo/wms',
  //  layers: 'punten',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //RWSOPPERVLAKTEWATERLICHAMEN_VLAKKEN: {
  //  layertype: 'WMS',
  //  name: 'RWS Oppervlaktewaterlichamen - vlakken (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rwsoppervlaktewaterlichamen/wms',
  //  layers: 'vlakken',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //RWSOPPERVLAKTEWATERLICHAMEN_LIJNEN: {
  //  layertype: 'WMS',
  //  name: 'RWS Oppervlaktewaterlichamen - lijnen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/rwsoppervlaktewaterlichamen/wms',
  //  layers: 'lijnen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //SCHELPDIERENPERCELEN: {
  //  layertype: 'WMS',
  //  name: 'Schelpdieren Percelen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/schelpdierenpercelen/wms',
  //  layers: 'schelpdierenpercelen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //STREEKPADEN: {
  //  layertype: 'WMS',
  //  name: 'Nationale Streekpaden (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/streekpaden/wms',
  //  layers: 'streekpaden',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //STORTENLOSWALLEN_VAK: {
  //  layertype: 'WMS',
  //  name: 'Sort en Loswallen - vakindeling (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/stortenloswallen/wms',
  //  layers: 'stortenloswalvakindeling',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //STORTENLOSWALLEN: {
  //  layertype: 'WMS',
  //  name: 'Sort en Loswallen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/stortenloswallen/wms',
  //  layers: 'stortloswal',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //TOP10NL: {
  //  layertype: 'WMTS',
  //  name: 'TOP10 NL (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/top10nl?',
  //  layer: 'top10nl',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false,
  //  attribution: '(c) Kadaster'
  //},
  //TOP250RASTER: {
  //  layertype: 'WMTS',
  //  name: 'TOP250NL Raster (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/top50raster?',
  //  layer: 'top250raster',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false,
  //  attribution: '(c) Kadaster'
  //},
  //TOP25RASTER: {
  //  layertype: 'WMTS',
  //  name: 'TOP25NL Raster (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/top25raster?',
  //  layer: 'top25raster',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false,
  //  attribution: '(c) Kadaster'
  //},
  //TOP50RASTER: {
  //  layertype: 'WMTS',
  //  name: 'TOP50NL Raster (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/top50raster?',
  //  layer: 'top50raster',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false,
  //  attribution: '(c) Kadaster'
  //},
  //TOP50VECTOR: {
  //  layertype: 'WMTS',
  //  name: 'TOP50NL Vector (WMTS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/tiles/service/wmts/top50vector?',
  //  layer: 'top50vector',
  //  style: null,
  //  matrixSet: 'EPSG:28992',
  //  visibility: true,
  //  isBaseLayer: false,
  //  attribution: '(c) Kadaster'
  //},
  //VIN_BEVAARBAARHEID: {
  //  layertype: 'WMS',
  //  name: 'Vaarkenmerken in Nederland (VIN) - Bevaarbaarheid (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/vin/wms',
  //  layers: 'bevaarbaarheid',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //WEGGEGEVENS_RIJBANEN: {
  //  layertype: 'WMS',
  //  name: 'Weggegevens - aantal rijbanen (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/weggeg/wms',
  //  layers: 'weggegaantalrijbanen',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //WEGGEGEVENS_MAXSNELHEID: {
  //  layertype: 'WMS',
  //  name: 'Weggegevens - maximum snelheid (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/weggeg/wms',
  //  layers: 'weggegmaximumsnelheden',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //WETLANDS: {
  //  layertype: 'WMS',
  //  name: 'Wetlands (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wetlands/wms?',
  //  layers: 'wetlands',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSBUURTEN2012: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Buurten 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2012/wms?',
  //  layers: 'cbs_buurten_2012',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSWIJKEN2012: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Wijken 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2012/wms?',
  //  layers: 'cbs_wijken_2012',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSGEMEENTEN2012: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Gemeenten 2012 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2012/wms?',
  //  layers: 'gemeenten2012',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSBUURTEN2011: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Buurten 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2011/wms?',
  //  layers: 'cbs_buurten_2011',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSWIJKEN2011: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Wijken 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2011/wms?',
  //  layers: 'cbs_wijken_2011',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSGEMEENTEN2011: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Gemeenten 2011 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2011/wms?',
  //  layers: 'gemeenten2011',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSBUURTEN2010: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Buurten 2010 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2010/wms?',
  //  layers: 'cbs_buurten_2010',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSWIJKEN2010: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Wijken 2010 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2010/wms?',
  //  layers: 'cbs_wijken_2010',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSGEMEENTEN2010: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Gemeenten 2010 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2010/wms?',
  //  layers: 'gemeenten2010',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSBUURTEN2009: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Buurten 2009 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2009/wms?',
  //  layers: 'cbs_buurten_2009',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSWIJKEN2009: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Wijken 2009 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2009/wms?',
  //  layers: 'cbs_wijken_2009',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //CBS_WIJKENENBUURTEN_CBSGEMEENTEN2009: {
  //  layertype: 'WMS',
  //  name: 'CBS Wijken en buurten - Gemeenten 2009 (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wijkenbuurten2009/wms?',
  //  layers: 'gemeenten2009',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //WKPB: {
  //  layertype: 'WMS',
  //  name: 'WKPB (WMS)',
  //  url: 'http://geodata.nationaalgeoregister.nl/wkpb/wms',
  //  layers: 'pbwetbodembescherming',
  //  transparent: 'true',
  //  format: 'image/png',
  //  visibility: true,
  //  isBaseLayer: false,
  //  singleTile: true
  //},
  //JOIN_MELDING_FIXI_WFS: {
  //    layertype: 'WFS',
  //    name: 'Meldingen FIXI (test)',
  //    url: "http://zaaksysteem.meervoort.nl/aspx/wfs?UT=3ADDC9DA",
  //    featureType: "CT.C3DBF2CE8B5546838EA5C117C1C7AE22",
  //    featureNS: "http://decosonline.com",
  //    geometryName: "Location",
  //    minZoom: 12,
  //    markerStyle: oFixiStyle,
  //    visibility: true,
  //    isBaseLayer: false,
  //    singleTile: true
    //}
    //BAG_VERBLIJFSOBJECT_WFS1: {
    //    layertype: 'WFS',
    //    name: 'BAG - Verblijfsobject (WFS)',
    //    url: "http://geodata.nationaalgeoregister.nl/bagviewer/wfs",
    //    featureType: "verblijfsobject",
    //    featureNS: "http://bagviewer.geonovum.nl",
    //    geometryName: "geometrie",
    //    minZoom: 12,
    //    markerStyle: oDecosStyle3,
    //    visibility: true,
    //    isBaseLayer: false,
    //    singleTile: true
    //}
};
