var sDecosAspxUrl = window.location.protocol + '//' + window.location.host;
var oDecosStyle = { id: "Decos", name: "Decos", externalGraphic: sDecosAspxUrl + '/assets/map/pdok/bag/m3.png', graphicHeight: 16, graphicWidth: 16, graphicYOffset: -16, pointRadius: 1 };
var oDecosStyle2 = { id: "Decos", name: "Decos", externalGraphic: sDecosAspxUrl + '/assets/map/pdok/bag/m2.png', graphicHeight: 12, graphicWidth: 12, graphicYOffset: -12, pointRadius: 1 };
var oDecosStyle3 = { id: "Decos", name: "Decos", externalGraphic: sDecosAspxUrl + '/assets/map/pdok/bag/sq8c.png', graphicHeight: 8, graphicWidth: 8, graphicYOffset: -8, pointRadius: 1 }; // Berend DWE/8069
var oFixiStyle = { id: "Fixi", name: "Fixi", externalGraphic: sDecosAspxUrl + '/assets/map/pdok/bag/fixi.png', graphicHeight: 16, graphicWidth: 16, graphicYOffset: -16, pointRadius: 1 }; // Berend DWE/8069

//> Berend DWE/8068
var m_bSelectPointActive = false;
var m_divSearchBox = null;
var m_iMinMarkerZoom = 12;
//< Berend DWE/8068

function DecosGetMarkers(map) {
  var oExtent = map.getExtent();
  var o = OpenLayers.Util.getParameters(); // Berend DWE/8068
  var p = new SOAPClientParameters();
  p.add("iLeft", Math.floor(oExtent.left));
  p.add("iTop", Math.floor(oExtent.top));
  p.add("iRight", Math.floor(oExtent.right));
  p.add("iBottom", Math.floor(oExtent.bottom));
  //> Berend DWE/8068
  if (o.BK && o.T) {
    p.add("sFilter", "<F BK='" + o.BK + "' T='" + o.T + "' />");
    // SOAPClient.invoke(sDecosAspxUrl + 'webservices/BAGServices.asmx', 'GetFilteredMarkers', p, true, function (resp) { DecosGetMarkersCallback(resp, map); });
  }
  //else
  //SOAPClient.invoke(sDecosAspxUrl + 'webservices/BAGServices.asmx', 'GetMarkers', p, true, function (resp) { DecosGetMarkersCallback(resp, map); });
}

var m_aDecosMarkers = new Array();
function DecosGetMarkersCallback(sResponse, map) {
  if (sResponse && sResponse.length > 0) {
    var oLayer = map.getLayersByName('Markers')[0];
    if (oLayer && (typeof oLayer != 'undefined')) {
      var aResponse = sResponse.split('\n');
      var aFeatures = new Array();
      for (var i = 0; i < aResponse.length; i++) {
        var aResponseData = aResponse[i].split('|');
        if (aResponseData.length > 2) {
          var sItemKey = aResponseData[0];
          if (m_aDecosMarkers.indexOf(sItemKey) < 0) {
            m_aDecosMarkers.push(sItemKey);
            var x = parseInt(aResponseData[1]);
            var y = parseInt(aResponseData[2]);
            var bDuplicate = false;
            if (oLayer.features && oLayer.features.length)
              for (var p = 0; p < oLayer.features.length; p++) {
                var f = oLayer.features[p];
                if (f.geometry.y && (Math.abs(f.geometry.x - x) < 2) && (Math.abs(f.geometry.y - y) < 2)) {
                  bDuplicate = true;
                  break;
                }
              }
            if (!bDuplicate) {
              var newFt = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(x, y));
              newFt.id = sItemKey;
              newFt.style = oDecosStyle;
              aFeatures.push(newFt);
            }
          }
        }
      }
      if (aFeatures.length > 0) {
        //> Berend DWE/8068
        // Ensure that the mloc point is always on top and in its own separate vector layer
        var oMlocFeature = null;
        if ((oLayer.features.length > 0) && (oLayer.features[oLayer.features.length - 1].style.id == "mt0")) {
          oMlocFeature = oLayer.features[oLayer.features.length - 1];
          oLayer.removeFeatures([oMlocFeature]);
        }
        oLayer.addFeatures(aFeatures);

        // Add the mloc feature to the 'LocationMarker' layer
        oLayer = map.getLayersByName('LocationMarker')[0];
        if (oLayer && (typeof oLayer != 'undefined'))
          oLayer.addFeatures([oMlocFeature]);
        //< Berend DWE/8068
      }
    }
  }
}

function DecosGetItemMarker(sItemKey, sItemType) {
  var p = new SOAPClientParameters();
  p.add("sItemKey", sItemKey);
  p.add("sItemType", sItemType);
  SOAPClient.invoke(sDecosAspxUrl + 'webservices/BAGServices.asmx', 'GetItemMarker', p, true, DecosGetItemMarkerCallback);
}

function DecosGetItemMarkerCallback(sResponse) {
  var o = OpenLayers.Util.getParameters();
  if (sResponse) { // Berend DWE/8068
    var asResponse = sResponse.split('|');
    if (asResponse.length >= 3) {
      m_aDecosMarkers.push(asResponse[0]);
      o.loc = asResponse[1] + "," + asResponse[2];
      o.mloc = o.loc;
      if (parent && parent.mapSetLocationBook && asResponse.length >= 4)
        parent.mapSetLocationBook(asResponse[3]);
      try {
        if (top.SetLastMapLocation)
          top.SetLastMapLocation(o.loc);
      } catch (e) { }
    }
    o.zoom = "13";
  } else if (parent && parent.mapLocationNotFound) {
    var sMapLocation = parent.mapLocationNotFound();
    if (sMapLocation) {
      o.loc = sMapLocation;
      o.zoom = "10";
    }
  }
  o.mimg = '../bag/m1.png';
  api = new Pdok.Api(o);
  api.disablePopups();
  DecosAddAerialPhotoLayer(api.map);
}

function DecosPanZoom(e, map) {
  //> Berend DWE/8068
  var bShowMarkers = (map.getZoom() >= m_iMinMarkerZoom);
  DecosShowMarkers(map, bShowMarkers);
  if (bShowMarkers) //< Berend DWE/8068
    DecosGetMarkers(map);
}

function DecosAddAerialPhotoLayer(map) {
  var sBaseLayerName = DecosGetBaseLayerName();
  var wmts = new OpenLayers.Layer.WMTS({
    name: "Luchtfoto's",
    url: "https://service.pdok.nl/hwh/luchtfotorgb/wmts/v1_0",
    layer: "Actueel_ortho25",
    matrixSet: "EPSG:28992",
    matrixIds: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13'],
    numZoomLevels: 14,
    format: "image/jpeg",
    style: "default",
    attribution: "Kaartgegevens: Geospatial Data Service Centre",
    isBaseLayer: true
  });
  map.addLayers([wmts]);
  DecosSetBaseLayerName(sBaseLayerName);
  if (sBaseLayerName == wmts.name) {
    map.setBaseLayer(wmts);
  }
}

//> Berend DWE/8068
// Gets currently selected base layer name
function DecosGetBaseLayerName() {
  try {
    if (top.GetMapBaseLayer) return top.GetMapBaseLayer();
  } catch (e) { }
  return null;
}

// Stores currently selected base layer name in session
function DecosSetBaseLayerName(sLayerName) {
  try {
    if (top.SetMapBaseLayer) return top.SetMapBaseLayer(sLayerName);
  } catch (e) { }
}

function DecosShowMarkers(map, bShow) {
  var oLayer = map.getLayersByName('Markers')[0];
  if (oLayer && (typeof oLayer != 'undefined')) {
    oLayer.setVisibility(bShow);
  }
}

function DecosOnChangeBaseLayer(e, olMap) {
  DecosSetBaseLayerName(e.layer.name);
}

function DecosSelectPointActivate(bSetActive) {
  var oMap = document.getElementById("map");
  if (oMap) {
    m_bSelectPointActive = bSetActive;
    oMap.style.cursor = bSetActive ? 'crosshair' : '';
    return true;
  }
  return false;
}

function DecosSelectPointToggle() {
  if (DecosSelectPointActivate(!m_bSelectPointActive))
    return m_bSelectPointActive;
  return false;
}

// Shows or hides search box
function DecosShowSearchBox(bShow) {
  if (m_divSearchBox)
    m_divSearchBox.style.display = bShow ? '' : 'none';
}

// Toggles visibility of search box
function DecosToggleSearchBox() {
  var bSetVisible = false;
  if (m_divSearchBox) {
    bSetVisible = (m_divSearchBox.style.display == 'none');
    DecosShowSearchBox(bSetVisible);
  }
  return bSetVisible;
}

// Handles feature (point) selection
function DecosOnSelectPoint(e) {
  if (window.PdokInstance && window.PdokInstance.selectControl)
    window.PdokInstance.selectControl.unselectAll();
  if (parent && e.id) {
    var bDecosItemKey = (e.id.length == 32) && (e.id.indexOf('OpenLayers') < 0);
    if (m_bSelectPointActive) {
      var o = OpenLayers.Util.getParameters();
      if ((e.id.indexOf('DSR') == 0) && parent.mapSetLocationFromSearchResult) {
        DecosSelectPointActivate(false);
        // id of geocoder search result starts with 'DSR'. Set location from geocoder search result.
        var aXY = parent.mapSetLocationFromSearchResult(o.I, o.T, e.id, e.layer);
        if (aXY && (aXY.length >= 2)) {
          var oMap = document.getElementById("map");
          if (oMap)
            oMap.style.cursor = 'wait';
        }
      } else if (bDecosItemKey && parent.mapSetLocationFromItem && e.geometry) {
        // This is a Decos item. Set location from item
        if (parent.mapSetLocationFromItem(o.I, o.T, e.id, e.geometry.x, e.geometry.y) && e.layer.map)
          DecosSetMLoc(e.layer.map, e.geometry.x, e.geometry.y);
        DecosSelectPointActivate(false);
      }
    } else if (bDecosItemKey) {
      // Show popup for clicked Decos item
      DecosShowPopup(parent, sDecosAspxUrl + 'item.aspx?I=' + e.id, 'DecosItem');
    } else if (e.fid && e.attributes) {
      // A WFS layer feature has an fid (= external id of feature) and a list of attributes.
      // For demonstration purposes, show a list of the attributes in a popup.
      DecosShowWfsFeaturePopup(e);
    }
  }
}

function isJoinCase(data) {
  var retVal = false;
  if (data && data.UniqueID && data.UniqueID.length > 0)
    retVal = true;
  return retVal;
}

function openCase(itemKey, description) {
  try {
    if (itemKey && itemKey.length > 0) {
      var injector = angular.element(document).injector();
      var sessionManager = injector.get('sessionManager');
      var caseEntity = new Object();
      caseEntity.RelatedEntityFqdn = 'Decos_Kcs_Cases_Entities_CaseEntity';
      caseEntity.ObjectSource = 'Decos.Kcs.Cases.DecosConnect';
      caseEntity.Id = itemKey;
      caseEntity.Partial = true;
      caseEntity.Description = decodeURIComponent(description);
      caseEntity.locationUrl = '/detailView/caseentity/' + encodeURIComponent(itemKey);
      sessionManager.selectedEntity = caseEntity;
      sessionManager.addBreadcrumbItems([sessionManager.selectedEntity], null, "detailview");
      var $location = injector.get('$location');
      $location.path('/detailView/caseentity/' + encodeURIComponent(itemKey)).replace();
    }
  }
  catch (e) { }
}

// Shows a popup for the specified WFS feature with all its attributes
function DecosShowWfsFeaturePopup(feature) {
  var injector = angular.element(document).injector();
  var localize = injector.get('localize');

  // Check if the passed object is a WFS feature
  if (feature.fid && feature.attributes && feature.geometry) {
    var popupLocation = (feature.geometry.x && feature.geometry.y)
      ? new OpenLayers.LonLat(feature.geometry.x, feature.geometry.y) // If the feature is a point, its location is popup anchor location
      : feature.geometry.getBounds().getCenterLonLat(); // For a non-point, take the feature's center location
    // If the center location of the feature is outside the viewport, try to show the popup at the mouse position.
    try {
      if (!feature.layer.map.getExtent().containsLonLat(popupLocation)) {
        popupLocation = this.map.getLonLatFromPixel(this.map.getControlsByClass("OpenLayers.Control.MousePosition")[0].lastXy);
        if (!feature.layer.map.getExtent().containsLonLat(popupLocation))
          return; // Do nothing if we still failed to get a valid position
      }
    }
    catch (e) { }
    var joinItem = isJoinCase(feature.attributes);
    // Build popup html markup from attributes name/value pairs
    var sMarkup = '';
    // Create a div element to help with html encoding the text
    var div = document.createElement('div');
    // Enumerate all WFS feature attributes and their values
    for (var attr in feature.attributes) {
      var localizeCaption = attr;
      var sValue = feature.attributes[attr];
      if (sValue) { // skip empty values
        // HTML-encode the text
        if (localizeCaption.toLowerCase().indexOf('date') > -1) {
          var date2 = Date.parse(sValue.split("+")[0].split(".")[0].replace("Z", ""));
          sValue = date2.toString('dd MMM yyyy');
        }
        if (joinItem && localize)
          localizeCaption = localize.getLocalizedString('_' + localizeCaption.toUpperCase() + '_');

        if (localizeCaption && localizeCaption.indexOf('_') != 0) {
          var sAttr = DecosHtmlEncodeUsingDiv(div, localizeCaption);
          sValue = DecosHtmlEncodeUsingDiv(div, sValue);
          // Markup for an attribute: value table row       
          var sTR = '<tr><td>' + sAttr + '</td><td>:&nbsp;</td><td title="' + sValue + '" class="popupTdValue" >' + sValue + '</td></tr>';
          // If the markup is still empty, create the table node
          if (!sMarkup)
            sMarkup = '<table>';
          // Add the row to the markup
          sMarkup += sTR;
        }
      }
    }
    if (joinItem) {
      var localizeCaption = localize.getLocalizedString("_GEO_CASE_LINK_CAPTION_");
      var itemKey = feature.attributes.UniqueID;
      var description = encodeURIComponent(feature.attributes.Description);
      if (description == null || description.length == 0)
        description = encodeURIComponent(feature.attributes.Mark);
      var sValue = localize.getLocalizedString("_OPEN_CASE_");
      var sAttr = DecosHtmlEncodeUsingDiv(div, localizeCaption);
      sValue = DecosHtmlEncodeUsingDiv(div, sValue);
      var sTR = "<tr><td>" + sAttr + "</td><td>:&nbsp;</td><td class='darkBlueFontColor pointerCursor' style='text-decoration:underline' onclick=openCase('" + itemKey + "','" + description + "')>" + sValue + "</td></tr>";
      sMarkup += sTR;
    }

    // If the markup is non-empty we close the tabel and show it in a popup
    if (sMarkup) {
      sMarkup += '</table>';
      // Set the innerHTML of the div to the markup so that we can get the size of the table
      div.innerHTML = sMarkup;
      var popup = new OpenLayers.Popup.FramedCloud("featurePopup",
            //feature.geometry.getBounds().getCenterLonLat(),
            popupLocation,
            new OpenLayers.Size(div.innerWidth + 8, div.innerHeight),
            sMarkup,
            null, true, function (evt) {
              this.hide();
            }
        );
      feature.popup = popup;
      popup.feature = feature;
      feature.layer.map.addPopup(popup, true);
    }
  }
}

// HTML-encodes the passed text using a temporary div element
function DecosHtmlEncodeUsingDiv(div, sText) {
  if ('textContent' in div)
    div.textContent = sText;
  else
    div.innerText = sText; // for old IE versions
  return div.innerHTML; // html-encoded markup of the text
}

// Code to show decos popup for JOIN
function DecosShowPopup(wnd, sUrl, sWindowName) {
  if (wnd.showpopup) {
    if ((typeof top.IsTabletApp != 'undefined') && top.IsTabletApp())
      top.CreateWebPageFrame(sUrl, false, true);
    else if (typeof top.m_iPopUpCount != 'undefined')
      wnd.showpopup(sUrl, sWindowName, 840, 540, "toolbar=no,directories=no,status=no,menubar=yes,scrollbars=0,resizable=1", true);
    else if (wnd.showpopupinwindow)
      wnd.showpopupinwindow(sUrl, sWindowName, 900, 600, "toolbar=no,directories=no,status=no,menubar=yes,scrollbars=0,resizable=1", true);
  }
}

// Code to show decos popup for JOIN
function DecosShowPopup(wnd, sUrl, sWindowName) {
  if (wnd.showpopup) {
    if ((typeof top.IsTabletApp != 'undefined') && top.IsTabletApp())
      top.CreateWebPageFrame(sUrl, false, true);
    else if (typeof top.m_iPopUpCount != 'undefined')
      wnd.showpopup(sUrl, sWindowName, 840, 540, "toolbar=no,directories=no,status=no,menubar=yes,scrollbars=0,resizable=1", true);
    else if (wnd.showpopupinwindow)
      wnd.showpopupinwindow(sUrl, sWindowName, 900, 600, "toolbar=no,directories=no,status=no,menubar=yes,scrollbars=0,resizable=1", true);
  }
}

// Called after linking item to search result is complete
function DecosOnSearchResultSelectionComplete(layer, aXY) {
  if (layer && aXY && (aXY.length >= 2)) {
    DecosSetMLoc(layer.map, Math.round(parseFloat(aXY[0])), Math.round(parseFloat(aXY[1])));
    layer.removeAllFeatures();
  }
  var oMap = document.getElementById("map");
  if (oMap)
    oMap.style.cursor = m_bSelectPointActive ? 'crosshair' : '';
}

// Sets specified location as marker location
function DecosSetMLoc(map, x, y) {
  var oLayer = map.getLayersByName('LocationMarker')[0]; // Berend DWE/8068: separate layer for location marker
  if (oLayer && (typeof oLayer != 'undefined')) {
    if (window.PdokInstance) {
      if (window.PdokInstance.mlocFeature) {
        window.PdokInstance.mlocFeature.geometry.move(x - window.PdokInstance.mlocFeature.geometry.x, y - window.PdokInstance.mlocFeature.geometry.y);
      } else {
        var wkt = 'POINT(' + x + ' ' + y + ')';
        window.PdokInstance.mlocFeature = window.PdokInstance.createFeature(wkt, window.PdokInstance.mt, window.PdokInstance.titel, window.PdokInstance.tekst);
      }
      if (oLayer.features.length == 0)
        oLayer.addFeatures([window.PdokInstance.mlocFeature]);
    }
    oLayer.redraw();
  }
}

// Returns current marker location as semicolon-separated coordinates string
function DecosCurrentMLoc() {
  if (window.PdokInstance && window.PdokInstance.mlocFeature)
    return Math.round(window.PdokInstance.mlocFeature.geometry.x).toString() + ';' + Math.round(window.PdokInstance.mlocFeature.geometry.y).toString();
  return null;
}

function DecosZoomIn() {
  if (window.PdokInstance && window.PdokInstance.map) {
    var iZoom = window.PdokInstance.map.getZoom();
    if (iZoom < 14) {
      window.PdokInstance.map.zoomTo(iZoom + 1);
      DecosPanZoom(null, window.PdokInstance.map);
    }
  }
}

function DecosZoomOut() {
  if (window.PdokInstance && window.PdokInstance.map) {
    var iZoom = window.PdokInstance.map.getZoom();
    if (iZoom > 2) {
      window.PdokInstance.map.zoomTo(iZoom - 1);
      DecosPanZoom(null, window.PdokInstance.map);
    }
  }
}

//< Berend DWE/8068

OpenLayers.Control.Click = OpenLayers.Class(OpenLayers.Control, {
  defaultHandlerOptions: {
    'single': true,
    'double': false,
    'pixelTolerance': 0,
    'stopSingle': false,
    'stopDouble': false
  },

  initialize: function (options) {
    this.handlerOptions = OpenLayers.Util.extend(
        {}, this.defaultHandlerOptions
    );
    OpenLayers.Control.prototype.initialize.apply(
        this, arguments
    );
    this.handler = new OpenLayers.Handler.Click(
        this, {
          'click': this.trigger
        }, this.handlerOptions
    );
  },

  trigger: function (e) {
    if (window.location.pathname.indexOf('/bag/pdok.html') >= 0) {
      DecosShowPopup(parent, sDecosAspxUrl + 'pdok/kaart.html' + window.location.search, '_blank'); // Berend DWE/8068
    } else {
      var o = OpenLayers.Util.getParameters(); // Berend DWE/8068
      if (m_bSelectPointActive || !o.BK) { // Berend DWE/8068
        var lonLat = this.map.getLonLatFromPixel(e.xy);
        if (!lonLat) {
          // map has not yet been properly initialized
          return;
        }
        if (this.displayProjection) {
          lonLat.transform(this.map.getProjectionObject(),
                           this.displayProjection);
        }
        var x = Math.floor(lonLat.lon);
        var y = Math.floor(lonLat.lat);
        if (m_bSelectPointActive) {
          if (parent && parent.mapSetLocationFromPoint && parent.mapSetLocationFromPoint(o.I, o.T, x, y)) {
            DecosSetMLoc(this.map, x, y);
            DecosSelectPointActivate(false);
          }
        } else {
          //var sBAGFindUrl = sDecosAspxUrl + 'BAGFind.aspx?x=' + x + '&y=' + y;
          //DecosShowPopup(top, sBAGFindUrl, 'BAGFind' + x + '_' + y); // Berend DWE/8068
        }
      }
    }
  }
});