﻿using log4net;
using System.IO;
using System.Web;
using System.Web.Http;
using Decos.Kcs.Core.Web;
using Decos.Kcs.Users.Messages;

namespace Decos.Kcs.Users.Authentication.Web.App_Code
{
    public class PostController : ApiController
    {
        private ILog _logger;
        public PostController()
        {
            _logger = LogManager.GetLogger(typeof(PostController));
        }

        [HttpPost]
        [Throttle(Name = "SendOtp", Seconds = 1)]
        public void SendOtp()
        {
            _logger.Debug("SendOtp called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var sendOtpRequest = HubHelper.DeserializeJsonFromStream<SendOtpRequest>(reader))
                {
                    if (sendOtpRequest == null) return;
                    sendOtpRequest.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    sendOtpRequest.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], sendOtpRequest);
                }
            }
        }
    }
}