﻿using Decos.Kcs.Core.Messages;
using Decos.Kcs.Core.Web;
using Decos.Kcs.Tickets.Messages;
using log4net;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.Tickets.Web
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        private ILog _logger;
        public PostController()
        {
            _logger = LogManager.GetLogger(typeof(PostController));
        }
        [HttpPost]
        [Throttle(Name = "PostTicketXDoc", Seconds = 1)]
        public void PostTicketXDoc()
        {
            _logger.Debug("CreateOrUpdateTicketRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var ticketCreateOrUpdateRequest = HubHelper.DeserializeJsonFromStream<CreateOrUpdateTicketRequest>(reader))
                {
                    if (ticketCreateOrUpdateRequest == null) return;
                    ticketCreateOrUpdateRequest.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    ticketCreateOrUpdateRequest.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<TicketsHub>(HttpContext.Current.Request.QueryString["connectionid"], ticketCreateOrUpdateRequest);
                }
            }
        }
        [HttpPost]
        [Throttle(Name = "PostCreateReportXDoc", Seconds = 1)]
        public void PostCreateReportXDoc()
        {
            _logger.Debug("CreateReportRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<CreateReportRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<TicketsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
    }
}