﻿using Decos.Kcs.Core.Web;
using Decos.Kcs.Themes.Messages;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.Themes.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        [HttpPost]
        [Throttle(Name = "PostThemeXDoc", Seconds = 1)]
        public void PostThemeXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<CreateOrUpdateThemeRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
    }
}