﻿using Decos.Kcs.Configuration.Messages;
using Decos.Kcs.Core.Messages;
using Decos.Kcs.Core.Web;
using Decos.Kcs.Reports.Messages;
using Decos.Kcs.SystemComponents.Messages;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.SystemComponents.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        [HttpPost]
        public void PostLinkUnlinkEntityItemsXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<CreateOrUpdateEntityLinkRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }

        [HttpPost]
        public void PostUnsuccessfullAttemptsXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                var request = HubHelper.DeserializeJsonFromStream<LogUnsuccessfulAttemptsRequest>(reader);
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }

        [HttpPost]
        public void PostUpdateApplicationSettingXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<UpdateApplicationSettingRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }

        [HttpPost]
        public void PostSummarizeDocumentXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<SummarizeDocumentRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
    }
}