﻿using Decos.Kcs.Core.Global;
using log4net;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace Decos.Kcs.SystemComponents.Web.App_Code
{
    public class HealthCheckController : ApiController
    {
        private static ILog _logger = LogManager.GetLogger(typeof(HealthCheckController));
        [HttpGet]
        public IHttpActionResult Liveness()
        {
            return Ok();
        }

        [HttpGet]
        public IHttpActionResult Readiness()
        {

            if (StringFunctions.ReadinessCheck())
                return Ok();
            else
                return StatusCode(HttpStatusCode.ExpectationFailed);
        }
    }
}
