﻿using Decos.Kcs.Core.Web;
using Decos.Kcs.Prefill.Messages;
using log4net;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.Products.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        private ILog _logger;
        public PostController()
        {
            _logger = LogManager.GetLogger(typeof(PostController));
        }

        [HttpPost]
        public void PostStartContentRequestXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<StartContentRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
    }
}