﻿using Decos.Kcs.Core.Web;
using Decos.Kcs.Phone.Messages;
using log4net;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.Phone.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        private ILog _logger;
        public PostController()
        {
            _logger = LogManager.GetLogger(typeof(PostController));
        }
        [HttpPost]
        public void PostTransferCallXDoc()
        {
            _logger.Debug("TransferCallRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var transferCallRequestMsg = HubHelper.DeserializeJsonFromStream<TransferCallRequest>(reader))
                {
                    if (transferCallRequestMsg == null) return;
                    transferCallRequestMsg.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    transferCallRequestMsg.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], transferCallRequestMsg);
                }
            }
        }
    }
}