﻿using Decos.Kcs.Core.Web;
using Decos.Kcs.Links.Messages;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.Links.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        [HttpPost]
        [Throttle(Name = "PostLinkXDoc", Seconds = 1)]
        public void PostLinkXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var linkCreationOrUpdationMsg = HubHelper.DeserializeJsonFromStream<CreateOrUpdateLinkRequest>(reader))
                {
                    if (linkCreationOrUpdationMsg == null) return;
                    linkCreationOrUpdationMsg.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    linkCreationOrUpdationMsg.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], linkCreationOrUpdationMsg);
                }
            }
        }
    }
}