﻿using Decos.Kcs.Core.Web;
using Decos.Kcs.Domains.Messages;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.Domains.Web
{
    public class PostController : ApiController
    {
        [HttpPost]
        [Throttle(Name = "PostDomainXDoc", Seconds = 1)]
        public void PostDomainXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<CreateOrUpdateDomainRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
    }
}