﻿using Decos.Kcs.ContactHistory.Dtos;
using Decos.Kcs.ContactHistory.Messages;
using Decos.Kcs.Core.Messages;
using Newtonsoft.Json;
using log4net;
using System.IO;
using System.Web;
using System.Web.Http;
using System.Web.Http.Cors;
using Decos.Kcs.Core.Web;

namespace Decos.Kcs.ContactHistory.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        private ILog _logger;
        public PostController()
        {
            _logger = LogManager.GetLogger(typeof(PostController));
        }
        [HttpPost]
        [Throttle(Name = "PostContactHistoryXDoc", Seconds = 1)]
        public void PostContactHistoryXDoc()
        {
            _logger.Debug("CreateContactHistoryRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = new CreateContactHistoryRequest { SessionId = HttpContext.Current.Request.QueryString["SessionId"], UICulture = HttpContext.Current.Request.QueryString["UICulture"] })
                {
                    request.ContactHistoryDto = HubHelper.DeserializeJsonFromStream<ContactMomentDto>(reader);
                    if (request.ContactHistoryDto != null)
                        RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }

        [HttpPost]
        [Throttle(Name = "PostCreateContactHistoryReportXDoc", Seconds = 1)]
        public void PostCreateContactHistoryReportXDoc()
        {
            _logger.Debug("CreateReportRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<CreateReportRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
    }
}